/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.kgbase.application.kcalculate.controller;

import com.jxdinfo.hussar.core.exception.HussarException;
import com.jxdinfo.hussar.kgbase.application.kcalculate.model.dto.KCentralityDTO;
import com.jxdinfo.hussar.kgbase.application.kcalculate.model.dto.KCommunityDTO;
import com.jxdinfo.hussar.kgbase.application.kcalculate.model.dto.KLinkPredictDTO;
import com.jxdinfo.hussar.kgbase.application.kcalculate.model.dto.KShortestPathDTO;
import com.jxdinfo.hussar.kgbase.application.kcalculate.model.dto.KSimilarityDTO;
import com.jxdinfo.hussar.kgbase.application.kcalculate.service.KCalculateService;
import com.jxdinfo.hussar.kgbase.neo4j.model.Neo4jCalculateModel;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/kCalculate"})
public class KCalculateController {
    @Autowired
    private KCalculateService kCalculateService;

    @PostMapping(value={"/degree"})
    public ApiResponse degree(@RequestBody KCentralityDTO kCentralityDTO) {
        try {
            if (kCentralityDTO.getNode() != null && "".equals(kCentralityDTO.getNode().getNodeType())) {
                Neo4jCalculateModel node = kCentralityDTO.getNode();
                node.setNodeType(null);
                kCentralityDTO.setNode(node);
            }
            return ApiResponse.success((Object)this.kCalculateService.degree(kCentralityDTO));
        }
        catch (HussarException e) {
            e.printStackTrace();
            return ApiResponse.fail((String)e.getMessage());
        }
    }

    @PostMapping(value={"/betweenness"})
    public ApiResponse betweenness(@RequestBody KCentralityDTO kCentralityDTO) {
        try {
            if (kCentralityDTO.getNode() != null && "".equals(kCentralityDTO.getNode().getNodeType())) {
                Neo4jCalculateModel node = kCentralityDTO.getNode();
                node.setNodeType(null);
                kCentralityDTO.setNode(node);
            }
            return ApiResponse.success((Object)this.kCalculateService.betweenness(kCentralityDTO));
        }
        catch (HussarException e) {
            e.printStackTrace();
            return ApiResponse.fail((String)e.getMessage());
        }
    }

    @PostMapping(value={"/pageRank"})
    public ApiResponse pageRank(@RequestBody KCentralityDTO kCentralityDTO) {
        try {
            if (kCentralityDTO.getNode() != null && "".equals(kCentralityDTO.getNode().getNodeType())) {
                Neo4jCalculateModel node = kCentralityDTO.getNode();
                node.setNodeType(null);
                kCentralityDTO.setNode(node);
            }
            return ApiResponse.success((Object)this.kCalculateService.pageRank(kCentralityDTO));
        }
        catch (HussarException e) {
            e.printStackTrace();
            return ApiResponse.fail((String)e.getMessage());
        }
    }

    @PostMapping(value={"/louvain"})
    public ApiResponse louvain(@RequestBody KCommunityDTO kCommunityDTO) {
        try {
            return ApiResponse.success((Object)this.kCalculateService.louvain(kCommunityDTO));
        }
        catch (HussarException e) {
            e.printStackTrace();
            return ApiResponse.fail((String)e.getMessage());
        }
    }

    @PostMapping(value={"/labelPropagation"})
    public ApiResponse labelPropagation(@RequestBody KCommunityDTO kCommunityDTO) {
        try {
            return ApiResponse.success((Object)this.kCalculateService.labelPropagation(kCommunityDTO));
        }
        catch (HussarException e) {
            e.printStackTrace();
            return ApiResponse.fail((String)e.getMessage());
        }
    }

    @PostMapping(value={"/jaccard"})
    public ApiResponse jaccard(@RequestBody KSimilarityDTO kSimilarityDTO) {
        try {
            return ApiResponse.success((Object)this.kCalculateService.jaccard(kSimilarityDTO));
        }
        catch (HussarException e) {
            e.printStackTrace();
            return ApiResponse.fail((String)e.getMessage());
        }
    }

    @PostMapping(value={"/overlap"})
    public ApiResponse overlap(@RequestBody KSimilarityDTO kSimilarityDTO) {
        try {
            return ApiResponse.success((Object)this.kCalculateService.overlap(kSimilarityDTO));
        }
        catch (HussarException e) {
            e.printStackTrace();
            return ApiResponse.fail((String)e.getMessage());
        }
    }

    @PostMapping(value={"/preferentialAttachment"})
    public ApiResponse preferentialAttachment(@RequestBody KLinkPredictDTO kLinkPredictDTO) {
        try {
            return ApiResponse.success((Object)this.kCalculateService.linkPredict(kLinkPredictDTO, "preferentialAttachment"));
        }
        catch (HussarException e) {
            e.printStackTrace();
            return ApiResponse.fail((String)e.getMessage());
        }
    }

    @PostMapping(value={"/adamicAdar"})
    public ApiResponse adamicAdar(@RequestBody KLinkPredictDTO kLinkPredictDTO) {
        try {
            return ApiResponse.success((Object)this.kCalculateService.linkPredict(kLinkPredictDTO, "adamicAdar"));
        }
        catch (HussarException e) {
            e.printStackTrace();
            return ApiResponse.fail((String)e.getMessage());
        }
    }

    @PostMapping(value={"/commonNeighbors"})
    public ApiResponse commonNeighbors(@RequestBody KLinkPredictDTO kLinkPredictDTO) {
        try {
            return ApiResponse.success((Object)this.kCalculateService.linkPredict(kLinkPredictDTO, "commonNeighbors"));
        }
        catch (HussarException e) {
            e.printStackTrace();
            return ApiResponse.fail((String)e.getMessage());
        }
    }

    @PostMapping(value={"/totalNeighbors"})
    public ApiResponse totalNeighbors(@RequestBody KLinkPredictDTO kLinkPredictDTO) {
        try {
            return ApiResponse.success((Object)this.kCalculateService.linkPredict(kLinkPredictDTO, "totalNeighbors"));
        }
        catch (HussarException e) {
            e.printStackTrace();
            return ApiResponse.fail((String)e.getMessage());
        }
    }

    @PostMapping(value={"/shortestPath"})
    public ApiResponse shortestPath(@RequestBody KShortestPathDTO kShortestPathDTO) {
        try {
            return ApiResponse.success((Object)this.kCalculateService.shortestPath(kShortestPathDTO));
        }
        catch (HussarException e) {
            e.printStackTrace();
            return ApiResponse.fail((String)e.getMessage());
        }
    }
}

