/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.kgbase.application.graphquery.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.jxdinfo.hussar.kgbase.application.globalconfig.model.GlobalConfig;
import com.jxdinfo.hussar.kgbase.application.globalconfig.service.IGlobalConfigService;
import com.jxdinfo.hussar.kgbase.application.graphquery.service.GraphQueryService;
import com.jxdinfo.hussar.kgbase.application.nodeconfig.model.NodeConfig;
import com.jxdinfo.hussar.kgbase.application.nodeconfig.service.INodeConfigService;
import com.jxdinfo.hussar.kgbase.build.model.dto.NodeDTO;
import com.jxdinfo.hussar.kgbase.build.service.INodeService;
import com.jxdinfo.hussar.kgbase.neo4j.repository.GraphQueryRepository;
import com.jxdinfo.hussar.kgbase.neo4j.util.Neo4jUtil;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.neo4j.ogm.response.model.NodeModel;
import org.neo4j.ogm.response.model.RelationshipModel;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class GraphQueryServiceImpl
implements GraphQueryService {
    @Resource
    private GraphQueryRepository graphQueryRepository;
    @Resource
    private IGlobalConfigService globalConfigService;
    @Resource
    private INodeConfigService nodeConfigService;
    @Resource
    private INodeService iNodeService;
    @Value(value="${node-config.enableOntologyConfig}")
    private boolean enableOntologyConfig;

    public JSONObject totalQuery() {
        JSONObject resultObj = new JSONObject();
        List<Object> nodeList = new ArrayList();
        List<Object> relationShipList = new ArrayList();
        List<Integer> ids = this.graphQueryRepository.getImportNodes();
        Integer[] idArr = ids.toArray(new Integer[0]);
        List<Map<String, Object>> resultList = this.graphQueryRepository.getNodesAndRelationshipsWithId(idArr);
        ArrayList<NodeModel> nodes = new ArrayList<NodeModel>();
        ArrayList<RelationshipModel> relationships = new ArrayList<RelationshipModel>();
        for (Map<String, Object> map : resultList) {
            Object relationship;
            Object end;
            Object start = map.get("a");
            if (start instanceof NodeModel) {
                nodes.add((NodeModel)start);
            }
            if ((end = map.get("b")) instanceof NodeModel) {
                nodes.add((NodeModel)end);
            }
            if (!((relationship = map.get("r")) instanceof ArrayList)) continue;
            ArrayList relationshipModels = (ArrayList)relationship;
            for (Object model : relationshipModels) {
                if (!(model instanceof RelationshipModel)) continue;
                relationships.add((RelationshipModel)model);
            }
        }
        nodeList = Neo4jUtil.changeToNeo4jBasicNode(nodes);
        relationShipList = Neo4jUtil.changeToNeo4jQueryRelation(relationships);
        resultObj.put("nodes", nodeList);
        resultObj.put("edges", relationShipList);
        return resultObj;
    }

    public JSONObject getNodesAndRelationshipsByNodeName(String nodeName) {
        JSONObject resultObj = new JSONObject();
        List<Object> nodeList = new ArrayList();
        List<Object> relationShipList = new ArrayList();
        List<Map<String, Object>> resultList = this.graphQueryRepository.getNodesAndRelationshipsByNodeName(nodeName);
        ArrayList<NodeModel> nodes = new ArrayList<NodeModel>();
        ArrayList<RelationshipModel> relationships = new ArrayList<RelationshipModel>();
        for (Map<String, Object> map : resultList) {
            Object relationship;
            Object end;
            Object start = map.get("a");
            if (start instanceof NodeModel) {
                nodes.add((NodeModel)start);
            }
            if ((end = map.get("b")) instanceof NodeModel) {
                nodes.add((NodeModel)end);
            }
            if (!((relationship = map.get("r")) instanceof ArrayList)) continue;
            ArrayList relationshipModels = (ArrayList)relationship;
            for (Object model : relationshipModels) {
                if (!(model instanceof RelationshipModel)) continue;
                relationships.add((RelationshipModel)model);
            }
        }
        nodeList = Neo4jUtil.changeToNeo4jBasicNode(nodes);
        relationShipList = Neo4jUtil.changeToNeo4jQueryRelation(relationships);
        resultObj.put("nodes", nodeList);
        resultObj.put("edges", relationShipList);
        return resultObj;
    }

    public JSONObject totalQueryInRedis() {
        return (JSONObject)HussarCacheUtil.get((String)"GraphQuery", (Object)"totalQueryInRedis");
    }

    public void setTotalQueryToRedis(JSONObject json) {
        HussarCacheUtil.put((String)"GraphQuery", (Object)"totalQueryInRedis", (Object)json, (long)180L);
    }

    public void deleteTotalQueryRedis() {
        HussarCacheUtil.evict((String)"GraphQuery", (Object)"totalQueryInRedis");
    }

    public JSONObject getLabelsAndTypes() {
        JSONObject resultObj = new JSONObject();
        List<Map<String, Object>> labelList = this.graphQueryRepository.getNodeLabels();
        List<Map<String, Object>> typeList = this.graphQueryRepository.getRelationshipTypes();
        QueryWrapper gcQueryWrapper = new QueryWrapper();
        gcQueryWrapper.eq((Object)"STATUS", (Object)1);
        HashMap<String, String> colorConfigMap = new HashMap<String, String>();
        if (this.enableOntologyConfig) {
            List nodeDTOS = (List)this.iNodeService.getAllNodes().get("nodes");
            for (NodeDTO node : nodeDTOS) {
                colorConfigMap.put(node.getConcept().getConceptName(), node.getNodeColor());
            }
        } else {
            GlobalConfig gConfig = (GlobalConfig)this.globalConfigService.getOne((Wrapper)gcQueryWrapper);
            List ncConfigs = this.nodeConfigService.getConfigList(gConfig.getVersion());
            for (NodeConfig nodeConfig : ncConfigs) {
                colorConfigMap.put(nodeConfig.getLabel(), nodeConfig.getFill());
            }
        }
        for (Map<String, Object> labelMap : labelList) {
            labelMap.put("color", colorConfigMap.get(labelMap.get("type")));
        }
        resultObj.put("labels", labelList);
        resultObj.put("types", typeList);
        return resultObj;
    }

    public JSONObject getDirectPathByNode(Long id) {
        JSONObject resultObj = new JSONObject();
        List<Object> nodeList = new ArrayList();
        List<Object> relationShipList = new ArrayList();
        List<Map<String, Object>> resultList = this.graphQueryRepository.getDirectPathByNode(id);
        if (resultList.size() == 0) {
            resultList = this.graphQueryRepository.getSingleNode(id);
        }
        ArrayList<NodeModel> nodes = new ArrayList<NodeModel>();
        ArrayList<RelationshipModel> relationships = new ArrayList<RelationshipModel>();
        int i = 0;
        HashMap<Long, Long> relationIdMap = new HashMap<Long, Long>();
        for (Map<String, Object> map : resultList) {
            Object relationship;
            Object start;
            if (i == 0 && (start = map.get("a")) instanceof NodeModel) {
                nodes.add((NodeModel)start);
            }
            if ((start = map.get("b")) instanceof NodeModel) {
                nodes.add((NodeModel)start);
                List<Map<String, Object>> nodeAndRelationResultList = this.graphQueryRepository.getDirectPathByNode(((NodeModel)start).getId());
                for (Map<String, Object> resultmap : nodeAndRelationResultList) {
                    Object endRelationship = resultmap.get("r");
                    if (!(endRelationship instanceof ArrayList)) continue;
                    ArrayList relationshipModels = (ArrayList)endRelationship;
                    for (Object model : relationshipModels) {
                        if (!(model instanceof RelationshipModel) || relationIdMap.get(((RelationshipModel)model).getId()) != null) continue;
                        relationships.add((RelationshipModel)model);
                        relationIdMap.put(((RelationshipModel)model).getId(), ((RelationshipModel)model).getId());
                    }
                }
            }
            if ((relationship = map.get("r")) instanceof ArrayList) {
                ArrayList relationshipModels = (ArrayList)relationship;
                for (Object model : relationshipModels) {
                    if (relationIdMap.get(((RelationshipModel)model).getId()) != null) continue;
                    relationships.add((RelationshipModel)model);
                    relationIdMap.put(((RelationshipModel)model).getId(), ((RelationshipModel)model).getId());
                }
            }
            ++i;
        }
        nodeList = Neo4jUtil.changeToNeo4jBasicNode(nodes);
        relationShipList = Neo4jUtil.changeToNeo4jQueryRelation(relationships);
        resultObj.put("nodes", nodeList);
        resultObj.put("edges", relationShipList);
        return resultObj;
    }

    public JSONObject getDirectThreePathByNode(Long id) {
        JSONObject resultObj = new JSONObject();
        List<Object> nodeList = new ArrayList();
        List<Object> relationShipList = new ArrayList();
        List<Map<String, Object>> resultList = this.graphQueryRepository.getDirectThreePathByNode(id);
        if (resultList.size() == 0) {
            resultList = this.graphQueryRepository.getSingleNode(id);
        }
        ArrayList<NodeModel> nodes = new ArrayList<NodeModel>();
        ArrayList<RelationshipModel> relationships = new ArrayList<RelationshipModel>();
        int i = 0;
        HashMap<Long, Long> relationIdMap = new HashMap<Long, Long>();
        for (Map<String, Object> map : resultList) {
            Object relationship;
            Object start;
            if (i == 0 && (start = map.get("a")) instanceof NodeModel) {
                nodes.add((NodeModel)start);
            }
            if ((start = map.get("b")) instanceof NodeModel) {
                nodes.add((NodeModel)start);
                List<Map<String, Object>> nodeAndRelationResultList = this.graphQueryRepository.getDirectPathByNode(((NodeModel)start).getId());
                for (Map<String, Object> resultmap : nodeAndRelationResultList) {
                    Object endRelationship = resultmap.get("r");
                    if (!(endRelationship instanceof ArrayList)) continue;
                    ArrayList relationshipModels = (ArrayList)endRelationship;
                    for (Object model : relationshipModels) {
                        if (!(model instanceof RelationshipModel) || relationIdMap.get(((RelationshipModel)model).getId()) != null) continue;
                        relationships.add((RelationshipModel)model);
                        relationIdMap.put(((RelationshipModel)model).getId(), ((RelationshipModel)model).getId());
                    }
                }
            }
            if ((relationship = map.get("r")) instanceof ArrayList) {
                ArrayList relationshipModels = (ArrayList)relationship;
                for (Object model : relationshipModels) {
                    if (relationIdMap.get(((RelationshipModel)model).getId()) != null) continue;
                    relationships.add((RelationshipModel)model);
                    relationIdMap.put(((RelationshipModel)model).getId(), ((RelationshipModel)model).getId());
                }
            }
            ++i;
        }
        nodeList = Neo4jUtil.changeToNeo4jBasicNode(nodes);
        relationShipList = Neo4jUtil.changeToNeo4jQueryRelation(relationships);
        resultObj.put("nodes", nodeList);
        resultObj.put("edges", relationShipList);
        return resultObj;
    }

    public JSONObject getHumanResourcesData(Long id) {
        JSONObject resultObj = new JSONObject();
        List<Object> nodeList = new ArrayList();
        List<Object> relationShipList = new ArrayList();
        List<Map<String, Object>> resultList = this.graphQueryRepository.getHumanResourcesData(id);
        ArrayList<NodeModel> nodes = new ArrayList<NodeModel>();
        ArrayList<RelationshipModel> relationships = new ArrayList<RelationshipModel>();
        for (Map<String, Object> map : resultList) {
            Object relationship;
            Object end;
            Object start = map.get("a");
            if (start instanceof NodeModel) {
                nodes.add((NodeModel)start);
            }
            if ((end = map.get("b")) instanceof NodeModel) {
                nodes.add((NodeModel)end);
            }
            if (!((relationship = map.get("r")) instanceof ArrayList)) continue;
            ArrayList relationshipModels = (ArrayList)relationship;
            for (Object model : relationshipModels) {
                if (!(model instanceof RelationshipModel)) continue;
                relationships.add((RelationshipModel)model);
            }
        }
        nodeList = Neo4jUtil.changeToNeo4jBasicNode(nodes);
        relationShipList = Neo4jUtil.changeToNeo4jQueryRelation(relationships);
        resultObj.put("nodes", nodeList);
        resultObj.put("edges", relationShipList);
        return resultObj;
    }
}

