/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.kgbase.application.graphquery.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.jxdinfo.hussar.core.base.controller.BaseController;
import com.jxdinfo.hussar.core.exception.HussarException;
import com.jxdinfo.hussar.kgbase.application.graphquery.service.GraphQueryService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/graphQuery"})
public class GraphQueryController
extends BaseController {
    @Autowired
    private GraphQueryService graphQueryService;

    @GetMapping(value={"/totalQuery"})
    public ApiResponse totalQuery() {
        try {
            return ApiResponse.success((Object)this.graphQueryService.totalQuery());
        }
        catch (HussarException e) {
            e.printStackTrace();
            return ApiResponse.fail((String)e.getMessage());
        }
    }

    @GetMapping(value={"/totalQueryInRedis"})
    public ApiResponse totalQueryInRedis() {
        try {
            return ApiResponse.success((Object)this.graphQueryService.totalQueryInRedis());
        }
        catch (HussarException e) {
            e.printStackTrace();
            return ApiResponse.fail((String)e.getMessage());
        }
    }

    @PostMapping(value={"/setTotalQueryToRedis"})
    public ApiResponse setTotalQueryToRedis(@RequestBody JSONObject json) {
        try {
            this.graphQueryService.setTotalQueryToRedis(json);
            return ApiResponse.success();
        }
        catch (HussarException e) {
            e.printStackTrace();
            return ApiResponse.fail((String)e.getMessage());
        }
    }

    @PostMapping(value={"/deleteTotalQueryRedis"})
    public ApiResponse deleteTotalQueryRedis() {
        try {
            this.graphQueryService.deleteTotalQueryRedis();
            return ApiResponse.success();
        }
        catch (HussarException e) {
            e.printStackTrace();
            return ApiResponse.fail((String)e.getMessage());
        }
    }

    @GetMapping(value={"/getNodesAndRelationshipsByNodeName"})
    public ApiResponse getNodesAndRelationshipsByNodeName(String nodeName) {
        try {
            if (StringUtils.isEmpty((CharSequence)nodeName)) {
                nodeName = "\u5b89\u5168\u7ba1\u7406\u4f53\u7cfb";
            }
            return ApiResponse.success((Object)this.graphQueryService.getNodesAndRelationshipsByNodeName(nodeName));
        }
        catch (HussarException e) {
            e.printStackTrace();
            return ApiResponse.fail((String)e.getMessage());
        }
    }

    @GetMapping(value={"/getLabelsAndTypes"})
    public ApiResponse getLabelsAndTypes() {
        try {
            return ApiResponse.success((Object)this.graphQueryService.getLabelsAndTypes());
        }
        catch (HussarException e) {
            e.printStackTrace();
            return ApiResponse.fail((String)e.getMessage());
        }
    }

    @GetMapping(value={"/getDirectPathByNode"})
    public ApiResponse getDirectPathByNode(@RequestParam Long id) {
        try {
            return ApiResponse.success((Object)this.graphQueryService.getDirectPathByNode(id));
        }
        catch (HussarException e) {
            e.printStackTrace();
            return ApiResponse.fail((String)e.getMessage());
        }
    }

    @GetMapping(value={"/getDirectThreePathByNode"})
    public ApiResponse getDirectThreePathByNode(@RequestParam Long id) {
        try {
            return ApiResponse.success((Object)this.graphQueryService.getDirectThreePathByNode(id));
        }
        catch (HussarException e) {
            e.printStackTrace();
            return ApiResponse.fail((String)e.getMessage());
        }
    }

    @GetMapping(value={"/getHumanResourcesData"})
    public ApiResponse getHumanResourcesData() {
        try {
            return ApiResponse.success((Object)this.graphQueryService.getHumanResourcesData(Long.valueOf(124869L)));
        }
        catch (HussarException e) {
            e.printStackTrace();
            return ApiResponse.fail((String)e.getMessage());
        }
    }
}

