/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.kgbase.application.globalconfig.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.kgbase.application.globalconfig.dao.GlobalConfigMapper;
import com.jxdinfo.hussar.kgbase.application.globalconfig.model.GlobalConfig;
import com.jxdinfo.hussar.kgbase.application.globalconfig.service.IGlobalConfigService;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Service;

@Service
public class GlobalConfigServiceImpl
extends ServiceImpl<GlobalConfigMapper, GlobalConfig>
implements IGlobalConfigService {
    public List<GlobalConfig> getConfigList(String name) {
        QueryWrapper ew = new QueryWrapper();
        if (ToolUtil.isNotEmpty((Object)name)) {
            ew.like((Object)"NAME", (Object)name);
        }
        ew.orderByDesc((Object)"STATUS");
        ew.orderByAsc((Object)"CREATE_TIME");
        return this.list((Wrapper)ew);
    }

    public Map<String, Object> saveConfig(GlobalConfig globalConfig) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        boolean success = true;
        String msg = "";
        boolean addFlag = true;
        Long configId = globalConfig.getId();
        if (ToolUtil.isNotEmpty((Object)configId)) {
            addFlag = false;
        }
        SecurityUser user = BaseSecurityUtil.getUser();
        Long userId = null;
        if (user != null) {
            userId = user.getId();
        }
        Timestamp date = new Timestamp(System.currentTimeMillis());
        if (addFlag) {
            Map<String, Object> tmp = this.generateVersion();
            boolean flag = (Boolean)tmp.get("success");
            if (!flag) {
                success = false;
                msg = tmp.get("msg").toString();
                result.put("success", success);
                result.put("msg", msg);
                return result;
            }
            String version = tmp.get("version").toString();
            globalConfig.setVersion(version);
            globalConfig.setStatus("0");
            globalConfig.setCreator(userId);
            globalConfig.setCreateTime((Date)date);
        } else {
            globalConfig.setLastEditor(userId);
            globalConfig.setLastTime((Date)date);
        }
        success = this.saveOrUpdate(globalConfig);
        if (!success) {
            msg = "\u4fdd\u5b58\u5931\u8d25";
        }
        result.put("success", success);
        result.put("msg", msg);
        return result;
    }

    public GlobalConfig getCurrentConfig() {
        QueryWrapper ew = new QueryWrapper();
        ew.eq((Object)"STATUS", (Object)"1");
        return (GlobalConfig)this.getOne((Wrapper)ew, false);
    }

    public boolean enableConfig(Long id) {
        QueryWrapper ew = new QueryWrapper();
        ew.eq((Object)"STATUS", (Object)"1");
        GlobalConfig globalConfig = new GlobalConfig();
        globalConfig.setStatus("0");
        this.update(globalConfig, (Wrapper)ew);
        GlobalConfig tmp = new GlobalConfig();
        tmp.setId(id);
        tmp.setStatus("1");
        return tmp.updateById();
    }

    public Map<String, Object> deleteConfig(Long id) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        boolean success = true;
        String msg = "";
        GlobalConfig globalConfig = (GlobalConfig)this.getById(id);
        String status = globalConfig.getStatus();
        if ("1".equals(status)) {
            success = false;
            msg = "\u542f\u7528\u4e2d\u7684\u914d\u7f6e\u65e0\u6cd5\u5220\u9664";
        } else {
            success = this.removeById(id);
            if (!success) {
                msg = "\u5220\u9664\u5931\u8d25";
            }
        }
        result.put("success", success);
        result.put("msg", msg);
        return result;
    }

    private Map<String, Object> generateVersion() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        boolean success = true;
        String msg = "";
        String version = "";
        Date d = new Date();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
        String date = sdf.format(d);
        QueryWrapper ew = new QueryWrapper();
        ew.likeRight((Object)"VERSION", (Object)date);
        ew.orderByDesc((Object)"VERSION");
        GlobalConfig globalConfig = (GlobalConfig)this.getOne((Wrapper)ew, false);
        if (globalConfig != null) {
            String maxVersion = globalConfig.getVersion();
            version = String.valueOf(Long.parseLong(maxVersion) + 1L);
            if (version.length() > 10) {
                success = false;
                msg = "\u7248\u672c\u53f7\u751f\u6210\u5931\u8d25\uff0c\u7248\u672c\u53f7\u8d85\u957f";
            }
        } else {
            version = date + "01";
        }
        result.put("success", success);
        result.put("msg", msg);
        result.put("version", version);
        return result;
    }
}

