/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.kgbase.application.disasterdata.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.kgbase.application.disasterdata.service.DisasterDataService;
import com.jxdinfo.hussar.kgbase.neo4j.repository.DisasterDataRepository;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DisasterDataServiceImpl
implements DisasterDataService {
    @Autowired
    DisasterDataRepository disasterDataRepository;
    private int id;

    private Map<String, Object> createNode(Object id, Object label, boolean hasChild) {
        HashMap<String, Object> res = new HashMap<String, Object>();
        res.put("id", id);
        res.put("label", label);
        if (hasChild) {
            ArrayList list = new ArrayList();
            res.put("children", list);
        }
        return res;
    }

    private Object getProperty(Object obj, String property) {
        return obj instanceof Map ? ((Map)obj).get(property) : null;
    }

    private Object setProperty(Object obj, String property, Object value) {
        return obj instanceof Map ? ((Map)obj).put(property, value) : null;
    }

    private int getId() {
        return ++this.id;
    }

    public static boolean isInteger(String str) {
        try {
            Integer.parseInt(str);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public JSONObject getDisasterDataByDisasterAndCity(String disasterName, String city) {
        JSONObject resultObj = new JSONObject();
        this.id = 0;
        Map<String, Object> disaster = this.disasterDataRepository.getNodeByName(disasterName).get(0);
        String date = "\u65f6\u95f4\uff1a" + this.getProperty(disaster.get("properties"), "\u5f00\u59cb\u65f6\u95f4") + " ~ " + this.getProperty(disaster.get("properties"), "\u7ed3\u675f\u65f6\u95f4");
        List<Map<String, Object>> list = this.disasterDataRepository.getDisasterDataByDisasterAndCity(disasterName, city);
        Map<String, Object> data = this.createNode(disaster.get("id"), disaster.get("name"), true);
        Map<String, Object> message = this.createNode(this.getId(), "\u8be6\u7ec6\u4fe1\u606f", true);
        ((List)data.get("children")).add(message);
        Map<String, Object> time = this.createNode(this.getId(), date, false);
        Object windForce = this.getProperty(disaster.get("properties"), "\u98ce\u529b");
        Object rainForce = this.getProperty(disaster.get("properties"), "\u964d\u6c34\u91cf");
        Map<String, Object> cityName = this.createNode(this.getId(), "\u57ce\u5e02\uff1a" + city, false);
        ((List)message.get("children")).add(time);
        if (windForce != null) {
            ((List)message.get("children")).add(this.createNode(this.getId(), "\u98ce\u529b\uff1a" + windForce.toString(), false));
        }
        if (rainForce != null) {
            ((List)message.get("children")).add(this.createNode(this.getId(), "\u964d\u6c34\u91cf\uff1a" + rainForce.toString(), false));
        }
        ((List)message.get("children")).add(cityName);
        Map<String, Object> zshs = this.createNode(this.getId(), "\u707e\u635f\u6c47\u603b", true);
        ((List)data.get("children")).add(zshs);
        Map<String, Object> gtl = this.createNode(this.getId(), "\u6746\u5854\u7c7b", true);
        Map<String, Object> zfl = this.createNode(this.getId(), "\u7ad9\u623f\u7c7b", true);
        Map<String, Object> other = this.createNode(this.getId(), "\u5176\u4ed6", false);
        ((List)zshs.get("children")).add(gtl);
        ((List)zshs.get("children")).add(zfl);
        ((List)zshs.get("children")).add(other);
        int index = 0;
        for (Map<String, Object> map : list) {
            if (this.getProperty(map.get("data"), "name").toString().contains("\u5176\u4ed6")) {
                this.setProperty(((List)zshs.get("children")).get(index), "label", "\u5176\u4ed6\uff1a" + this.getProperty(map.get("data"), "\u603b\u91cf"));
                continue;
            }
            int sum = 0;
            Map map1 = (Map)map.get("data");
            for (String key : map1.keySet()) {
                if (!DisasterDataServiceImpl.isInteger(map1.get(key).toString())) continue;
                sum += Integer.parseInt(map1.get(key).toString());
                Map<String, Object> tmp = this.createNode(this.getId(), key + "\uff1a" + map1.get(key), false);
                ((List)((Map)((List)zshs.get("children")).get(index)).get("children")).add(tmp);
            }
            String title = map1.get("name").toString();
            this.setProperty(((List)zshs.get("children")).get(index), "label", title.split("-")[title.split("-").length - 1] + "\uff1a" + sum);
            ++index;
        }
        resultObj.put("data", data);
        return resultObj;
    }

    public JSONObject getFeederDataByFeederName(String feederName) {
        JSONObject resultObj = new JSONObject();
        this.id = 0;
        List<Map<String, Object>> list = this.disasterDataRepository.getFeederDataByFeederName(feederName);
        Map<String, Object> message = this.createNode(this.getId(), feederName, true);
        for (Map<String, Object> map : list) {
            Map data = (Map)map.get("data");
            Map<String, Object> tmp = this.createNode(this.getId(), data.get("name"), true);
            for (String key : data.keySet()) {
                if ("name".equals(key)) continue;
                ((List)tmp.get("children")).add(this.createNode(this.getId(), key + "\uff1a" + (String)data.get(key), false));
            }
            ((List)message.get("children")).add(tmp);
        }
        resultObj.put("data", message);
        return resultObj;
    }
}

