/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.kgbase.application.casebase.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.core.exception.HussarException;
import com.jxdinfo.hussar.kgbase.application.casebase.dao.CaseBaseMapper;
import com.jxdinfo.hussar.kgbase.application.casebase.model.dto.CaseBaseDTO;
import com.jxdinfo.hussar.kgbase.application.casebase.model.po.CaseBase;
import com.jxdinfo.hussar.kgbase.application.casebase.model.vo.CaseBaseVO;
import com.jxdinfo.hussar.kgbase.application.casebase.service.ICaseBaseService;
import com.jxdinfo.hussar.kgbase.common.util.pdfUtil.PngImgUtil;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Date;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
public class CaseBaseServiceImpl
extends ServiceImpl<CaseBaseMapper, CaseBase>
implements ICaseBaseService {
    @Resource
    private CaseBaseMapper caseBaseMapper;

    public ApiResponse getCaseBaseList(CaseBaseDTO caseBaseDTO) {
        Page page = new Page();
        if (caseBaseDTO.getCurrent() == null) {
            caseBaseDTO.setCurrent(Integer.valueOf(1));
        }
        if (caseBaseDTO.getSize() == null) {
            caseBaseDTO.setSize(Integer.valueOf(10));
        }
        page.setCurrent((long)caseBaseDTO.getCurrent().intValue());
        page.setSize((long)caseBaseDTO.getSize().intValue());
        QueryWrapper queryWrapper = new QueryWrapper();
        if (caseBaseDTO.getCaseTitle() != null) {
            queryWrapper.like((Object)"CASE_TITLE", (Object)caseBaseDTO.getCaseTitle());
        }
        if (caseBaseDTO.getPageType() != null) {
            queryWrapper.eq((Object)"PAGE_TYPE", (Object)caseBaseDTO.getPageType());
        }
        if (caseBaseDTO.getTabType() != null) {
            queryWrapper.eq((Object)"TAB_TYPE", (Object)caseBaseDTO.getTabType());
        }
        queryWrapper.eq((Object)"DEL_FLAG", (Object)"0");
        queryWrapper.orderByDesc((Object)"LAST_TIME");
        page = (Page)this.page((IPage)page, (Wrapper)queryWrapper);
        return ApiResponse.success((Object)page);
    }

    public ApiResponse getCaseBaseById(String id) {
        CaseBaseVO caseBaseVO = new CaseBaseVO();
        try {
            CaseBase caseBase = (CaseBase)this.getById((Serializable)((Object)id));
            BeanUtils.copyProperties((Object)caseBase, (Object)caseBaseVO);
            String queryConditionsStr = caseBase.getQueryConditions();
            caseBaseVO.setQueryConditions(JSONObject.parseObject((String)queryConditionsStr));
        }
        catch (HussarException e) {
            e.printStackTrace();
            return ApiResponse.fail((String)e.getMessage());
        }
        return ApiResponse.success((Object)caseBaseVO);
    }

    public ApiResponse saveOrUpdateCaseBase(CaseBaseDTO caseBaseDTO) {
        String imagesUrl;
        String size200k;
        Date date = new Date();
        SecurityUser user = BaseSecurityUtil.getUser();
        CaseBase caseBase = new CaseBase();
        BeanUtils.copyProperties((Object)caseBaseDTO, (Object)caseBase);
        JSONObject queryJson = caseBaseDTO.getQueryConditions();
        caseBase.setQueryConditions(queryJson.toJSONString());
        if (caseBase != null && StringUtils.isNotEmpty((CharSequence)caseBase.getImageUrl()) && (size200k = PngImgUtil.resizeImageTo200K(imagesUrl = caseBase.getImageUrl())) != null) {
            caseBase.setImageUrl(size200k);
        }
        try {
            caseBase.setLastTime(date);
            if (user != null) {
                caseBase.setLastEditor(user.getId());
            }
            if (caseBase.getId() != null) {
                this.updateById(caseBase);
            } else {
                caseBase.setCreateTime(date);
                if (user != null) {
                    caseBase.setCreator(user.getId());
                    caseBase.setCreatorName(user.getUserName());
                }
                this.save(caseBase);
            }
            return ApiResponse.success((String)"\u6848\u4f8b\u4fdd\u5b58\u6210\u529f\uff01");
        }
        catch (HussarException e) {
            e.printStackTrace();
            return ApiResponse.fail((String)e.getMessage());
        }
    }

    public ApiResponse removeCaseBases(String ids) {
        String[] idArr = ids.split(",");
        try {
            this.caseBaseMapper.deleteByIds(Arrays.asList(idArr));
            return ApiResponse.success((String)"\u6848\u4f8b\u5220\u9664\u6210\u529f\uff01");
        }
        catch (HussarException e) {
            e.printStackTrace();
            return ApiResponse.fail((String)e.getMessage());
        }
    }
}

