/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.kgbase.algomodel.util;

import java.io.IOException;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.websocket.OnClose;
import javax.websocket.OnError;
import javax.websocket.OnMessage;
import javax.websocket.OnOpen;
import javax.websocket.Session;
import javax.websocket.server.ServerEndpoint;
import org.springframework.stereotype.Component;

@ServerEndpoint(value="/peWebSocket")
@Component
public class PeWebSocket {
    private static final CopyOnWriteArraySet<PeWebSocket> RE_WEB_SOCKET_SET = new CopyOnWriteArraySet();
    private Session session;

    public static Set<PeWebSocket> getReWebSocketSet() {
        return RE_WEB_SOCKET_SET;
    }

    @OnOpen
    public void onOpen(Session session) throws IOException {
        this.session = session;
        RE_WEB_SOCKET_SET.add(this);
        System.out.print("\u5c5e\u6027\u62bd\u53d6\u6a21\u578b\u8bad\u7ec3\u65e5\u5fd7--\u7cfb\u7edf\u8fde\u63a5\u6210\u529f");
    }

    @OnClose
    public void onClose() {
        RE_WEB_SOCKET_SET.remove(this);
    }

    @OnMessage
    public void onMessage(String message) {
        for (PeWebSocket item : RE_WEB_SOCKET_SET) {
            try {
                item.sendMessage(message);
            }
            catch (IOException e) {
                System.out.print("\u6d88\u606f\u53d1\u9001\u5931\u8d25");
            }
        }
    }

    @OnError
    public void onError(Session session, Throwable error) {
        System.out.print("\u65ad\u5f00\u8fde\u63a5");
    }

    public void sendMessage(String message) throws IOException {
        for (PeWebSocket item : RE_WEB_SOCKET_SET) {
            if (!item.session.isOpen()) continue;
            item.session.getBasicRemote().sendText(message);
        }
    }
}

