/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.kgbase.algomodel.service.impl;

import cn.hutool.core.bean.BeanUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jxdinfo.hussar.kgbase.algomodel.dao.TrainNoteMapper;
import com.jxdinfo.hussar.kgbase.algomodel.model.po.TrainNote;
import com.jxdinfo.hussar.kgbase.algomodel.model.po.TrainTask;
import com.jxdinfo.hussar.kgbase.algomodel.model.vo.TrainTaskVO;
import com.jxdinfo.hussar.kgbase.algomodel.service.ITrainNoteService;
import com.jxdinfo.hussar.kgbase.algomodel.service.ITrainTaskService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class TrainNoteServiceImpl
extends ServiceImpl<TrainNoteMapper, TrainNote>
implements ITrainNoteService {
    @Resource
    private ITrainTaskService iTrainTaskService;

    public ApiResponse getTrainNotesById(String taskId) {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"TRAIN_TASK_ID", (Object)taskId);
        wrapper.gt((Object)"PRECISION_RATE", (Object)0);
        wrapper.gt((Object)"ACCURACY", (Object)0);
        wrapper.gt((Object)"RECALL", (Object)0);
        wrapper.gt((Object)"F_MEASURE", (Object)0);
        wrapper.eq((Object)"DEL_FLAG", (Object)"0");
        wrapper.orderByAsc((Object)"CURRENT_EPOCH");
        List trainNotes = this.list((Wrapper)wrapper);
        HashMap echartsData = new HashMap();
        HashMap precisionRateMap = new HashMap();
        HashMap accuracyMap = new HashMap();
        HashMap recallMap = new HashMap();
        HashMap f1Map = new HashMap();
        ArrayList<Integer> xList = new ArrayList<Integer>();
        ArrayList<Double> precisionList = new ArrayList<Double>();
        ArrayList<Double> accuracyList = new ArrayList<Double>();
        ArrayList<Double> recallList = new ArrayList<Double>();
        ArrayList<Double> f1List = new ArrayList<Double>();
        DecimalFormat df = new DecimalFormat("#.000");
        for (TrainNote trainNote : trainNotes) {
            xList.add(trainNote.getCurrentEpoch());
            precisionList.add(Double.parseDouble(df.format(trainNote.getPrecisionRate())));
            accuracyList.add(Double.parseDouble(df.format(trainNote.getAccuracy())));
            recallList.add(Double.parseDouble(df.format(trainNote.getRecall())));
            f1List.add(Double.parseDouble(df.format(trainNote.getF1())));
        }
        precisionRateMap.put("y", precisionList);
        precisionRateMap.put("x", xList);
        accuracyMap.put("y", accuracyList);
        accuracyMap.put("x", xList);
        recallMap.put("y", recallList);
        recallMap.put("x", xList);
        f1Map.put("y", f1List);
        f1Map.put("x", xList);
        echartsData.put("precisionRate", precisionRateMap);
        echartsData.put("accuracy", accuracyMap);
        echartsData.put("recall", recallMap);
        echartsData.put("f1", f1Map);
        return ApiResponse.success(echartsData);
    }

    public ApiResponse<TrainTaskVO> getFinalTrainResult(String taskId) {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"TRAIN_TASK_ID", (Object)taskId);
        wrapper.gt((Object)"PRECISION_RATE", (Object)0);
        wrapper.gt((Object)"ACCURACY", (Object)0);
        wrapper.gt((Object)"RECALL", (Object)0);
        wrapper.gt((Object)"F_MEASURE", (Object)0);
        wrapper.eq((Object)"DEL_FLAG", (Object)"0");
        wrapper.orderByAsc((Object)"CURRENT_EPOCH");
        List trainNotes = this.list((Wrapper)wrapper);
        TrainTaskVO taskVO = new TrainTaskVO();
        TrainTask task = (TrainTask)this.iTrainTaskService.getById((Serializable)((Object)taskId));
        BeanUtil.copyProperties((Object)task, (Object)taskVO, (String[])new String[0]);
        for (TrainNote note : trainNotes) {
            if (!note.getIsBest().equals("1")) continue;
            taskVO.setTrainResult(note);
        }
        Date trainStartDate = taskVO.getTrainStartTime();
        Date trainEndDate = taskVO.getTrainEndTime();
        if (trainStartDate != null && trainEndDate != null) {
            taskVO.setTimeConsumption(this.getDatePoor(trainEndDate, trainStartDate));
        }
        return ApiResponse.success((Object)taskVO);
    }

    public String getDatePoor(Date endDate, Date nowDate) {
        long nd = 86400000L;
        long nh = 3600000L;
        long nm = 60000L;
        long ns = 1000L;
        long diff = endDate.getTime() - nowDate.getTime();
        long day = diff / nd;
        long hour = diff % nd / nh;
        long min = diff % nd % nh / nm;
        long sec = diff % nd % nh % nm / ns;
        return day + "\u5929" + hour + "\u5c0f\u65f6" + min + "\u5206\u949f" + sec + "\u79d2";
    }
}

