/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.kgbase.algomodel.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jxdinfo.hussar.core.exception.HussarException;
import com.jxdinfo.hussar.kgbase.algomodel.dao.TrainModelMapper;
import com.jxdinfo.hussar.kgbase.algomodel.model.dto.TrainModelDTO;
import com.jxdinfo.hussar.kgbase.algomodel.model.po.TrainModel;
import com.jxdinfo.hussar.kgbase.algomodel.service.ITrainModelService;
import com.jxdinfo.hussar.kgbase.algomodel.service.NerService;
import com.jxdinfo.hussar.kgbase.algomodel.service.PeService;
import com.jxdinfo.hussar.kgbase.algomodel.service.ReService;
import com.jxdinfo.hussar.kgbase.common.util.HttpUtil;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import java.io.Serializable;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class TrainModelServiceImpl
extends ServiceImpl<TrainModelMapper, TrainModel>
implements ITrainModelService {
    @Resource
    private NerService nerService;
    @Resource
    private ReService reService;
    @Resource
    private PeService peService;
    @Value(value="${model-config.ner-exit-api}")
    private String nerExitApi;
    @Value(value="${model-config.re-exit-api}")
    private String reExitApi;
    @Value(value="${model-config.pe-exit-api}")
    private String peExitApi;

    public ApiResponse listByPage(TrainModelDTO trainModelDTO) {
        Page page = new Page();
        if (trainModelDTO.getCurrent() == null) {
            trainModelDTO.setCurrent(Integer.valueOf(1));
        }
        if (trainModelDTO.getSize() == null) {
            trainModelDTO.setSize(Integer.valueOf(10));
        }
        page.setCurrent((long)trainModelDTO.getCurrent().intValue());
        page.setSize((long)trainModelDTO.getSize().intValue());
        QueryWrapper queryWrapper = new QueryWrapper();
        if (trainModelDTO.getModelName() != null) {
            queryWrapper.like((Object)"MODEL_NAME", (Object)trainModelDTO.getModelName());
        }
        if (trainModelDTO.getTrainTaskName() != null) {
            queryWrapper.like((Object)"TRAIN_TASK_NAME", (Object)trainModelDTO.getTrainTaskName());
        }
        if (trainModelDTO.getIdentityRange() != null) {
            queryWrapper.eq((Object)"IDENTITY_RANGE", (Object)trainModelDTO.getIdentityRange());
        }
        if (trainModelDTO.getModelType() != null) {
            queryWrapper.eq((Object)"MODEL_TYPE", (Object)trainModelDTO.getModelType());
        }
        if (trainModelDTO.getModelState() != null) {
            queryWrapper.eq((Object)"MODEL_STATE", (Object)trainModelDTO.getModelState());
        }
        queryWrapper.eq((Object)"DEL_FLAG", (Object)"0");
        queryWrapper.orderByDesc((Object)"CREATE_TIME");
        page = (Page)this.page((IPage)page, (Wrapper)queryWrapper);
        return ApiResponse.success((Object)page);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ApiResponse changeState(TrainModelDTO trainModelDTO) {
        TrainModel model = (TrainModel)this.getById((Serializable)((Object)trainModelDTO.getId()));
        if ("1".equals(trainModelDTO.getModelState())) {
            QueryWrapper sameTypeQuery = new QueryWrapper();
            sameTypeQuery.eq((Object)"MODEL_STATE", (Object)"1");
            sameTypeQuery.eq((Object)"DEL_FLAG", (Object)"0");
            sameTypeQuery.eq((Object)"MODEL_TYPE", (Object)model.getModelType());
            List list = this.list((Wrapper)sameTypeQuery);
            if (list.size() > 0) {
                return ApiResponse.fail((String)"\u5df2\u90e8\u7f72\u540c\u7c7b\u578b\u7684\u6a21\u578b\u670d\u52a1\uff01");
            }
            QueryWrapper waitingQuery = new QueryWrapper();
            waitingQuery.eq((Object)"DEL_FLAG", (Object)"0");
            waitingQuery.eq((Object)"MODEL_STATE", (Object)"2");
            list = this.list((Wrapper)waitingQuery);
            if (list.size() > 0) {
                return ApiResponse.fail((String)"\u6b63\u5728\u542f\u7528\u5176\u4ed6\u6a21\u578b\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\uff01");
            }
            String taskId = model.getTrainTaskId();
            switch (model.getModelType()) {
                case "NER": {
                    if (this.nerService.nerSeviceStart(taskId)) break;
                    return ApiResponse.success((String)"\u547d\u540d\u5b9e\u4f53\u8bc6\u522b\u6a21\u578b\u542f\u7528\u5931\u8d25\uff01");
                }
                case "RE": {
                    if (this.reService.reSeviceStart(taskId)) break;
                    return ApiResponse.success((String)"\u5173\u7cfb\u62bd\u53d6\u6a21\u578b\u542f\u7528\u5931\u8d25\uff01");
                }
                case "PE": {
                    if (this.peService.peSeviceStart(taskId)) break;
                    return ApiResponse.success((String)"\u5c5e\u6027\u62bd\u53d6\u6a21\u578b\u542f\u7528\u5931\u8d25\uff01");
                }
            }
            model.setModelState("2");
            this.updateById(model);
            return ApiResponse.success((String)"\u6a21\u578b\u542f\u7528\u4e2d\uff01");
        }
        try {
            switch (model.getModelType()) {
                case "NER": {
                    this.nerService.destoryNerService();
                    HttpUtil.get(this.nerExitApi, null);
                }
                case "RE": {
                    this.reService.destoryReService();
                    HttpUtil.get(this.reExitApi, null);
                }
                case "PE": {
                    this.peService.destoryPeService();
                    HttpUtil.get(this.peExitApi, null);
                }
                default: 
            }
        }
        catch (HussarException e) {
            e.printStackTrace();
        }
        finally {
            model.setModelState("0");
            this.updateById(model);
            return ApiResponse.success((String)"\u6a21\u578b\u670d\u52a1\u505c\u7528\u6210\u529f\uff01");
        }
    }
}

