/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.kgbase.algomodel.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.common.properties.HussarBaseProperties;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.core.config.HussarConfig;
import com.jxdinfo.hussar.core.exception.HussarException;
import com.jxdinfo.hussar.kgbase.algomodel.model.po.TrainTask;
import com.jxdinfo.hussar.kgbase.algomodel.model.vo.TrainSampleVO;
import com.jxdinfo.hussar.kgbase.algomodel.service.ISampleService;
import com.jxdinfo.hussar.kgbase.algomodel.service.ITrainTaskService;
import com.jxdinfo.hussar.kgbase.bzrw.kgtaggingtask1.vo.KgAnnotatedCorpusPropertyVO;
import com.jxdinfo.hussar.kgbase.bzrw.kgtaggingtask1.vo.KgAnnotatedCorpusRelationVO;
import com.jxdinfo.hussar.kgbase.bzrw.kgtaggingtask1.vo.KgAnnotatedCorpusVO;
import com.jxdinfo.hussar.kgbase.common.util.ExcelUtil;
import com.jxdinfo.hussar.kgbase.common.util.FileUtil;
import com.jxdinfo.hussar.kgbase.common.util.MinioUtil;
import com.jxdinfo.hussar.kgbase.wdgl.kgdocmanagement.model.SysFileInfo;
import com.jxdinfo.hussar.kgbase.wdgl.kgdocmanagement.service.SysFileInfoService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

@Service
public class SampleServiceImpl
implements ISampleService {
    @Autowired
    private SysFileInfoService sysFileInfoService;
    @Resource
    private ITrainTaskService iTrainTaskService;
    @Resource
    private HussarConfig hussarConfig;
    @Resource
    private HussarBaseProperties hussarBaseProperties;
    @Resource
    private MinioUtil minioUtil;
    @Value(value="${minio.location}")
    private String minioLocation;

    @Transactional
    public ApiResponse<TrainSampleVO> loadFile(MultipartFile file, String sampleType) {
        TrainSampleVO sampleVO = new TrainSampleVO();
        try {
            List<Map<String, String>> excelMap = ExcelUtil.readExcel(file);
            JSONArray sampleJson = (JSONArray)JSONArray.toJSON(excelMap);
            String modelType = "";
            switch (sampleType) {
                case "NER": {
                    modelType = "\u547d\u540d\u5b9e\u4f53\u8bc6\u522b";
                    sampleVO.setEntityNum(Integer.valueOf(sampleJson.size()));
                    break;
                }
                case "RE": {
                    sampleVO.setRelationNum(Integer.valueOf(sampleJson.size()));
                    modelType = "\u5173\u7cfb\u62bd\u53d6";
                    break;
                }
                case "PE": {
                    sampleVO.setPropertyNum(Integer.valueOf(sampleJson.size()));
                    modelType = "\u5c5e\u6027\u62bd\u53d6";
                }
            }
            if (!this.judgeData(sampleType, sampleJson)) {
                return ApiResponse.fail((String)("\u8bf7\u4e0a\u4f20\u6b63\u786e\u7684" + modelType + "\u8bad\u7ec3\u6837\u672c\uff01"));
            }
            String fileSavePath = this.hussarConfig.getFileUploadPath();
            String attachmentName = String.valueOf(new Date().getTime()) + file.getOriginalFilename();
            file.transferTo(new File(fileSavePath + attachmentName));
            SysFileInfo fileInfo = new SysFileInfo();
            fileInfo.setAttachmentDir(fileSavePath);
            int pointIndex = file.getOriginalFilename().lastIndexOf(".");
            String suffix = file.getOriginalFilename().substring(pointIndex).toLowerCase();
            fileInfo.setAttachmentType(suffix);
            fileInfo.setUploadPer(BaseSecurityUtil.getUser().getId());
            fileInfo.setAttachmentName(attachmentName);
            this.sysFileInfoService.save((Object)fileInfo);
            sampleVO.setFileId(String.valueOf(fileInfo.getFileId()));
            sampleVO.setOrigin("\u624b\u52a8\u4e0a\u4f20");
            sampleVO.setSampleName(file.getOriginalFilename());
            sampleVO.setTagTaskId(null);
            return ApiResponse.success((Object)sampleVO);
        }
        catch (HussarException | IOException e) {
            e.printStackTrace();
            return ApiResponse.fail((String)"\u683c\u5f0f\u8bfb\u53d6\u5931\u8d25");
        }
    }

    private boolean judgeData(String sampleType, JSONArray sampleJson) {
        if (sampleJson.size() == 0) {
            return false;
        }
        try {
            switch (sampleType) {
                case "NER": {
                    List nerVos = JSONObject.parseArray((String)sampleJson.toJSONString(), KgAnnotatedCorpusVO.class);
                    for (KgAnnotatedCorpusVO vo : nerVos) {
                        if (vo.getNodeName() != null && vo.getLabelType() != null && vo.getWholeSentence() != null) continue;
                        return false;
                    }
                    break;
                }
                case "RE": {
                    List relVos = JSONObject.parseArray((String)sampleJson.toJSONString(), KgAnnotatedCorpusRelationVO.class);
                    for (KgAnnotatedCorpusRelationVO vo : relVos) {
                        if (vo.getRel() != null && vo.getEnt1() != null && vo.getEnt2() != null && vo.getText() != null) continue;
                        return false;
                    }
                    break;
                }
                case "PE": {
                    List propVos = JSONObject.parseArray((String)sampleJson.toJSONString(), KgAnnotatedCorpusPropertyVO.class);
                    for (KgAnnotatedCorpusPropertyVO vo : propVos) {
                        if (vo.getPropKey() != null && vo.getPropVal() != null && vo.getText() != null && vo.getEnt() != null) continue;
                        return false;
                    }
                    break;
                }
            }
            return true;
        }
        catch (HussarException e) {
            e.printStackTrace();
            return false;
        }
    }

    public ApiResponse changeToNerCorpus(List<KgAnnotatedCorpusVO> nerModels, String bucketName) {
        ArrayList<String> trainCorpusList = new ArrayList<String>();
        ArrayList trainList = new ArrayList();
        TrainTask trainTask = (TrainTask)this.iTrainTaskService.getById((Serializable)((Object)bucketName));
        int totalSize = nerModels.size();
        if (totalSize < trainTask.getBatchSize()) {
            throw new HussarException("\u6837\u672c\u6570\u91cf\u8fc7\u5c11\uff01\u8bf7\u81f3\u5c11\u4e0a\u4f20" + trainTask.getBatchSize() + "\u6761\u8bed\u6599");
        }
        HashMap<String, List> labelTypeMap = new HashMap<String, List>();
        for (KgAnnotatedCorpusVO kgAnnotatedCorpusVO : nerModels) {
            if (labelTypeMap.get(kgAnnotatedCorpusVO.getLabelType()) == null) {
                ArrayList<KgAnnotatedCorpusVO> newList = new ArrayList<KgAnnotatedCorpusVO>();
                newList.add(kgAnnotatedCorpusVO);
                labelTypeMap.put(kgAnnotatedCorpusVO.getLabelType(), newList);
                continue;
            }
            List existList = (List)labelTypeMap.get(kgAnnotatedCorpusVO.getLabelType());
            existList.add(kgAnnotatedCorpusVO);
            labelTypeMap.put(kgAnnotatedCorpusVO.getLabelType(), existList);
        }
        for (Map.Entry entry : labelTypeMap.entrySet()) {
            List tempList = (List)entry.getValue();
            if (tempList.size() < 5) {
                throw new HussarException("\u6837\u672c\u3010" + (String)entry.getKey() + "\u3011\u6570\u91cf\u8fc7\u5c11\uff01\u8bf7\u81f3\u5c11\u4e0a\u4f205\u6761\u8bed\u6599");
            }
            trainList.addAll(tempList);
        }
        Collections.shuffle(trainList);
        HashMap<String, List> trainMap = new HashMap<String, List>();
        HashMap hashMap = new HashMap();
        for (KgAnnotatedCorpusVO trainVo : trainList) {
            String sentence = trainVo.getWholeSentence();
            if (trainMap.containsKey(sentence = sentence.replaceAll(" ", "")) && trainMap.get(sentence) != null) {
                List samples = (List)trainMap.get(sentence);
                samples.add(trainVo);
                trainMap.put(sentence, samples);
                continue;
            }
            ArrayList<KgAnnotatedCorpusVO> nerDTOS = new ArrayList<KgAnnotatedCorpusVO>();
            nerDTOS.add(trainVo);
            trainMap.put(sentence, nerDTOS);
        }
        for (String sentence : trainMap.keySet()) {
            HashMap<Integer, KgAnnotatedCorpusVO> indexMap = new HashMap<Integer, KgAnnotatedCorpusVO>();
            for (KgAnnotatedCorpusVO corpus : (List)trainMap.get(sentence)) {
                int startOffset = sentence.indexOf(corpus.getNodeName());
                int endOffset = startOffset + corpus.getNodeName().length() - 1;
                corpus.setStartOffset(String.valueOf(startOffset));
                corpus.setEndOffset(String.valueOf(endOffset));
                indexMap.put(startOffset, corpus);
            }
            for (int i = 0; i < sentence.length(); ++i) {
                char c = sentence.charAt(i);
                StringBuffer s = new StringBuffer();
                if (indexMap.get(i) != null) {
                    KgAnnotatedCorpusVO corpus = (KgAnnotatedCorpusVO)indexMap.get(i);
                    s.append(c).append(" ").append("B-").append(corpus.getLabelType());
                    trainCorpusList.add(s.toString());
                    int key = Integer.parseInt(corpus.getEndOffset()) - i;
                    for (int j = i + 1; j <= Integer.parseInt(corpus.getEndOffset()); ++j) {
                        StringBuffer newStr = new StringBuffer();
                        newStr.append(sentence.charAt(j)).append(" ").append("I-").append(corpus.getLabelType());
                        trainCorpusList.add(newStr.toString());
                    }
                    i += key;
                    continue;
                }
                s.append(c).append(" O");
                trainCorpusList.add(s.toString());
            }
            trainCorpusList.add(" ");
        }
        this.createCSVFile(trainCorpusList, "\u5b9e\u4f53\u8bc6\u522b\u6837\u672c_\u8bad\u7ec3\u96c6" + new Date().getTime(), bucketName, true);
        int trainSize = (int)Math.abs((double)trainList.size() * 0.9);
        trainTask.setTrainSize(Integer.valueOf(trainSize));
        trainTask.setDevSize(Integer.valueOf(trainList.size() - trainSize));
        this.iTrainTaskService.updateById((Object)trainTask);
        return ApiResponse.success((String)"\u6837\u672c\u6587\u4ef6\u751f\u6210\u6210\u529f\uff01");
    }

    public ApiResponse changeToReCorpus(List<KgAnnotatedCorpusRelationVO> reModels, String bucketName) {
        ArrayList<String> trainList = new ArrayList<String>();
        ArrayList<String> devList = new ArrayList<String>();
        TrainTask trainTask = (TrainTask)this.iTrainTaskService.getById((Serializable)((Object)bucketName));
        int totalSize = reModels.size();
        if (totalSize < trainTask.getBatchSize()) {
            throw new HussarException("\u6837\u672c\u6570\u91cf\u8fc7\u5c11\uff01\u8bf7\u81f3\u5c11\u4e0a\u4f20" + trainTask.getBatchSize() + "\u6761\u8bed\u6599");
        }
        HashMap<String, List> relTypeMap = new HashMap<String, List>();
        for (KgAnnotatedCorpusRelationVO kgAnnotatedCorpusRelationVO : reModels) {
            if (relTypeMap.get(kgAnnotatedCorpusRelationVO.getRel()) == null) {
                ArrayList<String> newList = new ArrayList<String>();
                newList.add(JSON.toJSONString((Object)kgAnnotatedCorpusRelationVO));
                relTypeMap.put(kgAnnotatedCorpusRelationVO.getRel(), newList);
                continue;
            }
            List existList = (List)relTypeMap.get(kgAnnotatedCorpusRelationVO.getRel());
            existList.add(JSON.toJSONString((Object)kgAnnotatedCorpusRelationVO));
            relTypeMap.put(kgAnnotatedCorpusRelationVO.getRel(), existList);
        }
        for (Map.Entry entry : relTypeMap.entrySet()) {
            List tempList = (List)entry.getValue();
            if (tempList.size() < 5) {
                throw new HussarException("\u6837\u672c\u3010" + (String)entry.getKey() + "\u3011\u6570\u91cf\u8fc7\u5c11\uff01\u8bf7\u81f3\u5c11\u4e0a\u4f205\u6761\u8bed\u6599");
            }
            Double splitIndex = Math.abs((double)tempList.size() * 0.8);
            trainList.addAll(tempList.subList(0, splitIndex.intValue()));
            devList.addAll(tempList.subList(splitIndex.intValue(), tempList.size()));
        }
        this.createJsonFile(trainList, "\u5173\u7cfb\u62bd\u53d6\u6837\u672c_\u8bad\u7ec3\u96c6_" + new Date().getTime(), bucketName, true);
        this.createJsonFile(devList, "\u5173\u7cfb\u62bd\u53d6\u6837\u672c_\u9a8c\u8bc1\u96c6_" + new Date().getTime(), bucketName, false);
        trainTask.setTrainSize(Integer.valueOf(trainList.size()));
        trainTask.setDevSize(Integer.valueOf(devList.size()));
        this.iTrainTaskService.updateById((Object)trainTask);
        return ApiResponse.success((String)"\u6837\u672c\u6587\u4ef6\u751f\u6210\u6210\u529f\uff01");
    }

    public ApiResponse changeToPeCorpus(List<KgAnnotatedCorpusPropertyVO> peModels, String bucketName) {
        ArrayList<String> trainList = new ArrayList<String>();
        ArrayList<String> devList = new ArrayList<String>();
        TrainTask trainTask = (TrainTask)this.iTrainTaskService.getById((Serializable)((Object)bucketName));
        int totalSize = peModels.size();
        if (totalSize < trainTask.getBatchSize()) {
            throw new HussarException("\u6837\u672c\u6570\u91cf\u8fc7\u5c11\uff01\u8bf7\u81f3\u5c11\u4e0a\u4f20" + trainTask.getBatchSize() + "\u6761\u8bed\u6599");
        }
        HashMap<String, List> propTypeMap = new HashMap<String, List>();
        for (KgAnnotatedCorpusPropertyVO kgAnnotatedCorpusPropertyVO : peModels) {
            if (propTypeMap.get(kgAnnotatedCorpusPropertyVO.getPropKey()) == null) {
                ArrayList<String> newList = new ArrayList<String>();
                newList.add(JSON.toJSONString((Object)kgAnnotatedCorpusPropertyVO));
                propTypeMap.put(kgAnnotatedCorpusPropertyVO.getPropKey(), newList);
                continue;
            }
            List existList = (List)propTypeMap.get(kgAnnotatedCorpusPropertyVO.getPropKey());
            existList.add(JSON.toJSONString((Object)kgAnnotatedCorpusPropertyVO));
            propTypeMap.put(kgAnnotatedCorpusPropertyVO.getPropKey(), existList);
        }
        for (Map.Entry entry : propTypeMap.entrySet()) {
            List tempList = (List)entry.getValue();
            if (tempList.size() < 5) {
                throw new HussarException("\u6837\u672c\u3010" + (String)entry.getKey() + "\u3011\u6570\u91cf\u8fc7\u5c11\uff01\u8bf7\u81f3\u5c11\u4e0a\u4f205\u6761\u8bed\u6599");
            }
            Double splitIndex = Math.abs((double)tempList.size() * 0.8);
            trainList.addAll(tempList.subList(0, splitIndex.intValue()));
            devList.addAll(tempList.subList(splitIndex.intValue(), tempList.size()));
        }
        this.createJsonFile(trainList, "\u5c5e\u6027\u62bd\u53d6\u6837\u672c_\u8bad\u7ec3\u96c6_" + new Date().getTime(), bucketName, true);
        this.createJsonFile(devList, "\u5c5e\u6027\u62bd\u53d6\u6837\u672c_\u9a8c\u8bc1\u96c6_" + new Date().getTime(), bucketName, false);
        trainTask.setTrainSize(Integer.valueOf(trainList.size()));
        trainTask.setDevSize(Integer.valueOf(devList.size()));
        this.iTrainTaskService.updateById((Object)trainTask);
        return ApiResponse.success((String)"\u6837\u672c\u6587\u4ef6\u751f\u6210\u6210\u529f\uff01");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createCSVFile(List<String> dataList, String filename, String bucketName, boolean isTrain) {
        File csvFile = null;
        BufferedWriter csvWtriter = null;
        try {
            csvFile = File.createTempFile(filename, ".csv");
            File parent = csvFile.getParentFile();
            if (parent != null && !parent.exists()) {
                parent.mkdirs();
            }
            csvFile.createNewFile();
            csvWtriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(csvFile), "UTF-8"), 1024);
            for (String s : dataList) {
                csvWtriter.write(s);
                csvWtriter.newLine();
            }
            csvWtriter.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
            csvFile.delete();
        }
        finally {
            try {
                csvWtriter.close();
                if (!this.minioUtil.bucketExists(bucketName).booleanValue()) {
                    this.minioUtil.makeBucket(bucketName);
                }
                if (isTrain) {
                    this.minioUtil.upload(FileUtil.fileToMultipartFile(csvFile), "sample/train.csv", bucketName);
                } else {
                    this.minioUtil.upload(FileUtil.fileToMultipartFile(csvFile), "sample/dev.csv", bucketName);
                }
                TrainTask trainTask = (TrainTask)this.iTrainTaskService.getById((Serializable)((Object)bucketName));
                trainTask.setSamplePath(this.minioLocation + "/" + bucketName + "/sample");
                this.iTrainTaskService.updateById((Object)trainTask);
                csvFile.delete();
            }
            catch (IOException e) {
                e.printStackTrace();
                csvFile.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createJsonFile(List<String> dataList, String filename, String bucketName, boolean isTrain) {
        File jsonFile = null;
        BufferedWriter csvWtriter = null;
        try {
            jsonFile = File.createTempFile(filename, ".json");
            File parent = jsonFile.getParentFile();
            if (parent != null && !parent.exists()) {
                parent.mkdirs();
            }
            jsonFile.createNewFile();
            csvWtriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(jsonFile), "UTF-8"), 1024);
            for (String s : dataList) {
                csvWtriter.write(s);
                csvWtriter.newLine();
            }
            csvWtriter.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
            jsonFile.delete();
        }
        finally {
            try {
                csvWtriter.close();
                if (!this.minioUtil.bucketExists(bucketName).booleanValue()) {
                    this.minioUtil.makeBucket(bucketName);
                }
                if (isTrain) {
                    this.minioUtil.upload(FileUtil.fileToMultipartFile(jsonFile), "sample/train.json", bucketName);
                } else {
                    this.minioUtil.upload(FileUtil.fileToMultipartFile(jsonFile), "sample/dev.json", bucketName);
                }
                TrainTask trainTask = (TrainTask)this.iTrainTaskService.getById((Serializable)((Object)bucketName));
                trainTask.setSamplePath(this.minioLocation + "/" + bucketName + "/sample");
                this.iTrainTaskService.updateById((Object)trainTask);
                jsonFile.delete();
            }
            catch (IOException e) {
                e.printStackTrace();
                jsonFile.delete();
            }
        }
    }
}

