/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.kgbase.algomodel.service.impl;

import cn.hutool.core.util.IdUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.jxdinfo.hussar.core.exception.HussarException;
import com.jxdinfo.hussar.kgbase.algomodel.model.dto.ExtractDTO;
import com.jxdinfo.hussar.kgbase.algomodel.model.dto.NerDTO;
import com.jxdinfo.hussar.kgbase.algomodel.model.dto.ReDTO;
import com.jxdinfo.hussar.kgbase.algomodel.model.vo.ExtractVO;
import com.jxdinfo.hussar.kgbase.algomodel.model.vo.NerVO;
import com.jxdinfo.hussar.kgbase.algomodel.model.vo.PeVO;
import com.jxdinfo.hussar.kgbase.algomodel.model.vo.ReVO;
import com.jxdinfo.hussar.kgbase.algomodel.service.ExtractService;
import com.jxdinfo.hussar.kgbase.algomodel.service.ITrainModelService;
import com.jxdinfo.hussar.kgbase.common.util.DateUtil;
import com.jxdinfo.hussar.kgbase.common.util.HttpUtil;
import com.jxdinfo.hussar.kgbase.neo4j.model.Neo4jBasicNode;
import com.jxdinfo.hussar.kgbase.neo4j.model.Neo4jBasicRelationShip;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.neo4j.ogm.session.Session;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ExtractServiceImpl
implements ExtractService {
    @Value(value="${model-config.ner-api}")
    private String nerApi;
    @Value(value="${model-config.re-api}")
    private String reApi;
    @Value(value="${model-config.pe-api}")
    private String peApi;
    @Resource
    private ITrainModelService trainModelService;
    @Resource
    private Session session;

    public ExtractVO extract(String text) {
        QueryWrapper modelQW = new QueryWrapper();
        modelQW.eq((Object)"MODEL_TYPE", (Object)"NER");
        modelQW.eq((Object)"MODEL_STATE", (Object)"1");
        modelQW.eq((Object)"DEL_FLAG", (Object)"0");
        List models = this.trainModelService.list((Wrapper)modelQW);
        if (models.size() == 0) {
            throw new HussarException("\u547d\u540d\u5b9e\u4f53\u8bc6\u522b\u6a21\u578b\u672a\u542f\u7528\uff01");
        }
        text = text.replaceAll(" ", "");
        text = text.replaceAll("\n", "\u3002");
        ExtractVO extractVO = new ExtractVO();
        ArrayList<Neo4jBasicNode> nodeList = new ArrayList<Neo4jBasicNode>();
        ArrayList<Neo4jBasicRelationShip> relationShipList = new ArrayList<Neo4jBasicRelationShip>();
        ArrayList<ReDTO> reDTOList = new ArrayList<ReDTO>();
        HashMap<String, String> nerMap = new HashMap<String, String>();
        NerDTO nerDTO = new NerDTO();
        nerDTO.setText(text);
        String nerStr = HttpUtil.doPostJson(this.nerApi, null, JSON.toJSONString((Object)nerDTO));
        if (StringUtil.isEmpty((Object)nerStr)) {
            throw new HussarException("\u672a\u8bc6\u522b\u5230\u5b9e\u4f53\uff01");
        }
        List nerVOS = JSONArray.parseArray((String)nerStr).toJavaList(NerVO.class);
        for (Object nerVO : nerVOS) {
            if (nerMap.get(nerVO.getName()) != null) continue;
            Neo4jBasicNode basicNode = new Neo4jBasicNode();
            basicNode.setId(IdUtil.fastSimpleUUID());
            basicNode.setLabel(nerVO.getName());
            basicNode.setNodeType(nerVO.getNodeLabel());
            nodeList.add(basicNode);
            nerMap.put(nerVO.getName(), basicNode.getId());
        }
        List<String> sentences = Arrays.asList(text.split("\u3002|\uff1f|\u2026\u2026|\uff01"));
        for (String sentence : sentences) {
            ArrayList<Neo4jBasicNode> tempNodeList = new ArrayList<Neo4jBasicNode>();
            for (Neo4jBasicNode neo4jBasicNode : nodeList) {
                if (!sentence.contains(neo4jBasicNode.getLabel())) continue;
                tempNodeList.add(neo4jBasicNode);
            }
            try {
                HashMap<String, String> propExtractMap = new HashMap<String, String>();
                for (Neo4jBasicNode neo4jBasicNode : tempNodeList) {
                    if (!neo4jBasicNode.getNodeType().equals("\u4eba")) continue;
                    propExtractMap.put(neo4jBasicNode.getLabel(), sentence);
                }
                String string = HttpUtil.doPostJson(this.peApi, null, JSON.toJSONString(propExtractMap));
                if (StringUtil.isNotBlank((CharSequence)string)) {
                    List list = JSONArray.parseArray((String)string).toJavaList(PeVO.class);
                    for (Neo4jBasicNode neo4jBasicNode : nodeList) {
                        for (PeVO peVO : list) {
                            if (!neo4jBasicNode.getLabel().equals(peVO.getEnt())) continue;
                            ArrayList props = neo4jBasicNode.getProperties();
                            if (props == null) {
                                props = new ArrayList();
                            }
                            HashMap<String, String> propMap = new HashMap<String, String>();
                            propMap.put(peVO.getPropKey(), peVO.getPropVal());
                            props.add(propMap);
                            neo4jBasicNode.setProperties(props);
                        }
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            HashMap<String, Boolean> flagMap = new HashMap<String, Boolean>();
            for (Neo4jBasicNode neo4jBasicNode : tempNodeList) {
                for (Neo4jBasicNode neo4jBasicNode2 : tempNodeList) {
                    if (neo4jBasicNode == neo4jBasicNode2 || flagMap.get(neo4jBasicNode.getId() + "" + neo4jBasicNode2.getId()) != null && ((Boolean)flagMap.get(neo4jBasicNode.getId() + "" + neo4jBasicNode2.getId())).booleanValue()) continue;
                    ReDTO reDTO = new ReDTO();
                    reDTO.setEnt1(neo4jBasicNode.getLabel());
                    reDTO.setEnt2(neo4jBasicNode2.getLabel());
                    reDTO.setText(sentence);
                    reDTOList.add(reDTO);
                    flagMap.put(neo4jBasicNode.getId() + "" + neo4jBasicNode2.getId(), true);
                    flagMap.put(neo4jBasicNode2.getId() + "" + neo4jBasicNode.getId(), true);
                }
            }
        }
        QueryWrapper modelQW2 = new QueryWrapper();
        modelQW2.eq((Object)"MODEL_STATE", (Object)"1");
        modelQW2.eq((Object)"DEL_FLAG", (Object)"0");
        modelQW2.eq((Object)"MODEL_TYPE", (Object)"RE");
        models = this.trainModelService.list((Wrapper)modelQW2);
        if (models.size() > 0) {
            HashMap<String, String> flagMap = new HashMap<String, String>();
            String reStr = HttpUtil.doPostJson(this.reApi, null, JSONArray.toJSONString(reDTOList));
            List reVOS = JSONArray.parseArray((String)reStr).toJavaList(ReVO.class);
            for (ReVO reVO : reVOS) {
                if (reVO.getRel() == null || flagMap.get((String)nerMap.get(reVO.getEnt1()) + (String)nerMap.get(reVO.getEnt2())) != null && ((String)flagMap.get((String)nerMap.get(reVO.getEnt1()) + (String)nerMap.get(reVO.getEnt2()))).equals(reVO.getRel())) continue;
                Neo4jBasicRelationShip basicRelationShip = new Neo4jBasicRelationShip();
                basicRelationShip.setId(IdUtil.fastSimpleUUID());
                basicRelationShip.setLabel(reVO.getRel());
                basicRelationShip.setSource((String)nerMap.get(reVO.getEnt1()));
                basicRelationShip.setTarget((String)nerMap.get(reVO.getEnt2()));
                relationShipList.add(basicRelationShip);
                flagMap.put((String)nerMap.get(reVO.getEnt1()) + (String)nerMap.get(reVO.getEnt2()), reVO.getRel());
                flagMap.put((String)nerMap.get(reVO.getEnt2()) + (String)nerMap.get(reVO.getEnt1()), reVO.getRel());
            }
        }
        extractVO.setNodes(nodeList);
        extractVO.setEdges(relationShipList);
        return extractVO;
    }

    @Transactional
    public void saveData(ExtractDTO extractDTO) {
        StringBuffer queryCQL;
        List nodes = extractDTO.getNodes();
        if (nodes.size() == 0) {
            throw new HussarException("\u6ca1\u6709\u53ef\u4fdd\u5b58\u7684\u6570\u636e\uff01");
        }
        List edges = extractDTO.getEdges();
        String date = DateUtil.getTodayToSecond();
        for (Neo4jBasicNode node : nodes) {
            queryCQL = new StringBuffer("");
            queryCQL.append("MERGE(n:`" + node.getNodeType() + "`");
            queryCQL.append(" {").append("name").append(":'").append(node.getLabel()).append("'})");
            queryCQL.append(" ON CREATE SET n.").append("createTime").append(" = '").append(date).append("'");
            queryCQL.append(",n.").append("businessId").append(" = '").append(node.getId()).append("'");
            this.session.query(queryCQL.toString(), new HashMap());
        }
        for (Neo4jBasicRelationShip edge : edges) {
            queryCQL = new StringBuffer("");
            queryCQL.append("MATCH (n1),(n2) ");
            queryCQL.append(" WHERE n1.businessId = '").append(edge.getSource()).append("'");
            queryCQL.append(" and n2.businessId = '").append(edge.getTarget()).append("'");
            queryCQL.append("MERGE (n1)-[r:`").append(edge.getLabel()).append("`]->(n2) ");
            queryCQL.append(" ON CREATE SET r.").append("createTime").append(" = '").append(date).append("'");
            this.session.query(queryCQL.toString(), new HashMap());
        }
    }
}

