/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.kgbase.algomodel.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.jxdinfo.hussar.core.exception.HussarException;
import com.jxdinfo.hussar.kgbase.algomodel.model.dto.TrainTaskDTO;
import com.jxdinfo.hussar.kgbase.algomodel.model.po.TrainModel;
import com.jxdinfo.hussar.kgbase.algomodel.model.po.TrainTask;
import com.jxdinfo.hussar.kgbase.algomodel.service.ITrainModelService;
import com.jxdinfo.hussar.kgbase.algomodel.service.ITrainTaskService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.support.audit.core.annotations.AuditLog;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventGrade;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventType;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/trainTask"})
public class TrainTaskController {
    @Resource
    private ITrainTaskService iTrainTaskService;
    @Resource
    private ITrainModelService iTrainModelService;

    @AuditLog(moduleName="\u8bad\u7ec3\u4efb\u52a1", eventDesc="\u4fdd\u5b58\u6216\u66f4\u65b0", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    @PostMapping(value={"/saveOrEdit"})
    public ApiResponse saveOrEdit(@RequestBody TrainTaskDTO trainTaskDTO) {
        try {
            return this.iTrainTaskService.saveOrEdit(trainTaskDTO);
        }
        catch (HussarException e) {
            e.printStackTrace();
            return ApiResponse.fail((String)e.getMessage());
        }
    }

    @AuditLog(moduleName="\u8bad\u7ec3\u4efb\u52a1", eventDesc="\u67e5\u8be2", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.QUERY)
    @GetMapping(value={"/getInfoById"})
    public ApiResponse getInfoById(@RequestParam String id) {
        try {
            return this.iTrainTaskService.getInfoById(id);
        }
        catch (HussarException e) {
            e.printStackTrace();
            return ApiResponse.fail((String)e.getMessage());
        }
    }

    @AuditLog(moduleName="\u8bad\u7ec3\u4efb\u52a1", eventDesc="\u67e5\u8be2", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.QUERY)
    @PostMapping(value={"/list"})
    public ApiResponse list(@RequestBody TrainTaskDTO trainTaskDTO) {
        try {
            return this.iTrainTaskService.listByPage(trainTaskDTO);
        }
        catch (HussarException e) {
            e.printStackTrace();
            return ApiResponse.fail((String)e.getMessage());
        }
    }

    @AuditLog(moduleName="\u8bad\u7ec3\u4efb\u52a1", eventDesc="\u6279\u91cf\u5220\u9664", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.DELETE)
    @GetMapping(value={"/removeByIds"})
    public ApiResponse removeByIds(@RequestParam String ids) {
        try {
            List<String> idList = Arrays.asList(ids.split(","));
            for (String id : idList) {
                TrainTask task = (TrainTask)this.iTrainTaskService.getById((Serializable)((Object)id));
                if (task.getTaskState().equals("1")) {
                    return ApiResponse.fail((String)"\u8bad\u7ec3\u4e2d\u4efb\u52a1\u65e0\u6cd5\u5220\u9664!");
                }
                QueryWrapper modelQuery = new QueryWrapper();
                modelQuery.eq((Object)"TRAIN_TASK_ID", (Object)id);
                modelQuery.eq((Object)"DEL_FLAG", (Object)"0");
                if (this.iTrainModelService.list((Wrapper)modelQuery).size() <= 0) continue;
                return ApiResponse.fail((String)("\u3010" + task.getTaskName() + "\u3011 \u5df2\u63d0\u53d6\u6a21\u578b\uff0c\u65e0\u6cd5\u5220\u9664!"));
            }
            this.iTrainTaskService.removeByIds(idList);
            return ApiResponse.success((String)"\u5220\u9664\u6210\u529f");
        }
        catch (HussarException e) {
            e.printStackTrace();
            return ApiResponse.fail((String)e.getMessage());
        }
    }

    @AuditLog(moduleName="\u8bad\u7ec3\u4efb\u52a1", eventDesc="\u5f00\u59cb\u8bad\u7ec3", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    @GetMapping(value={"/startTraining"})
    public ApiResponse startTraining(@RequestParam String id) {
        try {
            return this.iTrainTaskService.startTraining(id);
        }
        catch (HussarException e) {
            e.printStackTrace();
            return ApiResponse.fail((String)e.getMessage());
        }
    }

    @AuditLog(moduleName="\u8bad\u7ec3\u4efb\u52a1", eventDesc="\u66f4\u65b0", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    @GetMapping(value={"/judgeBeforeTraining"})
    public ApiResponse judgeBeforeTraining() {
        try {
            return ApiResponse.success((Object)this.iTrainTaskService.judgeBeforeTraining());
        }
        catch (HussarException e) {
            e.printStackTrace();
            return ApiResponse.fail((String)e.getMessage());
        }
    }

    @AuditLog(moduleName="\u8bad\u7ec3\u4efb\u52a1", eventDesc="\u505c\u6b62\u8bad\u7ec3", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    @GetMapping(value={"/stopTraining"})
    public ApiResponse stopTraining(@RequestParam String id) {
        try {
            return this.iTrainTaskService.stopTraining(id);
        }
        catch (HussarException e) {
            e.printStackTrace();
            return ApiResponse.fail((String)e.getMessage());
        }
    }

    @AuditLog(moduleName="\u8bad\u7ec3\u4efb\u52a1", eventDesc="\u63d0\u53d6\u6a21\u578b", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.QUERY)
    @PostMapping(value={"/extractModel"})
    public ApiResponse extractModel(@RequestBody TrainModel trainModel) {
        try {
            QueryWrapper modelQuery = new QueryWrapper();
            modelQuery.eq((Object)"TRAIN_TASK_ID", (Object)trainModel.getTrainTaskId());
            modelQuery.eq((Object)"DEL_FLAG", (Object)"0");
            if (this.iTrainModelService.list((Wrapper)modelQuery).size() > 0) {
                return ApiResponse.fail((String)"\u6a21\u578b\u5df2\u5b58\u5728\uff0c\u8bf7\u52ff\u91cd\u590d\u63d0\u53d6");
            }
            return this.iTrainTaskService.extractModel(trainModel);
        }
        catch (HussarException e) {
            e.printStackTrace();
            return ApiResponse.fail((String)e.getMessage());
        }
    }
}

