/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.kgbase.algomodel.controller;

import com.jxdinfo.hussar.core.exception.HussarException;
import com.jxdinfo.hussar.kgbase.algomodel.model.dto.TrainModelDTO;
import com.jxdinfo.hussar.kgbase.algomodel.model.po.TrainModel;
import com.jxdinfo.hussar.kgbase.algomodel.service.ITrainModelService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.support.audit.core.annotations.AuditLog;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventGrade;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventType;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/trainModel"})
public class TrainModelController {
    @Resource
    private ITrainModelService trainModelService;

    @AuditLog(moduleName="\u6a21\u578b\u4ed3\u5e93", eventDesc="\u67e5\u8be2", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.QUERY)
    @PostMapping(value={"/list"})
    public ApiResponse list(@RequestBody TrainModelDTO trainModelDTO) {
        try {
            return this.trainModelService.listByPage(trainModelDTO);
        }
        catch (HussarException e) {
            e.printStackTrace();
            return ApiResponse.fail((String)e.getMessage());
        }
    }

    @AuditLog(moduleName="\u6a21\u578b\u4ed3\u5e93", eventDesc="\u6279\u91cf\u5220\u9664", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.DELETE)
    @GetMapping(value={"/removeByIds"})
    public ApiResponse removeByIds(@RequestParam String ids) {
        try {
            List<String> idList = Arrays.asList(ids.split(","));
            for (String id : idList) {
                TrainModel trainModel = (TrainModel)this.trainModelService.getById((Serializable)((Object)id));
                if (!"1".equals(trainModel.getModelState())) continue;
                return ApiResponse.fail((String)"\u542f\u7528\u4e2d\u6a21\u578b\u65e0\u6cd5\u5220\u9664!");
            }
            this.trainModelService.removeByIds(idList);
            return ApiResponse.success((String)"\u5220\u9664\u6210\u529f");
        }
        catch (HussarException e) {
            e.printStackTrace();
            return ApiResponse.fail((String)e.getMessage());
        }
    }

    @AuditLog(moduleName="\u6a21\u578b\u4ed3\u5e93", eventDesc="\u4fee\u6539", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    @PostMapping(value={"/changeState"})
    public ApiResponse changeState(@RequestBody TrainModelDTO trainModelDTO) {
        try {
            return this.trainModelService.changeState(trainModelDTO);
        }
        catch (HussarException e) {
            e.printStackTrace();
            return ApiResponse.fail((String)e.getMessage());
        }
    }
}

