/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.kgbase.algomodel.controller;

import com.jxdinfo.hussar.core.exception.HussarException;
import com.jxdinfo.hussar.kgbase.algomodel.model.dto.ExtractDTO;
import com.jxdinfo.hussar.kgbase.algomodel.model.dto.NerDTO;
import com.jxdinfo.hussar.kgbase.algomodel.model.dto.ReDTO;
import com.jxdinfo.hussar.kgbase.algomodel.service.ExtractService;
import com.jxdinfo.hussar.kgbase.algomodel.service.NerService;
import com.jxdinfo.hussar.kgbase.algomodel.service.PeService;
import com.jxdinfo.hussar.kgbase.algomodel.service.ReService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/algoModel"})
public class AlgoModelController {
    @Resource
    private ExtractService extractService;
    @Resource
    private NerService nerService;
    @Resource
    private ReService reService;
    @Resource
    private PeService peService;

    @PostMapping(value={"/nerPedict"})
    public ApiResponse NamedEntityRecognitionPedict(@RequestBody NerDTO nerDTO) {
        try {
            return this.nerService.namedEntityRecognitionPedict(nerDTO);
        }
        catch (HussarException e) {
            e.printStackTrace();
            return ApiResponse.fail((String)e.getMessage());
        }
    }

    @PostMapping(value={"/rePedict"})
    public ApiResponse RelationRecognitionPedict(@RequestBody ReDTO reDTO) {
        try {
            return this.reService.relationRecognitionPedict(reDTO);
        }
        catch (HussarException e) {
            e.printStackTrace();
            return ApiResponse.fail((String)e.getMessage());
        }
    }

    @PostMapping(value={"/extract"})
    public ApiResponse extract(@RequestBody ExtractDTO extractDTO) {
        try {
            return ApiResponse.success((Object)this.extractService.extract(extractDTO.getText()));
        }
        catch (HussarException e) {
            e.printStackTrace();
            return ApiResponse.fail((String)e.getMessage());
        }
    }

    @PostMapping(value={"/saveData"})
    public ApiResponse saveData(@RequestBody ExtractDTO extractDTO) {
        this.extractService.saveData(extractDTO);
        return ApiResponse.success();
    }
}

