/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.kgbase.aj.service.impl;

import cn.hutool.core.util.IdUtil;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.kgbase.aj.model.ConceptAndRelationDTO;
import com.jxdinfo.hussar.kgbase.aj.model.po.AjNode;
import com.jxdinfo.hussar.kgbase.aj.service.AjGraphService;
import com.jxdinfo.hussar.kgbase.common.util.ExcelUtil;
import com.jxdinfo.hussar.kgbase.neo4j.model.Neo4jBasicNode;
import com.jxdinfo.hussar.kgbase.neo4j.model.Neo4jBasicRelationShip;
import com.jxdinfo.hussar.kgbase.neo4j.util.Neo4jUtil;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import com.jxdinfo.hussar.support.log.core.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.neo4j.ogm.model.Property;
import org.neo4j.ogm.model.Result;
import org.neo4j.ogm.response.model.NodeModel;
import org.neo4j.ogm.response.model.RelationshipModel;
import org.neo4j.ogm.session.Session;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class AjGraphServiceImpl
implements AjGraphService {
    @Resource
    private Session session;

    public List<Map<String, Object>> getDocumentList(Integer id) {
        String queryCQL = "WITH {`\u56fd\u5bb6\u6cd5\u5f8b`:1,`\u5730\u65b9\u6cd5\u5f8b`:2,`\u884c\u4e1a\u6807\u51c6`:3,`\u56fd\u7f51\u516c\u53f8\u5236\u5ea6`:4,`\u7701\u516c\u53f8\u5236\u5ea6`:5} as sourceSort MATCH (n)-[r:\u76f8\u5173\u6587\u4ef6]->(m) WHERE id(n) = " + id + "  RETURN m,r ORDER BY sourceSort[m.class]";
        Result dataQuery = this.session.query(queryCQL, new HashMap());
        Iterable dataMap = (Iterable)dataQuery.queryResults();
        ArrayList<Map<String, Object>> resultList = new ArrayList<Map<String, Object>>();
        for (Map map : dataMap) {
            NodeModel model = (NodeModel)map.get("m");
            List modelPropertyList = model.getPropertyList();
            HashMap<String, Object> resMap = new HashMap<String, Object>();
            for (Property mProp : modelPropertyList) {
                switch ((String)mProp.getKey()) {
                    case "name": {
                        resMap.put("name", mProp.getValue());
                        break;
                    }
                    case "pathId": {
                        resMap.put("pathId", mProp.getValue());
                        break;
                    }
                    case "class": {
                        resMap.put("class", mProp.getValue());
                    }
                }
            }
            if (StringUtil.isEmpty(resMap.get("class"))) {
                resMap.put("class", "\u5185\u5bb9");
            }
            RelationshipModel rModel = (RelationshipModel)map.get("r");
            List relPropertyList = rModel.getPropertyList();
            for (Property rProp : relPropertyList) {
                switch ((String)rProp.getKey()) {
                    case "relationDescription": {
                        resMap.put("relationDescription", rProp.getValue());
                    }
                }
            }
            resultList.add(resMap);
        }
        return resultList;
    }

    @Transactional
    public boolean deleteNode(Integer id) {
        try {
            String queryCQL = "MATCH (n)-[r]-(m) WHERE id(n) = " + id + " DELETE r";
            this.session.query(queryCQL, new HashMap());
            queryCQL = "MATCH (n) WHERE id(n) = " + id + " DELETE n";
            this.session.query(queryCQL, new HashMap());
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    @Transactional
    public JSONObject addNodeAndRelation(ConceptAndRelationDTO conceptAndRelationDTO) {
        JSONObject jsonObject = new JSONObject();
        if (conceptAndRelationDTO != null) {
            if (StringUtils.isEmpty((String)conceptAndRelationDTO.getNodeName()) || StringUtils.isEmpty((String)conceptAndRelationDTO.getNodeType()) || StringUtils.isEmpty((String)conceptAndRelationDTO.getParentId()) || StringUtils.isEmpty((String)conceptAndRelationDTO.getRelationName())) {
                jsonObject.put("result", (Object)"false");
                jsonObject.put("message", (Object)"\u8bf7\u8f93\u5165\u5fc5\u586b\u4fe1\u606f");
                return jsonObject;
            }
            String nodeName = conceptAndRelationDTO.getNodeName();
            String nodeType = conceptAndRelationDTO.getNodeType();
            String businessId = "";
            businessId = StringUtil.isEmpty((Object)conceptAndRelationDTO.getBusinessId()) ? IdUtil.fastSimpleUUID() : conceptAndRelationDTO.getBusinessId();
            String nodeDescription = conceptAndRelationDTO.getNodeDescription() == null ? "" : conceptAndRelationDTO.getNodeDescription();
            String pathId = conceptAndRelationDTO.getPathId() == null ? "" : conceptAndRelationDTO.getPathId();
            Long parentId = Long.parseLong(conceptAndRelationDTO.getParentId());
            String relationName = conceptAndRelationDTO.getRelationName();
            String relationDescription = conceptAndRelationDTO.getRelationDescription() == null ? "" : conceptAndRelationDTO.getRelationDescription();
            String queryCQL = "merge(n:" + nodeType + "{businessId:'" + businessId + "',name:'" + nodeName + "',nodeDescription:'" + nodeDescription + "',pathId:'" + pathId + "'}) return n;";
            Result dataQuery = this.session.query(queryCQL, new HashMap());
            Iterable dataMap = (Iterable)dataQuery.queryResults();
            Long nodeId = null;
            for (Map map : dataMap) {
                NodeModel model = (NodeModel)map.get("n");
                nodeId = model.getId();
            }
            String queryRelationCQL = "MATCH (n),(m) where id(m)=" + nodeId + " and id(n)=" + parentId + " merge (n)-[r:" + relationName + "{name:'" + relationName + "',relationDescription:'" + relationDescription + "'}]-(m)  RETURN m,r";
            Result dataRelationQuery = this.session.query(queryRelationCQL, new HashMap());
            Long edgeId = null;
            for (Map map : dataRelationQuery) {
                RelationshipModel rModel = (RelationshipModel)map.get("r");
                edgeId = rModel.getId();
            }
            jsonObject.put("result", (Object)"susscess");
            jsonObject.put("message", (Object)"susscess");
            jsonObject.put("nodeId", (Object)(nodeId + ""));
            jsonObject.put("edgeId", (Object)(edgeId + "_edge"));
        } else {
            jsonObject.put("result", (Object)"false");
            jsonObject.put("message", (Object)"\u8bf7\u8f93\u5165\u5fc5\u586b\u4fe1\u606f");
        }
        return jsonObject;
    }

    @Transactional
    public boolean importAjExcel(String fileName) {
        Workbook wb = null;
        Sheet sheet = null;
        Row row = null;
        String cellData = null;
        String filePath = "C:\\Users\\jueshao\\Desktop\\\u5b8c\u6574\u4f53\u7cfb\u6587\u4ef6\\" + fileName + ".xls";
        wb = ExcelUtil.readExcel(filePath);
        if (wb != null) {
            sheet = wb.getSheetAt(0);
            int rownum = sheet.getPhysicalNumberOfRows();
            Row titleRow = sheet.getRow(0);
            int colnum = titleRow.getPhysicalNumberOfCells();
            for (int i = 1; i < rownum && (row = sheet.getRow(i)) != null; ++i) {
                StringBuffer sb = new StringBuffer();
                AjNode ajNode = new AjNode();
                for (int j = 0; j < colnum; ++j) {
                    String nodeCQL;
                    if (row.getCell(j) != null && StringUtil.isNotBlank((CharSequence)row.getCell(j).getStringCellValue()) && !"\u63cf\u8ff0".equals(titleRow.getCell(j).getStringCellValue()) && !"pathId".equals(titleRow.getCell(j).getStringCellValue())) {
                        cellData = (String)ExcelUtil.getCellFormatValue(row.getCell(j));
                        String path = sb.toString();
                        if (StringUtil.isEmpty((Object)path)) {
                            path = "-";
                        }
                        String nodeCQL2 = "merge(n:`" + titleRow.getCell(j).getStringCellValue() + "`{name:'" + cellData + "',path:'" + path + "'}) return n;";
                        boolean flag = false;
                        String className = (String)ExcelUtil.getCellFormatValue(row.getCell(6));
                        if ("\u56fd\u5bb6\u6cd5\u5f8b".equals(className) || "\u5730\u65b9\u6cd5\u5f8b".equals(className) || "\u884c\u4e1a\u6807\u51c6".equals(className) || "\u56fd\u7f51\u516c\u53f8\u5236\u5ea6".equals(className) || "\u7701\u516c\u53f8\u5236\u5ea6".equals(className)) {
                            flag = true;
                        }
                        if ("\u6587\u4ef6".equals(titleRow.getCell(j).getStringCellValue()) && flag) {
                            nodeCQL2 = "merge(n:`" + titleRow.getCell(j).getStringCellValue() + "`{name:'" + cellData + "',path:'" + path + "',class:'" + className + "'}) return n;";
                        }
                        this.session.query(nodeCQL2, new HashMap());
                        if (ajNode.getName() != null) {
                            String relationCQL = "";
                            relationCQL = "\u6587\u4ef6".equals(titleRow.getCell(j).getStringCellValue()) ? "MATCH (n),(m) where n.name='" + ajNode.getName() + "' and n.path='" + ajNode.getPath() + "' and m.name='" + cellData + "' and m.path='" + path + "' merge (n)-[r:\u76f8\u5173\u6587\u4ef6{relationDescription:'" + (String)ExcelUtil.getCellFormatValue(row.getCell(j - 1)) + "'}]-(m)  RETURN r" : "MATCH (n),(m) where n.name='" + ajNode.getName() + "' and n.path='" + ajNode.getPath() + "' and m.name='" + cellData + "' and m.path='" + path + "' merge (n)-[r:\u4e0b\u7ea7]-(m)  RETURN r";
                            this.session.query(relationCQL, new HashMap());
                        }
                        ajNode.setLabel(titleRow.getCell(j).getStringCellValue());
                        ajNode.setName(cellData);
                        ajNode.setPath(path);
                        sb.append(cellData);
                        sb.append("-");
                        continue;
                    }
                    if (row.getCell(j) != null && "\u63cf\u8ff0".equals(titleRow.getCell(j).getStringCellValue())) {
                        cellData = (String)ExcelUtil.getCellFormatValue(row.getCell(j));
                        nodeCQL = "match(n:`" + ajNode.getLabel() + "`{name:'" + ajNode.getName() + "',path:'" + ajNode.getPath() + "'}) set n.nodeDescription = '" + cellData + "';";
                        this.session.query(nodeCQL, new HashMap());
                        continue;
                    }
                    if (row.getCell(j) == null || !"pathId".equals(titleRow.getCell(j).getStringCellValue())) continue;
                    cellData = (String)ExcelUtil.getCellFormatValue(row.getCell(j));
                    nodeCQL = "match(n:`\u6587\u4ef6`{name:'" + ajNode.getName() + "',path:'" + ajNode.getPath() + "'}) set n.pathId = '" + cellData + "';";
                    this.session.query(nodeCQL, new HashMap());
                }
            }
        }
        return true;
    }

    @Transactional
    public JSONObject editNode(ConceptAndRelationDTO conceptAndRelationDTO) {
        JSONObject jsonObject = new JSONObject();
        if (conceptAndRelationDTO != null) {
            if (StringUtils.isEmpty((String)conceptAndRelationDTO.getNodeName()) || StringUtils.isEmpty((String)conceptAndRelationDTO.getNodeId())) {
                jsonObject.put("result", (Object)"false");
                jsonObject.put("message", (Object)"\u8bf7\u8f93\u5165\u5fc5\u586b\u4fe1\u606f");
                return jsonObject;
            }
            Long nodeId = Long.parseLong(conceptAndRelationDTO.getNodeId());
            String nodeName = conceptAndRelationDTO.getNodeName();
            String nodeDescription = conceptAndRelationDTO.getNodeDescription();
            String pathId = conceptAndRelationDTO.getPathId() == null ? "" : conceptAndRelationDTO.getPathId();
            String queryNodeCQL = "MATCH (n) where id(n)=" + nodeId + " set n.name='" + nodeName + "',n.nodeDescription='" + nodeDescription + "',n.pathId='" + pathId + "' return n";
            Result dataNodeQuery = this.session.query(queryNodeCQL, new HashMap());
            List<Object> nodeList = new ArrayList();
            ArrayList<NodeModel> nodes = new ArrayList<NodeModel>();
            Iterable resultList = (Iterable)dataNodeQuery.queryResults();
            for (Map map : resultList) {
                Object node = map.get("n");
                if (!(node instanceof NodeModel)) continue;
                nodes.add((NodeModel)node);
            }
            nodeList = Neo4jUtil.changeToNeo4jBasicNode(nodes);
            if (nodeList != null && nodeList.size() > 0) {
                Neo4jBasicNode neo4jBasicNode = (Neo4jBasicNode)nodeList.get(0);
                jsonObject.put("node", (Object)neo4jBasicNode);
                jsonObject.put("result", (Object)"susscess");
                jsonObject.put("message", (Object)"susscess");
            } else {
                jsonObject.put("result", (Object)"false");
                jsonObject.put("message", (Object)"\u672a\u627e\u5230\u76f8\u5e94\u5b9e\u4f8b\u6570\u636e");
            }
        } else {
            jsonObject.put("result", (Object)"false");
            jsonObject.put("message", (Object)"\u8bf7\u8f93\u5165\u5fc5\u586b\u4fe1\u606f");
        }
        return jsonObject;
    }

    @Transactional
    public JSONObject editRelation(ConceptAndRelationDTO conceptAndRelationDTO) {
        JSONObject jsonObject = new JSONObject();
        if (conceptAndRelationDTO != null) {
            if (StringUtils.isEmpty((String)conceptAndRelationDTO.getRelationName()) || StringUtils.isEmpty((String)conceptAndRelationDTO.getRelationId())) {
                jsonObject.put("result", (Object)"false");
                jsonObject.put("message", (Object)"\u8bf7\u8f93\u5165\u5fc5\u586b\u4fe1\u606f");
                return jsonObject;
            }
            Long relationId = Long.parseLong(conceptAndRelationDTO.getRelationId().replace("_edge", ""));
            String relationDescription = conceptAndRelationDTO.getRelationDescription();
            String queryRelationCQL = "MATCH p=()-[r]->()  where id(r)=" + relationId + " set r.relationDescription='" + relationDescription + "' return r";
            Result dataRelationQuery = this.session.query(queryRelationCQL, new HashMap());
            List<Object> relationShipList = new ArrayList();
            ArrayList<RelationshipModel> relationships = new ArrayList<RelationshipModel>();
            Iterable resultList = (Iterable)dataRelationQuery.queryResults();
            for (Map map : resultList) {
                Object relationship = map.get("r");
                if (!(relationship instanceof RelationshipModel)) continue;
                relationships.add((RelationshipModel)relationship);
            }
            relationShipList = Neo4jUtil.changeToNeo4jQueryRelation(relationships);
            if (relationShipList != null && relationShipList.size() > 0) {
                Neo4jBasicRelationShip neo4jBasicRelationShip = (Neo4jBasicRelationShip)relationShipList.get(0);
                jsonObject.put("edge", (Object)neo4jBasicRelationShip);
                jsonObject.put("result", (Object)"susscess");
                jsonObject.put("message", (Object)"susscess");
            } else {
                jsonObject.put("result", (Object)"false");
                jsonObject.put("message", (Object)"\u672a\u627e\u5230\u76f8\u5e94\u5173\u7cfb");
            }
        } else {
            jsonObject.put("result", (Object)"false");
            jsonObject.put("message", (Object)"\u8bf7\u8f93\u5165\u5fc5\u586b\u4fe1\u606f");
        }
        return jsonObject;
    }
}

