/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.kgbase.common.util.pdfUtil;

import cn.hutool.core.codec.Base64;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.ImageIO;
import net.coobird.thumbnailator.Thumbnails;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sun.misc.BASE64Decoder;

public class CompressedPictureUtil {
    static Logger LOG = LoggerFactory.getLogger(CompressedPictureUtil.class);

    public static BufferedImage base64String2BufferedImage(String base64string) {
        BufferedImage image = null;
        try {
            InputStream stream = CompressedPictureUtil.BaseToInputStream(base64string);
            image = ImageIO.read(stream);
        }
        catch (IOException e) {
            LOG.info("base64\u56fe\u7247\u538b\u7f29\u5931\u8d25");
        }
        return image;
    }

    public static String imageToBase64(BufferedImage bufferedImage) {
        Base64 encoder = new Base64();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            ImageIO.write((RenderedImage)bufferedImage, "png", baos);
        }
        catch (IOException e) {
            LOG.info("\u56fe\u7247\u8f6cbase64\u683c\u5f0f\u5931\u8d25");
        }
        return new String(Base64.encode((byte[])baos.toByteArray()));
    }

    private static InputStream BaseToInputStream(String base64string) {
        ByteArrayInputStream stream = null;
        try {
            BASE64Decoder decoder = new BASE64Decoder();
            byte[] bytes1 = decoder.decodeBuffer(base64string);
            stream = new ByteArrayInputStream(bytes1);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return stream;
    }

    public static String resizeImageTo200K(String base64Img) {
        try {
            BufferedImage src = CompressedPictureUtil.base64String2BufferedImage(base64Img);
            BufferedImage output = Thumbnails.of((BufferedImage[])new BufferedImage[]{src}).size(src.getWidth() / 3, src.getHeight() / 3).asBufferedImage();
            String base64 = CompressedPictureUtil.imageToBase64(output);
            if (base64.length() - base64.length() / 8 * 2 > 200000) {
                output = Thumbnails.of((BufferedImage[])new BufferedImage[]{output}).scale((double)(1 / (base64.length() / 200000))).asBufferedImage();
                base64 = CompressedPictureUtil.imageToBase64(output);
            }
            return base64;
        }
        catch (Exception e) {
            return base64Img;
        }
    }

    public static void main(String[] args) {
        String base64 = "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";
        String s = CompressedPictureUtil.resizeImageTo200K(base64);
        System.out.println(s);
    }
}

