/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.kgbase.common.util.pdfUtil;

import com.jxdinfo.hussar.kgbase.common.util.pdfUtil.ConvertUtil;
import com.jxdinfo.hussar.kgbase.common.util.pdfUtil.ProcessUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.Socket;

public class CebUtil
extends ConvertUtil {
    private static final String OPEN = "1";

    public static synchronized void ceb2Pdf(File sourceFile, File pdfFile) {
        if (OPEN.equals(prop.getProperty("ceb.convert.switch"))) {
            if (CebUtil.isOSWindows()) {
                CebUtil.c2pWindows(sourceFile, pdfFile);
            } else {
                CebUtil.c2pLinux(sourceFile, pdfFile);
            }
        }
    }

    private static void c2pLinux(File sourceFile, File pdfFile) {
        Socket socket = null;
        try {
            int len1;
            socket = new Socket(prop.getProperty("ceb.server.ip"), (int)Integer.valueOf(prop.getProperty("ceb.server.port", "8765")));
            BufferedOutputStream bo1 = new BufferedOutputStream(socket.getOutputStream());
            BufferedInputStream bi1 = new BufferedInputStream(new FileInputStream(sourceFile));
            byte[] buf = new byte[1024];
            int len = 0;
            while ((len = bi1.read(buf)) != -1) {
                bo1.write(buf, 0, len);
            }
            bo1.flush();
            bi1.close();
            socket.shutdownOutput();
            BufferedInputStream bi2 = new BufferedInputStream(socket.getInputStream());
            BufferedOutputStream bo2 = new BufferedOutputStream(new FileOutputStream(pdfFile));
            byte[] bytes = new byte[1024];
            while ((len1 = bi2.read(bytes)) != -1) {
                bo2.write(bytes, 0, len1);
            }
            bo2.flush();
            bo2.close();
            bi2.close();
            socket.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void c2pWindows(File sourceFile, File pdfFile) {
        try {
            String exePath = prop.getProperty("ceb.c2pWin.dir") + "c2p_win/c2pwin.exe";
            if (new File(exePath).exists()) {
                ProcessUtils.execute(10000L, exePath, sourceFile.getAbsolutePath(), pdfFile.getAbsolutePath());
            }
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
    }
}

