/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.kgbase.common.util;

import com.itextpdf.text.pdf.PdfReader;
import com.itextpdf.text.pdf.parser.PdfReaderContentParser;
import com.itextpdf.text.pdf.parser.RenderListener;
import com.itextpdf.text.pdf.parser.SimpleTextExtractionStrategy;
import com.itextpdf.text.pdf.parser.TextExtractionStrategy;
import com.jxdinfo.hussar.kgbase.wdgl.kgdocmanagement.dao.SysFileInfoMapper;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PdfToTxt {
    private static Logger LOGGER = LoggerFactory.getLogger(PdfToTxt.class);
    @Autowired
    private SysFileInfoMapper sysFileInfoMapper;
    private static PdfToTxt pdfToTxtPar;

    @PostConstruct
    public void init() {
        pdfToTxtPar = this;
        PdfToTxt.pdfToTxtPar.sysFileInfoMapper = this.sysFileInfoMapper;
    }

    public static void pdfToTxt(String filePath, String fileName, String suffix) throws IOException {
        String wordToTxtPath = filePath + "/" + fileName + ".txt";
        String sourcePath = filePath + fileName + suffix;
        File file = new File(wordToTxtPath);
        if (!file.exists()) {
            PdfReader reader = new PdfReader(sourcePath);
            PdfReaderContentParser parser = new PdfReaderContentParser(reader);
            ArrayList<String> pdfTextList = new ArrayList<String>();
            System.out.println("\u603b\u5171\u6709" + reader.getNumberOfPages() + "\u9875");
            for (int i = 0; i < reader.getNumberOfPages(); ++i) {
                TextExtractionStrategy strategy = (TextExtractionStrategy)parser.processContent(i + 1, (RenderListener)new SimpleTextExtractionStrategy());
                pdfTextList.add(strategy.getResultantText().toString());
                int pageSize = i + 1;
                try {
                    OutputStreamWriter osw = new OutputStreamWriter((OutputStream)new FileOutputStream(wordToTxtPath, true), "UTF-8");
                    osw.write((String)pdfTextList.get(i));
                    osw.flush();
                    continue;
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        PdfToTxt.pdfToTxtPar.sysFileInfoMapper.updateDocInfo(fileName);
    }
}

