/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.kgbase.bzrw.kgtaggingtask1.service.impl;

import cn.hutool.core.text.TextSimilarity;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.jxdinfo.hussar.core.config.HussarConfig;
import com.jxdinfo.hussar.core.exception.HussarException;
import com.jxdinfo.hussar.kgbase.application.globalconfig.model.GlobalConfig;
import com.jxdinfo.hussar.kgbase.application.globalconfig.service.IGlobalConfigService;
import com.jxdinfo.hussar.kgbase.application.nodeconfig.model.NodeConfig;
import com.jxdinfo.hussar.kgbase.application.nodeconfig.service.INodeConfigService;
import com.jxdinfo.hussar.kgbase.build.model.po.Concept;
import com.jxdinfo.hussar.kgbase.build.service.IConceptService;
import com.jxdinfo.hussar.kgbase.bzrw.kgtaggingtask1.dao.LabelDocMapper;
import com.jxdinfo.hussar.kgbase.bzrw.kgtaggingtask1.dto.LabelMarkResult;
import com.jxdinfo.hussar.kgbase.bzrw.kgtaggingtask1.model.KgLabelAlign;
import com.jxdinfo.hussar.kgbase.bzrw.kgtaggingtask1.model.KgLabelNode;
import com.jxdinfo.hussar.kgbase.bzrw.kgtaggingtask1.model.KgLabelProperty;
import com.jxdinfo.hussar.kgbase.bzrw.kgtaggingtask1.model.KgLabelRelation;
import com.jxdinfo.hussar.kgbase.bzrw.kgtaggingtask1.model.KgTaggingTask1;
import com.jxdinfo.hussar.kgbase.bzrw.kgtaggingtask1.model.LabelDoc;
import com.jxdinfo.hussar.kgbase.bzrw.kgtaggingtask1.service.KgLabelAlignService;
import com.jxdinfo.hussar.kgbase.bzrw.kgtaggingtask1.service.KgLabelNodeService;
import com.jxdinfo.hussar.kgbase.bzrw.kgtaggingtask1.service.KgLabelPropertyService;
import com.jxdinfo.hussar.kgbase.bzrw.kgtaggingtask1.service.KgLabelRelationService;
import com.jxdinfo.hussar.kgbase.bzrw.kgtaggingtask1.service.KgTaggingTask1Service;
import com.jxdinfo.hussar.kgbase.bzrw.kgtaggingtask1.service.LabelDocService;
import com.jxdinfo.hussar.kgbase.bzrw.kgtaggingtask1.vo.KgAnnotatedCorpusPropertyVO;
import com.jxdinfo.hussar.kgbase.bzrw.kgtaggingtask1.vo.KgAnnotatedCorpusRelationVO;
import com.jxdinfo.hussar.kgbase.bzrw.kgtaggingtask1.vo.KgAnnotatedCorpusVO;
import com.jxdinfo.hussar.kgbase.bzrw.kgtaggingtask1.vo.KgAnnotationLabelVO;
import com.jxdinfo.hussar.kgbase.bzrw.kgtaggingtask1.vo.KgLabelAlignVO;
import com.jxdinfo.hussar.kgbase.bzrw.kgtaggingtask1.vo.LabelDocVO;
import com.jxdinfo.hussar.kgbase.neo4j.model.Neo4jBasicNode;
import com.jxdinfo.hussar.kgbase.neo4j.model.Neo4jBasicRelationShip;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.base.entity.BaseEntity;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import dm.jdbc.util.StringUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.io.Writer;
import java.net.URLEncoder;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Resource;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.neo4j.ogm.model.Result;
import org.neo4j.ogm.response.model.NodeModel;
import org.neo4j.ogm.session.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class LabelDocServiceImpl
extends HussarServiceImpl<LabelDocMapper, LabelDoc>
implements LabelDocService {
    private static final Logger logger = LoggerFactory.getLogger(LabelDocServiceImpl.class);
    @Value(value="${node-config.enableOntologyConfig}")
    private boolean enableOntologyConfig;
    @Resource
    private HussarConfig hussarConfig;
    @Autowired
    private INodeConfigService iNodeConfigService;
    @Autowired
    private IGlobalConfigService globalConfigService;
    @Autowired
    private LabelDocMapper labelDocMapper;
    @Autowired
    private IConceptService conceptService;
    @Resource
    private Session session;
    @Autowired
    private KgLabelNodeService kgLabelNodeService;
    @Autowired
    private KgLabelRelationService kgLabelRelationService;
    @Autowired
    private KgLabelAlignService kgLabelAlignService;
    @Autowired
    KgTaggingTask1Service kgTaggingTask1Service;
    @Autowired
    KgLabelPropertyService kgLabelPropertyService;

    public LabelDocVO labelDocQueryByTaskId(String taskid) {
        QueryWrapper ew = new QueryWrapper();
        ew.eq((Object)"PROJECT_ID", (Object)taskid);
        LabelDoc labelDocInfo = (LabelDoc)this.getOne((Wrapper)ew);
        LabelDocVO labelDocVO = new LabelDocVO();
        if (labelDocInfo != null) {
            String[] text = labelDocInfo.getText().replaceAll(" ", "").replaceAll("\\n", "").split("\u3002");
            String annotations = "";
            ArrayList<String> textList = new ArrayList<String>();
            for (int i = 0; i < text.length; ++i) {
                if (!StringUtil.isNotEmpty((String)text[i])) continue;
                textList.add(text[i]);
                annotations = annotations + ",[]";
            }
            if (annotations.length() > 0) {
                annotations = annotations.substring(1, annotations.length());
            }
            annotations = "[" + annotations + "]";
            if ("0".equals(labelDocInfo.getIsChecked())) {
                labelDocVO.setAnnotations(annotations);
            } else {
                labelDocVO.setAnnotations(labelDocInfo.getAnnotations());
            }
            labelDocVO.setId(labelDocInfo.getId());
            String[] newText = textList.toArray(new String[0]);
            labelDocVO.setText(newText);
            labelDocVO.setProjectId(labelDocInfo.getProjectId());
            labelDocVO.setCreateTime(labelDocInfo.getCreateTime());
            labelDocVO.setIsChecked(labelDocInfo.getIsChecked());
            labelDocVO.setPredications(labelDocInfo.getPredications());
            labelDocVO.setUpdateTime(labelDocInfo.getUpdateTime());
            labelDocVO.setPropertyRelationList(labelDocInfo.getPropertyRelationList());
        }
        return labelDocVO;
    }

    public ApiResponse<List<KgAnnotationLabelVO>> getLabelList() {
        try {
            List<KgAnnotationLabelVO> labelList = this.labelDocMapper.getLabelList();
            if (!this.enableOntologyConfig) {
                GlobalConfig globalConfig = this.globalConfigService.getCurrentConfig();
                String version = globalConfig.getVersion();
                List nodeConfigList = this.iNodeConfigService.getConfigList(version);
                HashMap<String, NodeConfig> nodeConfigMap = new HashMap<String, NodeConfig>();
                for (NodeConfig nodeConfig : nodeConfigList) {
                    nodeConfigMap.put(nodeConfig.getLabel(), nodeConfig);
                }
                for (KgAnnotationLabelVO annotationLabelVO : labelList) {
                    if (nodeConfigMap.get(annotationLabelVO.getLabelName()) == null) continue;
                    annotationLabelVO.setBackgroundColor(((NodeConfig)nodeConfigMap.get(annotationLabelVO.getLabelName())).getFill());
                }
            }
            return ApiResponse.success(labelList);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new HussarException("\u6807\u6ce8\u6807\u7b7e\u5217\u8868\u67e5\u8be2\u5931\u8d25");
        }
    }

    public ApiResponse updateLabelMark(LabelDoc labelDoc) {
        try {
            if (labelDoc != null && StringUtil.isNotEmpty((String)(labelDoc.getId() + ""))) {
                this.labelDocMapper.updateInfo(labelDoc.getId(), labelDoc.getAnnotations(), labelDoc.getIsChecked());
                return ApiResponse.success((String)"\u6807\u6ce8\u5185\u5bb9\u4fdd\u5b58\u6210\u529f\uff01");
            }
            return ApiResponse.success((String)"\u672a\u83b7\u53d6\u5230\u6807\u6ce8\u5185\u5bb9\uff01");
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new HussarException("\u6807\u6ce8\u5185\u5bb9\u4fdd\u5b58\u5931\u8d25");
        }
    }

    public ApiResponse getRelationByTwoNodes(String sourceNodeId, String targetNodeId) {
        try {
            if (StringUtil.isNotEmpty((String)sourceNodeId) && StringUtil.isNotEmpty((String)targetNodeId)) {
                return ApiResponse.success(this.labelDocMapper.getRelationByTwoNodes(sourceNodeId, targetNodeId));
            }
            return ApiResponse.success(new ArrayList());
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new HussarException("\u83b7\u53d6\u4e24\u4e2a\u5b9e\u4f53\u4e4b\u95f4\u7684\u5173\u7cfb\u5931\u8d25\uff01");
        }
    }

    public ApiResponse getRelationByTwoNodeName(String sourceNodeName, String targetNodeName) {
        try {
            if (StringUtil.isNotEmpty((String)sourceNodeName) && StringUtil.isNotEmpty((String)targetNodeName)) {
                String sourceNodeId = this.getNodeIdByNodeName(sourceNodeName);
                String targetNodeId = this.getNodeIdByNodeName(targetNodeName);
                return this.getRelationByTwoNodes(sourceNodeId, targetNodeId);
            }
            return ApiResponse.success(new ArrayList());
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new HussarException("\u83b7\u53d6\u4e24\u4e2a\u5b9e\u4f53\u4e4b\u95f4\u7684\u5173\u7cfb\u5931\u8d25\uff01");
        }
    }

    public String getNodeIdByNodeName(String nodeName) {
        QueryWrapper ew = new QueryWrapper();
        ew.eq((Object)"CONCEPT_NAME", (Object)nodeName);
        Concept concept = (Concept)this.conceptService.getOne((Wrapper)ew);
        String nodeId = "";
        if (concept != null) {
            nodeId = concept.getId();
        }
        return nodeId;
    }

    public ApiResponse updateLabelRelation(LabelDoc labelDoc) {
        try {
            if (labelDoc != null && StringUtil.isNotEmpty((String)(labelDoc.getId() + ""))) {
                LocalDateTime now = LocalDateTime.now();
                labelDoc.setUpdateTime(now);
                boolean flag = this.updateById((BaseEntity)labelDoc);
                if (flag) {
                    return ApiResponse.success((Object)now, (String)"\u6807\u6ce8\u5185\u5bb9\u4fdd\u5b58\u6210\u529f\uff01");
                }
                return ApiResponse.success((String)"\u6807\u6ce8\u5185\u5bb9\u4fdd\u5b58\u5931\u8d25\uff01");
            }
            return ApiResponse.success((String)"\u672a\u83b7\u53d6\u5230\u6807\u6ce8\u5185\u5bb9\uff01");
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new HussarException("\u6807\u6ce8\u5185\u5bb9\u4fdd\u5b58\u5931\u8d25");
        }
    }

    public ApiResponse getSimilarNode(String taskId) {
        try {
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"task_id", (Object)taskId);
            List kgLabelAligns = this.kgLabelAlignService.list((Wrapper)queryWrapper);
            return ApiResponse.success((Object)kgLabelAligns);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new HussarException("\u83b7\u53d6\u6807\u6ce8\u5b9e\u4f8b\u5bf9\u9f50\u5217\u8868\u5931\u8d25\uff01");
        }
    }

    public List<LabelMarkResult> getLabelMarkResultList(String taskId) {
        String annotations;
        ArrayList<LabelMarkResult> markResultsList = new ArrayList<LabelMarkResult>();
        QueryWrapper ew = new QueryWrapper();
        ew.eq((Object)"PROJECT_ID", (Object)taskId);
        LabelDoc labelDocInfo = (LabelDoc)this.getOne((Wrapper)ew);
        if (labelDocInfo != null && !"[[]]".equals(annotations = labelDocInfo.getAnnotations())) {
            JSONArray jsonArray = JSONArray.parseArray((String)annotations);
            for (int i = 0; i < jsonArray.size(); ++i) {
                JSONArray jay = jsonArray.getJSONArray(i);
                if (jay.size() == 0) continue;
                for (int j = 0; j < jay.size(); ++j) {
                    LabelMarkResult labelMark = new LabelMarkResult();
                    JSONObject job = jay.getJSONObject(j);
                    if (!"instance".equals(job.get((Object)"type").toString())) continue;
                    labelMark.setId(job.get((Object)"id").toString());
                    labelMark.setEnd_offset(job.get((Object)"end_offset").toString());
                    labelMark.setStart_offset(job.get((Object)"start_offset").toString());
                    labelMark.setLabelId(job.get((Object)"labelId").toString());
                    labelMark.setLabelName(job.get((Object)"labelName").toString());
                    labelMark.setText(job.get((Object)"text").toString());
                    labelMark.setWhole_sentence(job.get((Object)"whole_sentence").toString());
                    markResultsList.add(labelMark);
                }
            }
        }
        return markResultsList;
    }

    public ApiResponse getGraphByTaskId(String taskId) {
        try {
            JSONObject resultObj = new JSONObject();
            ArrayList<Neo4jBasicNode> nodeList = new ArrayList<Neo4jBasicNode>();
            List<Object> relationShipList = new ArrayList();
            List<LabelMarkResult> LabelMarkResultList = this.getLabelMarkResultList(taskId);
            for (LabelMarkResult labelMarkResult : LabelMarkResultList) {
                Neo4jBasicNode node = new Neo4jBasicNode();
                node.setId(labelMarkResult.getId());
                node.setLabel(labelMarkResult.getText());
                node.setNodeType(labelMarkResult.getLabelName());
                nodeList.add(node);
            }
            relationShipList = this.getLabelRelationList(taskId);
            resultObj.put("nodes", nodeList);
            resultObj.put("edges", relationShipList);
            return ApiResponse.success((Object)resultObj);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new HussarException("\u6807\u6ce8\u5185\u5bb9\u56fe\u8c31\u9884\u89c8\u5931\u8d25\uff01");
        }
    }

    public List<Neo4jBasicRelationShip> getLabelRelationList(String taskId) {
        String labelRelations;
        ArrayList<Neo4jBasicRelationShip> relationList = new ArrayList<Neo4jBasicRelationShip>();
        QueryWrapper ew = new QueryWrapper();
        ew.eq((Object)"PROJECT_ID", (Object)taskId);
        LabelDoc labelDocInfo = (LabelDoc)this.getOne((Wrapper)ew);
        if (labelDocInfo != null && !"[]".equals(labelRelations = labelDocInfo.getPredications())) {
            JSONArray jsonArray = JSONArray.parseArray((String)labelRelations);
            for (int i = 0; i < jsonArray.size(); ++i) {
                Neo4jBasicRelationShip neo4jBasicRelationShip = new Neo4jBasicRelationShip();
                JSONObject job = jsonArray.getJSONObject(i);
                neo4jBasicRelationShip.setId(job.get((Object)"id").toString());
                neo4jBasicRelationShip.setLabel(job.get((Object)"relationName").toString());
                neo4jBasicRelationShip.setSource(job.get((Object)"sourceNodeId").toString());
                neo4jBasicRelationShip.setTarget(job.get((Object)"targetNodeId").toString());
                relationList.add(neo4jBasicRelationShip);
            }
        }
        return relationList;
    }

    @Transactional
    public ApiResponse addGraphDataByTaskId(String taskId) {
        try {
            List<LabelMarkResult> LabelMarkResultList = this.getLabelMarkResultList(taskId);
            HashMap<String, Long> nodeIdmap = new HashMap<String, Long>();
            for (LabelMarkResult labelMarkResult : LabelMarkResultList) {
                String businessId = labelMarkResult.getId();
                String nodeName = labelMarkResult.getText();
                String nodeType = labelMarkResult.getLabelName();
                String queryCQL = "merge(n:" + nodeType + "{businessId:'" + businessId + "',name:'" + nodeName + "'}) return n;";
                Result dataQuery = this.session.query(queryCQL, new HashMap());
                Iterable dataMap = (Iterable)dataQuery.queryResults();
                Long nodeId = null;
                for (Map map : dataMap) {
                    NodeModel model = (NodeModel)map.get("n");
                    nodeId = model.getId();
                    nodeIdmap.put(businessId, nodeId);
                }
            }
            List<Neo4jBasicRelationShip> relationShipList = this.getLabelRelationList(taskId);
            for (Neo4jBasicRelationShip neo4jBasicRelationShip : relationShipList) {
                String sourceBusinessId = neo4jBasicRelationShip.getSource();
                String targetBusinessId = neo4jBasicRelationShip.getTarget();
                Long sourceId = (Long)nodeIdmap.get(sourceBusinessId);
                Long targetId = (Long)nodeIdmap.get(targetBusinessId);
                String relationName = neo4jBasicRelationShip.getLabel();
                String queryRelationCQL = "MATCH (n),(m) where id(m)=" + sourceId + " and id(n)=" + targetId + " merge (m)-[r:" + relationName + "{name:'" + relationName + "'}]-(n)  RETURN m,r";
                Result result = this.session.query(queryRelationCQL, new HashMap());
            }
            return ApiResponse.success((String)"\u6807\u6ce8\u5185\u5bb9\u5165\u56fe\u6210\u529f\uff01");
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new HussarException("\u6807\u6ce8\u5185\u5bb9\u5165\u56fe\u5931\u8d25\uff01");
        }
    }

    @Transactional
    public ApiResponse addLabelSimilar(String taskId) {
        try {
            List<LabelMarkResult> LabelMarkResultList = this.getLabelMarkResultList(taskId);
            ArrayList<LabelMarkResult> changeLabelMarkResultList = new ArrayList<LabelMarkResult>(LabelMarkResultList);
            for (LabelMarkResult labelMarkResult : LabelMarkResultList) {
                String labelId = labelMarkResult.getLabelId();
                String text = labelMarkResult.getText();
                KgLabelNode kgLabelNode = new KgLabelNode();
                kgLabelNode.setId(Long.valueOf(Long.parseLong(labelMarkResult.getId())));
                kgLabelNode.setTaskId(Long.valueOf(Long.parseLong(taskId)));
                kgLabelNode.setLabelType(labelMarkResult.getLabelName());
                kgLabelNode.setLabelTypeId(Long.valueOf(Long.parseLong(labelMarkResult.getLabelId())));
                kgLabelNode.setCreateTime(LocalDateTime.now());
                kgLabelNode.setNodeName(text);
                kgLabelNode.setActiveFlag("0");
                kgLabelNode.setEndOffset(labelMarkResult.getEnd_offset());
                kgLabelNode.setStartOffset(labelMarkResult.getStart_offset());
                kgLabelNode.setWholeSentence(labelMarkResult.getWhole_sentence());
                this.kgLabelNodeService.save((Object)kgLabelNode);
                changeLabelMarkResultList.remove(labelMarkResult);
                for (LabelMarkResult changelabelMarkResult : changeLabelMarkResultList) {
                    double similar;
                    String changelabelId = changelabelMarkResult.getLabelId();
                    String changetext = changelabelMarkResult.getText();
                    if (!labelId.equals(changelabelId) || !((similar = TextSimilarity.similar((String)text, (String)changetext)) > 0.0)) continue;
                    KgLabelAlign kgLabelAlign = new KgLabelAlign();
                    kgLabelAlign.setInstanceAId(Long.valueOf(Long.parseLong(labelMarkResult.getId())));
                    kgLabelAlign.setInstanceAName(labelMarkResult.getText());
                    kgLabelAlign.setInstanceBId(Long.valueOf(Long.parseLong(changelabelMarkResult.getId())));
                    kgLabelAlign.setInstanceBName(changelabelMarkResult.getText());
                    kgLabelAlign.setAlignStatus("\u672a\u5bf9\u9f50");
                    kgLabelAlign.setOrigin("\u6587\u672c\u76f8\u4f3c\u5ea6\u7b97\u6cd5");
                    kgLabelAlign.setLabelType(labelMarkResult.getLabelName());
                    kgLabelAlign.setLabelTypeId(Long.valueOf(Long.parseLong(labelMarkResult.getLabelId())));
                    kgLabelAlign.setSimilarScore(similar + "");
                    kgLabelAlign.setTaskId(Long.valueOf(Long.parseLong(taskId)));
                    kgLabelAlign.setCreateTime(LocalDateTime.now());
                    this.kgLabelAlignService.save((Object)kgLabelAlign);
                }
            }
            QueryWrapper ew = new QueryWrapper();
            ew.eq((Object)"PROJECT_ID", (Object)taskId);
            LabelDoc labelDocInfo = (LabelDoc)this.getOne((Wrapper)ew);
            if (labelDocInfo != null) {
                String annotations;
                String labelRelations = labelDocInfo.getPredications();
                if (!"[]".equals(labelRelations)) {
                    JSONArray relationArray = JSONArray.parseArray((String)labelRelations);
                    for (int i = 0; i < relationArray.size(); ++i) {
                        JSONObject job = relationArray.getJSONObject(i);
                        KgLabelRelation kgLabelRelation = new KgLabelRelation();
                        kgLabelRelation.setId(Long.valueOf(Long.parseLong(job.get((Object)"id").toString())));
                        kgLabelRelation.setLabel(job.get((Object)"relationName").toString());
                        kgLabelRelation.setTaskId(Long.valueOf(Long.parseLong(taskId)));
                        kgLabelRelation.setLabelId(Long.valueOf(Long.parseLong(job.get((Object)"relationId").toString())));
                        kgLabelRelation.setSourceId(Long.valueOf(Long.parseLong(job.get((Object)"sourceNodeId").toString())));
                        kgLabelRelation.setSourceName(job.get((Object)"sourceNodeName").toString());
                        kgLabelRelation.setTargetId(Long.valueOf(Long.parseLong(job.get((Object)"targetNodeId").toString())));
                        kgLabelRelation.setTargetName(job.get((Object)"targetNodeName").toString());
                        kgLabelRelation.setSourceEntityId(Long.valueOf(Long.parseLong(job.get((Object)"sourceEntityId").toString())));
                        kgLabelRelation.setSourceEntityName(job.get((Object)"sourceName").toString());
                        kgLabelRelation.setTargetEntityId(Long.valueOf(Long.parseLong(job.get((Object)"targetEntityId").toString())));
                        kgLabelRelation.setTargetEntityName(job.get((Object)"targetName").toString());
                        kgLabelRelation.setCreateTime(LocalDateTime.now());
                        kgLabelRelation.setWholeSentence(job.get((Object)"whole_sentence").toString());
                        this.kgLabelRelationService.save((Object)kgLabelRelation);
                    }
                }
                if (!"[[]]".equals(annotations = labelDocInfo.getAnnotations())) {
                    JSONArray jsonArray = JSONArray.parseArray((String)annotations);
                    for (int i = 0; i < jsonArray.size(); ++i) {
                        JSONArray jay = jsonArray.getJSONArray(i);
                        if (jay.size() == 0) continue;
                        for (int j = 0; j < jay.size(); ++j) {
                            KgLabelProperty kgLabelProperty = new KgLabelProperty();
                            JSONObject job = jay.getJSONObject(j);
                            if (!"property".equals(job.get((Object)"type").toString())) continue;
                            kgLabelProperty.setActiveFlag("0");
                            kgLabelProperty.setTaskId(Long.valueOf(Long.parseLong(taskId)));
                            kgLabelProperty.setId(Long.valueOf(Long.parseLong(job.get((Object)"id").toString())));
                            kgLabelProperty.setPropertyValue(job.get((Object)"text").toString());
                            kgLabelProperty.setPropertyType(job.get((Object)"propName").toString());
                            kgLabelProperty.setPropertyTypeId(Long.valueOf(Long.parseLong(job.get((Object)"propertyId").toString())));
                            kgLabelProperty.setLabelTypeId(Long.valueOf(Long.parseLong(job.get((Object)"labelId").toString())));
                            kgLabelProperty.setLabelType(job.get((Object)"labelName").toString());
                            kgLabelProperty.setNodeId(Long.valueOf(Long.parseLong(job.get((Object)"instanceId").toString())));
                            kgLabelProperty.setStartOffset(job.get((Object)"start_offset").toString());
                            kgLabelProperty.setEndOffset(job.get((Object)"end_offset").toString());
                            kgLabelProperty.setNodeName(job.get((Object)"instanceName").toString());
                            kgLabelProperty.setCreateTime(LocalDateTime.now());
                            kgLabelProperty.setWholeSentence(job.get((Object)"whole_sentence").toString());
                            this.kgLabelPropertyService.save((Object)kgLabelProperty);
                        }
                    }
                }
            }
            return ApiResponse.success((String)"\u6807\u6ce8\u6570\u636e\u4fdd\u5b58\u6210\u529f\uff01");
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new HussarException("\u6807\u6ce8\u6570\u636e\u4fdd\u5b58\u5931\u8d25\uff01");
        }
    }

    public ApiResponse getLabelSimilarDetail(String alignId) {
        try {
            KgLabelAlign kgLabelAlign = (KgLabelAlign)this.kgLabelAlignService.getById((Serializable)((Object)alignId));
            KgLabelAlignVO kgLabelAlignVO = new KgLabelAlignVO();
            if (kgLabelAlign != null) {
                String activePropertyList;
                String instancBPropertyList;
                String instancAPropertyList;
                String activeRelationList;
                String instancBRelationList;
                String alignStatus = kgLabelAlign.getAlignStatus();
                BeanUtils.copyProperties((Object)kgLabelAlign, (Object)kgLabelAlignVO);
                if ("\u672a\u5bf9\u9f50".equals(alignStatus)) {
                    Long instancAId = kgLabelAlign.getInstanceAId();
                    QueryWrapper kgLabelRelationAQueryWrapper = new QueryWrapper();
                    kgLabelRelationAQueryWrapper.apply("source_id = " + instancAId + "  or target_id = " + instancAId, new Object[0]);
                    List instanceARelationList = this.kgLabelRelationService.list((Wrapper)kgLabelRelationAQueryWrapper);
                    QueryWrapper kgLabelPropertyAQueryWrapper = new QueryWrapper();
                    kgLabelPropertyAQueryWrapper.apply("node_id = " + instancAId, new Object[0]);
                    List instanceAPropertyList = this.kgLabelPropertyService.list((Wrapper)kgLabelPropertyAQueryWrapper);
                    Long instancBId = kgLabelAlign.getInstanceBId();
                    QueryWrapper kgLabelRelationBQueryWrapper = new QueryWrapper();
                    kgLabelRelationBQueryWrapper.apply("source_id = " + instancBId + "  or target_id = " + instancBId, new Object[0]);
                    List instanceBRelationList = this.kgLabelRelationService.list((Wrapper)kgLabelRelationBQueryWrapper);
                    QueryWrapper kgLabelPropertyBQueryWrapper = new QueryWrapper();
                    kgLabelPropertyBQueryWrapper.apply("node_id = " + instancBId, new Object[0]);
                    List instanceBPropertyList = this.kgLabelPropertyService.list((Wrapper)kgLabelPropertyBQueryWrapper);
                    kgLabelAlignVO.setInstancARelationList(instanceARelationList);
                    kgLabelAlignVO.setInstancBRelationList(instanceBRelationList);
                    kgLabelAlignVO.setInstancAPropertyList(instanceAPropertyList);
                    kgLabelAlignVO.setInstancBPropertyList(instanceBPropertyList);
                    return ApiResponse.success((Object)kgLabelAlignVO, (String)"\u83b7\u53d6\u5bf9\u9f50\u6570\u636e\u8be6\u60c5\u6210\u529f\uff01");
                }
                String instancARelationList = kgLabelAlign.getInstancARelationList();
                if (StringUtil.isNotEmpty((String)instancARelationList)) {
                    JSONArray instancARelationListJSONArray = JSON.parseArray((String)instancARelationList);
                    kgLabelAlignVO.setInstancARelationList(instancARelationListJSONArray.toJavaList(KgLabelRelation.class));
                }
                if (StringUtil.isNotEmpty((String)(instancBRelationList = kgLabelAlign.getInstancBRelationList()))) {
                    JSONArray instancBRelationListJSONArray = JSON.parseArray((String)instancBRelationList);
                    kgLabelAlignVO.setInstancBRelationList(instancBRelationListJSONArray.toJavaList(KgLabelRelation.class));
                }
                if (StringUtil.isNotEmpty((String)(activeRelationList = kgLabelAlign.getActiveRelationList()))) {
                    JSONArray activeRelationListJSONArray = JSON.parseArray((String)activeRelationList);
                    kgLabelAlignVO.setActiveRelationList(activeRelationListJSONArray.toJavaList(KgLabelRelation.class));
                }
                if (StringUtil.isNotEmpty((String)(instancAPropertyList = kgLabelAlign.getInstancAPropertyList()))) {
                    JSONArray instancAPropertyListJSONArray = JSON.parseArray((String)instancAPropertyList);
                    kgLabelAlignVO.setInstancAPropertyList(instancAPropertyListJSONArray.toJavaList(KgLabelProperty.class));
                }
                if (StringUtil.isNotEmpty((String)(instancBPropertyList = kgLabelAlign.getInstancBPropertyList()))) {
                    JSONArray instancBPropertyListJSONArray = JSON.parseArray((String)instancBPropertyList);
                    kgLabelAlignVO.setInstancBPropertyList(instancBPropertyListJSONArray.toJavaList(KgLabelProperty.class));
                }
                if (StringUtil.isNotEmpty((String)(activePropertyList = kgLabelAlign.getActiveRelationList()))) {
                    JSONArray activePropertyListJSONArray = JSON.parseArray((String)activePropertyList);
                    kgLabelAlignVO.setActivePropertyList(activePropertyListJSONArray.toJavaList(KgLabelProperty.class));
                }
                return ApiResponse.success((Object)kgLabelAlignVO, (String)"\u83b7\u53d6\u5bf9\u9f50\u6570\u636e\u8be6\u60c5\u6210\u529f\uff01");
            }
            return ApiResponse.success((Object)kgLabelAlignVO, (String)"\u83b7\u53d6\u5bf9\u9f50\u6570\u636e\u8be6\u60c5\u5931\u8d25\uff01\u6ca1\u6709\u67e5\u5230\u76f8\u5173\u6570\u636e");
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new HussarException("\u83b7\u53d6\u5bf9\u9f50\u6570\u636e\u8be6\u60c5\u5931\u8d25\uff01");
        }
    }

    public ApiResponse addOneLabelSimilarData(KgLabelAlign kgLabelAlign) {
        try {
            if (kgLabelAlign != null) {
                this.kgLabelAlignService.updateById((Object)kgLabelAlign);
                Long instanceAId = kgLabelAlign.getInstanceAId();
                Long instanceBId = kgLabelAlign.getInstanceBId();
                String activeInstance = kgLabelAlign.getInstanceAlign();
                String relationalAlignmentRule = kgLabelAlign.getRelationalAlignmentRule();
                String attributesAlignRule = kgLabelAlign.getAttributesAlignRule();
                if ("A".equals(activeInstance)) {
                    KgLabelNode instancA = (KgLabelNode)this.kgLabelNodeService.getById((Serializable)instanceAId);
                    instancA.setActiveFlag("0");
                    this.kgLabelNodeService.updateById((Object)instancA);
                    KgLabelNode instancB = (KgLabelNode)this.kgLabelNodeService.getById((Serializable)instanceBId);
                    instancB.setActiveFlag("1");
                    this.kgLabelNodeService.updateById((Object)instancB);
                    String instanceATypeName = instancA.getLabelType();
                    Long instanceATypeId = instancA.getLabelTypeId();
                    String instanceAName = instancA.getNodeName();
                    QueryWrapper kgLabelRelationQueryWrapper = new QueryWrapper();
                    kgLabelRelationQueryWrapper.apply("source_id = " + instanceBId + "  or target_id = " + instanceBId, new Object[0]);
                    List instanceBRelationList = this.kgLabelRelationService.list((Wrapper)kgLabelRelationQueryWrapper);
                    if ("0".equals(relationalAlignmentRule)) {
                        for (KgLabelRelation kgLabelBRelation : instanceBRelationList) {
                            if (instanceBId == kgLabelBRelation.getTargetId()) {
                                kgLabelBRelation.setTargetEntityName(instanceATypeName);
                                kgLabelBRelation.setTargetEntityId(instanceATypeId);
                                kgLabelBRelation.setTargetName(instanceAName);
                                kgLabelBRelation.setTargetId(instanceAId);
                            }
                            if (instanceBId == kgLabelBRelation.getSourceId()) {
                                kgLabelBRelation.setSourceEntityName(instanceATypeName);
                                kgLabelBRelation.setSourceEntityId(instanceATypeId);
                                kgLabelBRelation.setSourceName(instanceAName);
                                kgLabelBRelation.setSourceId(instanceAId);
                            }
                            this.kgLabelRelationService.updateById((Object)kgLabelBRelation);
                        }
                    } else {
                        this.kgLabelRelationService.remove((Wrapper)kgLabelRelationQueryWrapper);
                    }
                } else {
                    KgLabelNode instancA = (KgLabelNode)this.kgLabelNodeService.getById((Serializable)instanceAId);
                    instancA.setActiveFlag("1");
                    this.kgLabelNodeService.updateById((Object)instancA);
                    KgLabelNode instancB = (KgLabelNode)this.kgLabelNodeService.getById((Serializable)instanceBId);
                    instancB.setActiveFlag("0");
                    this.kgLabelNodeService.updateById((Object)instancB);
                    String instanceBTypeName = instancB.getLabelType();
                    Long instanceBTypeId = instancB.getLabelTypeId();
                    String instanceBName = instancB.getNodeName();
                    QueryWrapper kgLabelRelationQueryWrapper = new QueryWrapper();
                    kgLabelRelationQueryWrapper.apply("source_id = " + instanceAId + "  or target_id = " + instanceAId, new Object[0]);
                    List instanceARelationList = this.kgLabelRelationService.list((Wrapper)kgLabelRelationQueryWrapper);
                    if ("0".equals(relationalAlignmentRule)) {
                        for (KgLabelRelation kgLabelARelation : instanceARelationList) {
                            if (instanceBId == kgLabelARelation.getTargetId()) {
                                kgLabelARelation.setTargetEntityName(instanceBTypeName);
                                kgLabelARelation.setTargetEntityId(instanceBTypeId);
                                kgLabelARelation.setTargetName(instanceBName);
                                kgLabelARelation.setTargetId(instanceBId);
                            }
                            if (instanceBId == kgLabelARelation.getSourceId()) {
                                kgLabelARelation.setSourceEntityName(instanceBTypeName);
                                kgLabelARelation.setSourceEntityId(instanceBTypeId);
                                kgLabelARelation.setSourceName(instanceBName);
                                kgLabelARelation.setSourceId(instanceBId);
                            }
                            this.kgLabelRelationService.updateById((Object)kgLabelARelation);
                        }
                    } else {
                        this.kgLabelRelationService.remove((Wrapper)kgLabelRelationQueryWrapper);
                    }
                }
            }
            return ApiResponse.success((String)"\u5b58\u50a8\u5bf9\u9f50\u6570\u636e\u6210\u529f\uff01");
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new HussarException("\u5b58\u50a8\u5bf9\u9f50\u6570\u636e\u5931\u8d25\uff01");
        }
    }

    public ApiResponse getAlignGraphByTaskId(String taskId) {
        try {
            JSONObject resultObj = new JSONObject();
            ArrayList<Neo4jBasicNode> nodeList = new ArrayList<Neo4jBasicNode>();
            ArrayList<Neo4jBasicRelationShip> relationShipList = new ArrayList<Neo4jBasicRelationShip>();
            QueryWrapper kgLabelNodeQueryWrapper = new QueryWrapper();
            kgLabelNodeQueryWrapper.apply("task_id = " + taskId + "  and  active_flag = '0' ", new Object[0]);
            List instanceNodeList = this.kgLabelNodeService.list((Wrapper)kgLabelNodeQueryWrapper);
            QueryWrapper kgLabelRelationQueryWrapper = new QueryWrapper();
            kgLabelRelationQueryWrapper.apply("task_id = " + taskId, new Object[0]);
            List instanceRelationList = this.kgLabelRelationService.list((Wrapper)kgLabelRelationQueryWrapper);
            for (KgLabelNode KgLabelNode2 : instanceNodeList) {
                Neo4jBasicNode node = new Neo4jBasicNode();
                node.setId(KgLabelNode2.getId().toString());
                node.setLabel(KgLabelNode2.getNodeName());
                node.setNodeType(KgLabelNode2.getLabelType());
                nodeList.add(node);
            }
            for (KgLabelRelation kgLabelRelation : instanceRelationList) {
                Neo4jBasicRelationShip neo4jBasicRelationShip = new Neo4jBasicRelationShip();
                neo4jBasicRelationShip.setId(kgLabelRelation.getId().toString());
                neo4jBasicRelationShip.setLabel(kgLabelRelation.getLabel());
                neo4jBasicRelationShip.setSource(kgLabelRelation.getSourceId().toString());
                neo4jBasicRelationShip.setTarget(kgLabelRelation.getTargetId().toString());
                relationShipList.add(neo4jBasicRelationShip);
            }
            resultObj.put("nodes", nodeList);
            resultObj.put("edges", relationShipList);
            return ApiResponse.success((Object)resultObj);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new HussarException("\u6807\u6ce8\u5bf9\u9f50\u540e\u56fe\u8c31\u9884\u89c8\u5931\u8d25\uff01");
        }
    }

    @Transactional
    public ApiResponse addAlignDataToGraphByTaskId(String taskId) {
        try {
            Object nodeId;
            QueryWrapper kgLabelNodeQueryWrapper = new QueryWrapper();
            kgLabelNodeQueryWrapper.apply("task_id = " + taskId + "  and  active_flag = '0' ", new Object[0]);
            List instanceNodeList = this.kgLabelNodeService.list((Wrapper)kgLabelNodeQueryWrapper);
            HashMap<String, Result> nodeIdmap = new HashMap<String, Result>();
            QueryWrapper kgLabelRelationQueryWrapper = new QueryWrapper();
            kgLabelRelationQueryWrapper.apply("task_id = " + taskId, new Object[0]);
            List instanceRelationList = this.kgLabelRelationService.list((Wrapper)kgLabelRelationQueryWrapper);
            for (KgLabelNode KgLabelNode2 : instanceNodeList) {
                String businessId = KgLabelNode2.getId().toString();
                String nodeName = KgLabelNode2.getNodeName();
                String nodeType = KgLabelNode2.getLabelType();
                String queryCQL = "merge(n:" + nodeType + "{businessId:'" + businessId + "',name:'" + nodeName + "'}) return n;";
                Result dataQuery = this.session.query(queryCQL, new HashMap());
                Iterable dataMap = (Iterable)dataQuery.queryResults();
                nodeId = null;
                for (Map map : dataMap) {
                    NodeModel model = (NodeModel)map.get("n");
                    nodeId = model.getId();
                    nodeIdmap.put(businessId, (Result)nodeId);
                }
            }
            for (KgLabelRelation kgLabelRelation : instanceRelationList) {
                String sourceBusinessId = kgLabelRelation.getSourceId().toString();
                String targetBusinessId = kgLabelRelation.getTargetId().toString();
                Long sourceId = (Long)nodeIdmap.get(sourceBusinessId);
                Long targetId = (Long)nodeIdmap.get(targetBusinessId);
                String relationName = kgLabelRelation.getLabel();
                String queryRelationCQL = "MATCH (n),(m) where id(m)=" + sourceId + " and id(n)=" + targetId + " merge (m)-[r:" + relationName + "{name:'" + relationName + "'}]-(n)  RETURN m,r";
                nodeId = this.session.query(queryRelationCQL, new HashMap());
            }
            QueryWrapper kgLabelAlignQueryWrapper = new QueryWrapper();
            kgLabelAlignQueryWrapper.apply("task_id = " + taskId, new Object[0]);
            List kglabelAlignList = this.kgLabelAlignService.list((Wrapper)kgLabelAlignQueryWrapper);
            for (KgLabelAlign kgLabelAlign : kglabelAlignList) {
                String activePropertyList = kgLabelAlign.getActivePropertyList();
                JSONArray activePropertyListJSONArray = JSON.parseArray((String)activePropertyList);
                List kgLabelPropertiesList = activePropertyListJSONArray.toJavaList(KgLabelProperty.class);
                for (KgLabelProperty kgLabelProperty : kgLabelPropertiesList) {
                    Long nodeBusinessId = kgLabelProperty.getNodeId();
                    Long nodeId2 = (Long)nodeIdmap.get(nodeBusinessId.toString());
                    String propertyType = kgLabelProperty.getPropertyType();
                    String PropertyValue = kgLabelProperty.getPropertyValue();
                    String queryPropertyCQL = "MATCH (n) where id(n)=" + nodeId2 + "  set n." + propertyType + "='" + PropertyValue + "' RETURN n";
                    Result result = this.session.query(queryPropertyCQL, new HashMap());
                }
            }
            KgTaggingTask1 kgTaggingTask1 = (KgTaggingTask1)this.kgTaggingTask1Service.getById((Serializable)((Object)taskId));
            kgTaggingTask1.setAuditState("5");
            this.kgTaggingTask1Service.updateById((Object)kgTaggingTask1);
            return ApiResponse.success((String)"\u6807\u6ce8\u5bf9\u9f50\u6570\u636e\u5165\u56fe\u6210\u529f\uff01");
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new HussarException("\u6807\u6ce8\u5bf9\u9f50\u6570\u636e\u5165\u56fe\u5931\u8d25\uff01");
        }
    }

    public ApiResponse kgAnnotatedCorpusList(String taskId) {
        try {
            JSONObject jsonObject = new JSONObject();
            QueryWrapper nodeEw = new QueryWrapper();
            nodeEw.eq((Object)"task_id", (Object)taskId);
            List nodelist = this.kgLabelNodeService.list((Wrapper)nodeEw);
            ArrayList<KgAnnotatedCorpusVO> kgAnnotatedCorpusList = new ArrayList<KgAnnotatedCorpusVO>();
            for (KgLabelNode kgLabelNode : nodelist) {
                KgAnnotatedCorpusVO kgAnnotatedCorpusVO = new KgAnnotatedCorpusVO();
                kgAnnotatedCorpusVO.setLabelType(kgLabelNode.getLabelType());
                kgAnnotatedCorpusVO.setNodeName(kgLabelNode.getNodeName());
                kgAnnotatedCorpusVO.setWholeSentence(kgLabelNode.getWholeSentence());
                kgAnnotatedCorpusVO.setStartOffset(kgLabelNode.getStartOffset());
                kgAnnotatedCorpusVO.setEndOffset(kgLabelNode.getEndOffset());
                kgAnnotatedCorpusList.add(kgAnnotatedCorpusVO);
            }
            jsonObject.put("nodeList", kgAnnotatedCorpusList);
            QueryWrapper relationEw = new QueryWrapper();
            relationEw.eq((Object)"task_id", (Object)taskId);
            List relationList = this.kgLabelRelationService.list((Wrapper)relationEw);
            ArrayList<KgAnnotatedCorpusRelationVO> kgAnnotatedCorpusRelationList = new ArrayList<KgAnnotatedCorpusRelationVO>();
            for (KgLabelRelation kgLabelRelation : relationList) {
                KgAnnotatedCorpusRelationVO kgAnnotatedCorpusRelationVO = new KgAnnotatedCorpusRelationVO();
                kgAnnotatedCorpusRelationVO.setRel(kgLabelRelation.getLabel());
                kgAnnotatedCorpusRelationVO.setEnt1(kgLabelRelation.getSourceName());
                kgAnnotatedCorpusRelationVO.setEnt2(kgLabelRelation.getTargetName());
                kgAnnotatedCorpusRelationVO.setText(kgLabelRelation.getWholeSentence());
                kgAnnotatedCorpusRelationList.add(kgAnnotatedCorpusRelationVO);
            }
            jsonObject.put("relationList", kgAnnotatedCorpusRelationList);
            QueryWrapper propertyEw = new QueryWrapper();
            propertyEw.eq((Object)"task_id", (Object)taskId);
            List kgLabelPropertyList = this.kgLabelPropertyService.list((Wrapper)propertyEw);
            ArrayList<KgAnnotatedCorpusPropertyVO> kgLabelPropertyVoList = new ArrayList<KgAnnotatedCorpusPropertyVO>();
            for (KgLabelProperty kgLabelProperty : kgLabelPropertyList) {
                KgAnnotatedCorpusPropertyVO kgAnnotatedCorpusPropertyVO = new KgAnnotatedCorpusPropertyVO();
                kgAnnotatedCorpusPropertyVO.setPropKey(kgLabelProperty.getPropertyType());
                kgAnnotatedCorpusPropertyVO.setEnt(kgLabelProperty.getNodeName());
                kgAnnotatedCorpusPropertyVO.setPropVal(kgLabelProperty.getPropertyValue());
                kgAnnotatedCorpusPropertyVO.setText(kgLabelProperty.getWholeSentence());
                kgLabelPropertyVoList.add(kgAnnotatedCorpusPropertyVO);
            }
            jsonObject.put("propertyList", kgLabelPropertyVoList);
            return ApiResponse.success((Object)jsonObject);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new HussarException("\u6807\u6ce8\u8bed\u6599\u6570\u636e\u83b7\u53d6\u5931\u8d25\uff01");
        }
    }

    public void kgAnnotatedCorpusRelationExport(HttpServletRequest request, HttpServletResponse response, String taskId) {
        String filePath = this.hussarConfig.getFileUploadPath();
        QueryWrapper relationEw = new QueryWrapper();
        relationEw.eq((Object)"task_id", (Object)taskId);
        List relationList = this.kgLabelRelationService.list((Wrapper)relationEw);
        ArrayList<KgAnnotatedCorpusRelationVO> kgAnnotatedCorpusRelationList = new ArrayList<KgAnnotatedCorpusRelationVO>();
        for (KgLabelRelation kgLabelRelation : relationList) {
            KgAnnotatedCorpusRelationVO kgAnnotatedCorpusRelationVO = new KgAnnotatedCorpusRelationVO();
            kgAnnotatedCorpusRelationVO.setRel(kgLabelRelation.getLabel());
            kgAnnotatedCorpusRelationVO.setEnt1(kgLabelRelation.getSourceName());
            kgAnnotatedCorpusRelationVO.setEnt2(kgLabelRelation.getTargetName());
            kgAnnotatedCorpusRelationVO.setText(kgLabelRelation.getWholeSentence());
            kgAnnotatedCorpusRelationList.add(kgAnnotatedCorpusRelationVO);
        }
        JSONArray jsonArray = JSONArray.parseArray((String)JSONObject.toJSONString(kgAnnotatedCorpusRelationList));
        KgTaggingTask1 kgTaggingTask1 = (KgTaggingTask1)this.kgTaggingTask1Service.getById((Serializable)((Object)taskId));
        String fileName = kgTaggingTask1.getTaskName() + UUID.randomUUID();
        String fullPath = filePath + File.separator + fileName + ".json";
        try {
            File file = new File(fullPath);
            if (!file.getParentFile().exists()) {
                file.getParentFile().mkdirs();
            }
            if (file.exists()) {
                file.delete();
            }
            file.createNewFile();
            OutputStreamWriter write = new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8");
            String osName = System.getProperties().getProperty("os.name");
            String lineflag = "";
            lineflag = osName.equalsIgnoreCase("Linux") ? "/n" : "\r\n";
            for (int i = 0; i < jsonArray.size(); ++i) {
                write.write(jsonArray.get(i).toString());
                write.write(lineflag);
            }
            ((Writer)write).flush();
            ((Writer)write).close();
            String userAgent = request.getHeader("User-Agent");
            String realName = "";
            if (StringUtil.isNotEmpty((String)userAgent) && userAgent.toLowerCase().indexOf("firefox") > 0) {
                byte[] sbytes = userAgent.contains("MSIE") ? fileName.getBytes() : fileName.getBytes("UTF-8");
                realName = new String(sbytes, "ISO-8859-1");
            } else {
                realName = LabelDocServiceImpl.transferSpecialChar(URLEncoder.encode(fileName, "UTF-8"));
            }
            response.setHeader("Content-disposition", String.format("attachment; filename=\"%s\"", realName + ".json"));
            response.setContentType("application/download");
            response.setCharacterEncoding("UTF-8");
            FileInputStream input = null;
            ServletOutputStream out = null;
            out = response.getOutputStream();
            input = new FileInputStream(file);
            byte[] buffer = new byte[10240];
            int lenth = -1;
            while ((lenth = input.read(buffer)) != -1) {
                out.write(buffer, 0, lenth);
            }
            input.close();
            out.close();
            file.delete();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String transferSpecialChar(String str) {
        if (str == null) {
            return str;
        }
        if ("".equals(str)) {
            return str;
        }
        return str.replaceAll("\\+", "%20").replaceAll("%28", "\\(").replaceAll("%29", "\\)").replaceAll("%3B", ";").replaceAll("%40", "@").replaceAll("%23", "\\#").replaceAll("%26", "\\&").replaceAll("%2C", "\\,").replaceAll("%2B", "\\+").replaceAll("%7D", "\\}").replaceAll("%7B", "\\{").replaceAll("%24", "\\$").replaceAll("%5E", "\\^").replaceAll("%25", "\\%").replaceAll("%7E", "\\~").replaceAll("%3D", "\\=").replaceAll("%60", "\\`");
    }
}

