/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.kgbase.build.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jxdinfo.hussar.core.exception.HussarException;
import com.jxdinfo.hussar.kgbase.build.dao.NodeDao;
import com.jxdinfo.hussar.kgbase.build.model.dto.NodeDTO;
import com.jxdinfo.hussar.kgbase.build.model.po.Concept;
import com.jxdinfo.hussar.kgbase.build.model.po.Groups;
import com.jxdinfo.hussar.kgbase.build.model.po.Node;
import com.jxdinfo.hussar.kgbase.build.model.po.RelProperty;
import com.jxdinfo.hussar.kgbase.build.model.po.Relation;
import com.jxdinfo.hussar.kgbase.build.service.IConceptService;
import com.jxdinfo.hussar.kgbase.build.service.INodeService;
import com.jxdinfo.hussar.kgbase.build.service.IRelPropertyService;
import com.jxdinfo.hussar.kgbase.build.service.IRelationService;
import com.jxdinfo.hussar.kgbase.common.util.ColorUtil;
import com.jxdinfo.hussar.kgbase.common.util.ListUtil;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class NodeServiceImpl
extends ServiceImpl<NodeDao, Node>
implements INodeService {
    @Autowired
    private IRelationService iRelationService;
    @Autowired
    private IConceptService iConceptService;
    @Autowired
    private IRelPropertyService iRelPropertyService;
    @Autowired
    private NodeDao nodeDao;

    public String addOrEdit(NodeDTO nodeDTO) {
        Node node = new Node();
        BeanUtil.copyProperties((Object)nodeDTO, (Object)node);
        if (nodeDTO.getId() != null) {
            this.updateById(node);
        } else {
            QueryWrapper nodeWrapper = new QueryWrapper();
            nodeWrapper.eq((Object)"DEL_FLAG", (Object)"0");
            nodeWrapper.eq((Object)"CONCEPT_ID", (Object)nodeDTO.getConceptId());
            Node existNode = (Node)this.getOne((Wrapper)nodeWrapper);
            if (existNode == null) {
                node.setDelFlag("0");
                Random rand = new Random();
                String randomElement = ColorUtil.getColors("").get(rand.nextInt(ColorUtil.getColors("").size()));
                node.setNodeColor(randomElement);
                this.save(node);
            } else {
                throw new HussarException("\u8be5\u8282\u70b9\u5df2\u5b58\u5728\uff0c\u8bf7\u52ff\u91cd\u590d\u6dfb\u52a0\uff01");
            }
        }
        return node.getId();
    }

    public void delete(NodeDTO nodeDTO) {
        if (nodeDTO.getId() == null && nodeDTO.getConceptId() != null) {
            QueryWrapper nodeWrapper = new QueryWrapper();
            nodeWrapper.eq((Object)"DEL_FLAG", (Object)"0");
            nodeWrapper.eq((Object)"CONCEPT_ID", (Object)nodeDTO.getConceptId());
            Node existNode = (Node)this.getOne((Wrapper)nodeWrapper);
            if (existNode != null) {
                nodeDTO.setId(existNode.getId());
            }
        }
        if (nodeDTO.getId() != null) {
            this.removeById((Serializable)((Object)nodeDTO.getId()));
            LambdaQueryWrapper beginWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.query().lambda().eq(Relation::getDelFlag, (Object)"0")).eq(Relation::getSourceNode, (Object)nodeDTO.getId());
            List relationsBegin = this.iRelationService.list((Wrapper)beginWrapper);
            this.iRelationService.remove((Wrapper)beginWrapper);
            LambdaQueryWrapper targetWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.query().lambda().eq(Relation::getDelFlag, (Object)"0")).eq(Relation::getTargetNode, (Object)nodeDTO.getId());
            List relationsTarget = this.iRelationService.list((Wrapper)targetWrapper);
            this.iRelationService.remove((Wrapper)targetWrapper);
            relationsBegin.addAll(relationsTarget);
            List idList = relationsBegin.stream().map(Relation::getId).collect(Collectors.toList());
            if (idList.size() > 0) {
                this.iRelPropertyService.remove((Wrapper)Wrappers.query().lambda().in(RelProperty::getRelationId, idList));
            }
        }
    }

    public Map<String, Object> getAllNodes() {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        List nodeList = this.list();
        ArrayList nodeDTOS = new ArrayList();
        ListUtil.copyList(nodeList, nodeDTOS, NodeDTO.class);
        List conceptList = this.iConceptService.list();
        for (NodeDTO nodeDTO : nodeDTOS) {
            for (Concept concept : conceptList) {
                if (nodeDTO.getConceptId() == null || concept.getId() == null || !nodeDTO.getConceptId().equals(concept.getId())) continue;
                nodeDTO.setConcept(concept);
            }
        }
        resultMap.put("nodes", nodeDTOS);
        resultMap.put("relations", this.iRelationService.list());
        return resultMap;
    }

    public Map<String, Object> getNodesByGroup(String groupId) {
        HashMap<String, Object> resultMap = new HashMap();
        if (!StringUtil.isEmpty((Object)groupId)) {
            ArrayList<String> delGroupIdList = new ArrayList<String>();
            delGroupIdList.add(groupId);
            while (!StringUtil.isEmpty((Object)groupId)) {
                List<Groups> groupsList = this.nodeDao.getGroupsList(groupId);
                groupId = "";
                for (Groups item : groupsList) {
                    delGroupIdList.add(item.getId());
                    groupId = groupId + item.getId() + ",";
                }
                if (StringUtil.isEmpty((Object)groupId)) continue;
                groupId = groupId.substring(0, groupId.length() - 1);
            }
            List<Node> nodeList = this.nodeDao.getNodeList(StringUtils.join((Object[])delGroupIdList.toArray(), (String)","));
            ArrayList nodeDTOS = new ArrayList();
            ListUtil.copyList(nodeList, nodeDTOS, NodeDTO.class);
            List conceptList = this.iConceptService.list();
            for (NodeDTO nodeDTO : nodeDTOS) {
                for (Concept concept : conceptList) {
                    if (nodeDTO.getConceptId() == null || concept.getId() == null || !nodeDTO.getConceptId().equals(concept.getId())) continue;
                    nodeDTO.setConcept(concept);
                }
            }
            resultMap.put("nodes", nodeDTOS);
            resultMap.put("relations", this.iRelationService.list());
        } else {
            resultMap = this.getAllNodes();
        }
        return resultMap;
    }
}

