/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.kgbase.build.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.jxdinfo.hussar.kgbase.build.dao.ConceptDao;
import com.jxdinfo.hussar.kgbase.build.dao.ImExportDao;
import com.jxdinfo.hussar.kgbase.build.model.po.Concept;
import com.jxdinfo.hussar.kgbase.build.model.po.Groups;
import com.jxdinfo.hussar.kgbase.build.model.po.Node;
import com.jxdinfo.hussar.kgbase.build.model.po.Property;
import com.jxdinfo.hussar.kgbase.build.model.po.RelProperty;
import com.jxdinfo.hussar.kgbase.build.model.po.Relation;
import com.jxdinfo.hussar.kgbase.build.model.vo.ImExportModel.ImExportVO;
import com.jxdinfo.hussar.kgbase.build.service.IConceptService;
import com.jxdinfo.hussar.kgbase.build.service.IGroupService;
import com.jxdinfo.hussar.kgbase.build.service.INodeService;
import com.jxdinfo.hussar.kgbase.build.service.IPropertyService;
import com.jxdinfo.hussar.kgbase.build.service.IRelPropertyService;
import com.jxdinfo.hussar.kgbase.build.service.IRelationService;
import com.jxdinfo.hussar.kgbase.build.service.ImExportService;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

@Service
public class ImExportServiceImpl
extends ServiceImpl<ConceptDao, Concept>
implements ImExportService {
    @Resource
    private IGroupService iGroupService;
    @Resource
    private INodeService iNodeService;
    @Resource
    private IConceptService iConceptService;
    @Resource
    private IPropertyService iPropertyService;
    @Resource
    private IRelationService iRelationService;
    @Resource
    private IRelPropertyService iRelPropertyService;
    @Resource
    private ImExportDao imExportDao;

    public void export(HttpServletRequest request, HttpServletResponse response) {
        ImExportVO res = new ImExportVO();
        List nodeList = this.iNodeService.list();
        List groupList = this.iGroupService.list();
        ArrayList<Groups> useGroupList = new ArrayList<Groups>();
        List conceptList = this.iConceptService.list();
        ArrayList<Object> entityList = new ArrayList<Object>();
        for (Concept concept : conceptList) {
            HashMap<String, Concept> tem = new HashMap<String, Concept>();
            tem.put("concept", concept);
            for (Groups group : groupList) {
                if (!StringUtil.equals((CharSequence)concept.getParentId(), (CharSequence)group.getId())) continue;
                if (!useGroupList.contains(group)) {
                    useGroupList.add(group);
                }
                tem.put("group", (Concept)group);
            }
            QueryWrapper propWrapper = new QueryWrapper();
            propWrapper.eq((Object)"DEL_FLAG", (Object)"0");
            propWrapper.eq((Object)"CONCEPT_ID", (Object)concept.getId());
            List propList = this.iPropertyService.list((Wrapper)propWrapper);
            tem.put("properties", (Concept)propList);
            for (Node node : nodeList) {
                if (!StringUtil.equals((CharSequence)concept.getId(), (CharSequence)node.getConceptId())) continue;
                tem.put("nodeStyle", (Concept)node);
            }
            entityList.add(tem);
        }
        ArrayList relList = new ArrayList();
        List relations = this.iRelationService.list();
        for (Relation rel : relations) {
            HashMap<String, Object> tem = new HashMap<String, Object>();
            tem.put("relation", rel);
            List<Groups> groups = this.imExportDao.getGroupByRelation(rel.getId());
            if (groups.size() > 0) {
                for (Groups i : groups) {
                    if (useGroupList.contains(i)) continue;
                    useGroupList.add(i);
                }
            }
            tem.put("group", groups);
            QueryWrapper relWr = new QueryWrapper();
            relWr.eq((Object)"DEL_FLAG", (Object)"0");
            relWr.eq((Object)"RELATION_ID", (Object)rel.getId());
            List propList = this.iRelPropertyService.list((Wrapper)relWr);
            tem.put("relProperties", propList);
            relList.add(tem);
        }
        groupList.removeAll(useGroupList);
        res.setName("aaa");
        res.setNodeList(entityList);
        res.setRelationList(relList);
        res.setNoUserGroupList(groupList);
        String content = JSON.toJSONString((Object)res);
        try {
            ImExportServiceImpl.downloadByStringContent(request, response, content);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Transactional
    public boolean importTxt(MultipartFile file) {
        InputStream is = null;
        StringBuffer sb = new StringBuffer();
        try {
            is = file.getInputStream();
            InputStreamReader isReader = new InputStreamReader(is, StandardCharsets.UTF_8);
            BufferedReader br = new BufferedReader(isReader);
            while (br.ready()) {
                sb.append(br.readLine());
            }
            br.close();
            ImExportVO imExportVO = (ImExportVO)JSON.parseObject((String)String.valueOf(sb), ImExportVO.class);
            List imExGroups = imExportVO.getNoUserGroupList();
            List nodeList = imExportVO.getNodeList();
            Iterator iterator = nodeList.iterator();
            while (iterator.hasNext()) {
                ObjectMapper objectMapper = new ObjectMapper();
                Map tem = (Map)iterator.next();
                Groups cg = (Groups)objectMapper.convertValue(tem.get("group"), Groups.class);
                if (cg == null) continue;
                boolean lock = false;
                for (Groups i : imExGroups) {
                    if (!StringUtil.equals((CharSequence)i.getId(), (CharSequence)cg.getId())) continue;
                    lock = true;
                }
                if (lock) continue;
                imExGroups.add(cg);
            }
            List relationList = imExportVO.getRelationList();
            for (Object tem : relationList) {
                JSONArray jsonArray = (JSONArray)tem.get("group");
                for (Object ob : jsonArray) {
                    ObjectMapper objectMapper = new ObjectMapper();
                    Groups cg = (Groups)objectMapper.convertValue(ob, Groups.class);
                    boolean lock = false;
                    for (Object i : imExGroups) {
                        if (!StringUtil.equals((CharSequence)i.getId(), (CharSequence)cg.getId())) continue;
                        lock = true;
                    }
                    if (lock) continue;
                    imExGroups.add(cg);
                }
            }
            if (imExGroups.size() > 0) {
                String ids = "";
                for (Groups i : imExGroups) {
                    ids = ids + i.getId() + ",";
                }
                if (ids != "") {
                    ids = ids.substring(0, ids.length() - 1);
                    List<String> repeatIds = this.imExportDao.getRepeatGroupIds(ids);
                    Iterator iterator2 = imExGroups.iterator();
                    while (iterator2.hasNext()) {
                        boolean tof = false;
                        String iid = ((Groups)iterator2.next()).getId();
                        for (String j : repeatIds) {
                            if (!StringUtil.equals((CharSequence)iid, (CharSequence)j)) continue;
                            tof = true;
                        }
                        if (!tof) continue;
                        iterator2.remove();
                    }
                }
                if (imExGroups.size() > 0) {
                    this.iGroupService.saveBatch((Collection)imExGroups);
                }
            }
            ArrayList<Concept> torelconList = new ArrayList<Concept>();
            for (Map tem : nodeList) {
                Node searchIen;
                Concept searchIec;
                ObjectMapper objectMapper = new ObjectMapper();
                Concept iec = (Concept)objectMapper.convertValue(tem.get("concept"), Concept.class);
                Node ien = (Node)objectMapper.convertValue(tem.get("nodeStyle"), Node.class);
                JSONArray properties = (JSONArray)tem.get("properties");
                ArrayList<Property> addPropertyList = new ArrayList<Property>();
                Object pids = "";
                for (Object ob : properties) {
                    ObjectMapper oM = new ObjectMapper();
                    Property iep = (Property)oM.convertValue(ob, Property.class);
                    addPropertyList.add(iep);
                    pids = (String)pids + iep.getId() + ",";
                }
                if (iec != null && (searchIec = (Concept)this.iConceptService.getById((Serializable)((Object)iec.getId()))) == null) {
                    this.iConceptService.save((Object)iec);
                }
                if (ien != null && (searchIen = (Node)this.iNodeService.getById((Serializable)((Object)ien.getId()))) == null) {
                    this.iNodeService.save((Object)ien);
                }
                if (pids != "") {
                    pids = ((String)pids).substring(0, ((String)pids).length() - 1);
                    List<String> repeatIds = this.imExportDao.getRepeatPropertyIds((String)pids);
                    Iterator iterator3 = addPropertyList.iterator();
                    while (iterator3.hasNext()) {
                        boolean tof = false;
                        String iid = ((Property)iterator3.next()).getId();
                        for (String j : repeatIds) {
                            if (!StringUtil.equals((CharSequence)iid, (CharSequence)j)) continue;
                            tof = true;
                        }
                        if (!tof) continue;
                        iterator3.remove();
                    }
                }
                if (addPropertyList.size() > 0) {
                    this.iPropertyService.saveBatch(addPropertyList);
                }
                torelconList.add(iec);
            }
            for (Map tem : relationList) {
                Relation searchIer;
                ObjectMapper objectMapper = new ObjectMapper();
                Relation ier = (Relation)objectMapper.convertValue(tem.get("relation"), Relation.class);
                JSONArray properties = (JSONArray)tem.get("relProperties");
                ArrayList<RelProperty> addPropertyList = new ArrayList<RelProperty>();
                String rids = "";
                for (Object ob : properties) {
                    ObjectMapper oM = new ObjectMapper();
                    RelProperty ierp = (RelProperty)oM.convertValue(ob, RelProperty.class);
                    addPropertyList.add(ierp);
                    rids = rids + ierp.getId() + ",";
                }
                if (ier != null && (searchIer = (Relation)this.iRelationService.getById((Serializable)((Object)ier.getId()))) == null) {
                    this.iRelationService.save((Object)ier);
                }
                if (rids != "") {
                    rids = rids.substring(0, rids.length() - 1);
                    List<String> repeatIds = this.imExportDao.getRepeatRelationIds(rids);
                    Iterator iterator4 = addPropertyList.iterator();
                    while (iterator4.hasNext()) {
                        boolean tof = false;
                        String iid = ((RelProperty)iterator4.next()).getId();
                        for (String j : repeatIds) {
                            if (!StringUtil.equals((CharSequence)iid, (CharSequence)j)) continue;
                            tof = true;
                        }
                        if (!tof) continue;
                        iterator4.remove();
                    }
                }
                if (addPropertyList.size() <= 0) continue;
                this.iRelPropertyService.saveBatch(addPropertyList);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void downloadByStringContent(HttpServletRequest request, HttpServletResponse response, String content) throws IOException {
        response.setContentType("application/octet-stream;charset=utf-8");
        response.setCharacterEncoding("utf-8");
        response.setHeader("Content-disposition", "attachment; filename=data.txt");
        BufferedInputStream inp = null;
        ServletOutputStream out = response.getOutputStream();
        try {
            inp = new BufferedInputStream(new ByteArrayInputStream(content.getBytes("utf-8")));
            int len = 0;
            byte[] buf = new byte[1024];
            while ((len = inp.read(buf)) > 0) {
                out.write(buf, 0, len);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (inp != null) {
                inp.close();
            }
            if (out != null) {
                out.close();
            }
        }
    }
}

