/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.kgbase.build.controller;

import com.jxdinfo.hussar.core.exception.HussarException;
import com.jxdinfo.hussar.kgbase.build.model.dto.RelPropertyDTO;
import com.jxdinfo.hussar.kgbase.build.service.IRelPropertyService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.support.audit.core.annotations.AuditLog;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventGrade;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventType;
import java.io.Serializable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/relProperty"})
public class RelPropertyController {
    @Autowired
    private IRelPropertyService iRelPropertyService;

    @AuditLog(moduleName="\u5173\u7cfb\u5c5e\u6027", eventDesc="\u65b0\u589e\u6216\u4fee\u6539", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.INSERT)
    @PostMapping(value={"/addOrEdit"})
    public ApiResponse addOrEdit(@RequestBody RelPropertyDTO relPropertyDTO) {
        try {
            return ApiResponse.success((String)this.iRelPropertyService.addOrEdit(relPropertyDTO));
        }
        catch (HussarException e) {
            e.printStackTrace();
            return ApiResponse.fail((String)e.getMessage());
        }
    }

    @AuditLog(moduleName="\u5173\u7cfb\u5c5e\u6027", eventDesc="\u5220\u9664", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.DELETE)
    @PostMapping(value={"/delete"})
    public ApiResponse delete(@RequestBody RelPropertyDTO relPropertyDTO) {
        try {
            this.iRelPropertyService.removeById((Serializable)((Object)relPropertyDTO.getId()));
        }
        catch (HussarException e) {
            e.printStackTrace();
            return ApiResponse.fail((String)e.getMessage());
        }
        return ApiResponse.success();
    }

    @AuditLog(moduleName="\u5173\u7cfb\u5c5e\u6027", eventDesc="\u67e5\u8be2\u5173\u7cfb\u5c5e\u6027\u5217\u8868", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.QUERY)
    @PostMapping(value={"/list"})
    public ApiResponse list(@RequestBody RelPropertyDTO relPropertyDTO) {
        return this.iRelPropertyService.getRelPropertyList(relPropertyDTO);
    }
}

