/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.kgbase.application.ksearch.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.core.exception.HussarException;
import com.jxdinfo.hussar.kgbase.application.ksearch.model.dto.Graph;
import com.jxdinfo.hussar.kgbase.application.ksearch.model.dto.KSearchPlusConditonDTO;
import com.jxdinfo.hussar.kgbase.application.ksearch.model.dto.KSearchPlusCypherDTO;
import com.jxdinfo.hussar.kgbase.application.ksearch.model.dto.KSearchPlusDTO;
import com.jxdinfo.hussar.kgbase.application.ksearch.model.dto.KSearchPlusPropDTO;
import com.jxdinfo.hussar.kgbase.application.ksearch.model.dto.KSearchPlusRelDTO;
import com.jxdinfo.hussar.kgbase.application.ksearch.service.KSearchPlusService;
import com.jxdinfo.hussar.kgbase.common.util.GraphUtil;
import com.jxdinfo.hussar.kgbase.common.util.MathUtil;
import com.jxdinfo.hussar.kgbase.neo4j.model.Neo4jBasicNode;
import com.jxdinfo.hussar.kgbase.neo4j.model.Neo4jBasicRelationShip;
import com.jxdinfo.hussar.kgbase.neo4j.repository.GraphQueryRepository;
import com.jxdinfo.hussar.kgbase.neo4j.util.Neo4jUtil;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import org.neo4j.driver.internal.InternalPath;
import org.neo4j.driver.types.Node;
import org.neo4j.driver.types.Relationship;
import org.neo4j.ogm.model.Result;
import org.neo4j.ogm.response.model.NodeModel;
import org.neo4j.ogm.response.model.RelationshipModel;
import org.neo4j.ogm.session.Session;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
public class KSearchPlusServiceImpl
implements KSearchPlusService {
    @Resource
    private Session session;
    @Resource
    private GraphQueryRepository graphQueryRepository;

    public JSONObject queryByConditions(List<LinkedHashMap<String, KSearchPlusDTO>> queryPaths) {
        JSONObject resultObj = new JSONObject();
        ArrayList<Neo4jBasicNode> nodeList = new ArrayList<Neo4jBasicNode>();
        ArrayList<Neo4jBasicRelationShip> relationShipList = new ArrayList<Neo4jBasicRelationShip>();
        for (LinkedHashMap<String, KSearchPlusDTO> queryPath : queryPaths) {
            ArrayList<String> itemIndexList = new ArrayList<String>();
            StringBuffer cypherSQL = new StringBuffer();
            cypherSQL.append("MATCH data=");
            ArrayList propConditons = new ArrayList();
            int index = 0;
            for (Map.Entry<String, KSearchPlusDTO> entry : queryPath.entrySet()) {
                itemIndexList.add(entry.getKey());
                if (entry.getKey().contains("n")) {
                    if (index != 0) {
                        String relItemIndex = "r" + index;
                        cypherSQL.append("-[").append(relItemIndex).append("]-");
                        itemIndexList.add(relItemIndex);
                    }
                    ++index;
                    KSearchPlusDTO item = entry.getValue();
                    String nodeType = item.getNodeType();
                    cypherSQL.append("(").append(entry.getKey()).append(":`").append(nodeType).append("`) ");
                    if (item.getPropConditions() == null || item.getPropConditions().size() <= 0) continue;
                    for (KSearchPlusPropDTO propDTO : item.getPropConditions()) {
                        propDTO.setItemIndex(entry.getKey());
                    }
                    propConditons.addAll(item.getPropConditions());
                    continue;
                }
                throw new HussarException("\u65e0\u6548\u6761\u4ef6\u914d\u7f6e");
            }
            cypherSQL.append(" WHERE 1 = 1 ");
            String condition = "";
            for (KSearchPlusPropDTO propConditon : propConditons) {
                condition = this.concatConditionCQL(propConditon, propConditon.getItemIndex());
            }
            if (!StringUtil.isEmpty((Object)condition)) {
                cypherSQL.append(" and ").append(condition).append(" ");
            }
            String string = String.join((CharSequence)",", itemIndexList);
            cypherSQL.append(" return ").append(string).append(" limit 100");
            Result query = this.session.query(cypherSQL.toString(), new HashMap());
            ArrayList<NodeModel> nodes = new ArrayList<NodeModel>();
            ArrayList<RelationshipModel> relationships = new ArrayList<RelationshipModel>();
            for (Map map : (Iterable)query.queryResults()) {
                for (String key : map.keySet()) {
                    Object relationship;
                    if (key.contains("n")) {
                        Object node = map.get(key);
                        if (!(node instanceof NodeModel)) continue;
                        nodes.add((NodeModel)node);
                        continue;
                    }
                    if (!key.contains("r") || !((relationship = map.get(key)) instanceof RelationshipModel)) continue;
                    relationships.add((RelationshipModel)relationship);
                }
            }
            nodeList.addAll(Neo4jUtil.changeToNeo4jBasicNode(nodes));
            relationShipList.addAll(Neo4jUtil.changeToNeo4jQueryRelation(relationships));
        }
        resultObj.put("nodes", nodeList);
        resultObj.put("edges", relationShipList);
        return resultObj;
    }

    public JSONObject queryByNodeConditions(List<KSearchPlusDTO> queryNodes) {
        HashMap<String, Boolean> tempMap = new HashMap<String, Boolean>();
        JSONObject resultObj = new JSONObject();
        ArrayList<Neo4jBasicNode> nodeList = new ArrayList<Neo4jBasicNode>();
        ArrayList<Neo4jBasicRelationShip> relationShipList = new ArrayList<Neo4jBasicRelationShip>();
        int size = queryNodes.size();
        StringBuffer cypherSQL = new StringBuffer();
        if (size == 1) {
            KSearchPlusDTO dto = queryNodes.get(0);
            cypherSQL.append("match (n:`" + dto.getNodeType() + "`) ");
            cypherSQL.append(" WHERE 1 = 1 ");
            String condition = "";
            for (KSearchPlusPropDTO propConditon : dto.getPropConditions()) {
                KSearchPlusPropDTO propConditonTemp = new KSearchPlusPropDTO();
                BeanUtils.copyProperties((Object)propConditon, (Object)propConditonTemp);
                condition = this.concatConditionCQL(propConditonTemp, "n");
                cypherSQL.append(" and ").append(condition).append(" ");
            }
            cypherSQL.append(" return n ");
        } else {
            int combinations = MathUtil.combination(size, 2);
            int index = 0;
            for (KSearchPlusDTO dto : queryNodes) {
                for (KSearchPlusDTO dto2 : queryNodes) {
                    KSearchPlusPropDTO propConditonTemp;
                    if (dto.getNodeType().equals(dto2.getNodeType()) || tempMap.get(dto.getNodeType() + "-" + dto2.getNodeType()) != null || tempMap.get(dto2.getNodeType() + "-" + dto.getNodeType()) != null) continue;
                    tempMap.put(dto.getNodeType() + "-" + dto2.getNodeType(), true);
                    tempMap.put(dto2.getNodeType() + "-" + dto.getNodeType(), true);
                    cypherSQL.append("match (n1:`" + dto.getNodeType() + "`)-[r*1]-(n2:`" + dto2.getNodeType() + "`) ");
                    List propConditons1 = dto.getPropConditions();
                    List propConditons2 = dto2.getPropConditions();
                    cypherSQL.append(" WHERE 1 = 1 ");
                    String condition = "";
                    for (KSearchPlusPropDTO propConditon : propConditons1) {
                        propConditonTemp = new KSearchPlusPropDTO();
                        BeanUtils.copyProperties((Object)propConditon, (Object)propConditonTemp);
                        condition = this.concatConditionCQL(propConditonTemp, "n1");
                        cypherSQL.append(" and ").append(condition).append(" ");
                    }
                    for (KSearchPlusPropDTO propConditon2 : propConditons2) {
                        propConditonTemp = new KSearchPlusPropDTO();
                        BeanUtils.copyProperties((Object)propConditon2, (Object)propConditonTemp);
                        condition = this.concatConditionCQL(propConditonTemp, "n2");
                        cypherSQL.append(" and ").append(condition).append(" ");
                    }
                    cypherSQL.append(" return n1,r,n2 ");
                    if (++index >= combinations) continue;
                    cypherSQL.append(" UNION ");
                }
            }
        }
        Result query = this.session.query(cypherSQL.toString(), new HashMap());
        ArrayList<NodeModel> nodes = new ArrayList<NodeModel>();
        ArrayList<RelationshipModel> relationships = new ArrayList<RelationshipModel>();
        for (Map map : (Iterable)query.queryResults()) {
            for (String key : map.keySet()) {
                Object relationship;
                if (key.contains("n")) {
                    Object node = map.get(key);
                    if (!(node instanceof NodeModel)) continue;
                    nodes.add((NodeModel)node);
                    continue;
                }
                if (!key.contains("r") || !((relationship = map.get(key)) instanceof ArrayList)) continue;
                ArrayList relationshipModels = (ArrayList)relationship;
                for (Object model : relationshipModels) {
                    if (!(model instanceof RelationshipModel)) continue;
                    relationships.add((RelationshipModel)model);
                }
            }
        }
        nodeList.addAll(Neo4jUtil.changeToNeo4jBasicNode(nodes));
        relationShipList.addAll(Neo4jUtil.changeToNeo4jQueryRelation(relationships));
        resultObj.put("nodes", nodeList);
        resultObj.put("edges", relationShipList);
        return resultObj;
    }

    public JSONObject queryByConditionsPlus(KSearchPlusConditonDTO queryDto) {
        List queryNodes = queryDto.getNodes();
        Integer limit = queryDto.getLimit();
        if (limit == null) {
            limit = 500;
        }
        int size = queryNodes.size();
        StringBuffer queryCql = new StringBuffer();
        if (size == 1) {
            KSearchPlusDTO dto = (KSearchPlusDTO)queryNodes.get(0);
            queryCql.append("match (n:`" + dto.getNodeType() + "`) ");
            queryCql.append(" WHERE 1 = 1 ");
            String condition = "";
            for (KSearchPlusPropDTO propConditon : dto.getPropConditions()) {
                KSearchPlusPropDTO propConditonTemp = new KSearchPlusPropDTO();
                BeanUtils.copyProperties((Object)propConditon, (Object)propConditonTemp);
                condition = this.concatConditionCQL(propConditonTemp, "n");
                queryCql.append(" and ").append(condition).append(" ");
            }
            queryCql.append(" return n limit ").append(limit);
        } else {
            StringBuffer conditionCql = new StringBuffer(" WHERE 1 = 1 ");
            queryCql.append("match p=");
            int index = 1;
            for (KSearchPlusDTO dto : queryNodes) {
                String nIndex = "n" + index;
                if (index < queryNodes.size()) {
                    queryCql.append("(").append(nIndex).append(":`").append(dto.getNodeType()).append("`)-[]-");
                } else {
                    queryCql.append("(").append(nIndex).append(":`").append(dto.getNodeType()).append("`)");
                }
                if (dto.getPropConditions().size() > 0) {
                    String condition = "";
                    for (KSearchPlusPropDTO propConditon : dto.getPropConditions()) {
                        KSearchPlusPropDTO propConditonTemp = new KSearchPlusPropDTO();
                        BeanUtils.copyProperties((Object)propConditon, (Object)propConditonTemp);
                        condition = this.concatConditionCQL(propConditonTemp, nIndex);
                        conditionCql.append(" and ").append(condition).append(" ");
                    }
                }
                ++index;
            }
            queryCql = queryCql.append(conditionCql);
            queryCql.append(" return p limit ").append(limit);
        }
        return this.getResFromCql(queryCql.toString());
    }

    public List<LinkedHashMap<String, KSearchPlusDTO>> generateNodeLink(KSearchPlusConditonDTO dto) {
        List nodes = dto.getNodes();
        List relations = dto.getRelations();
        ArrayList<LinkedHashMap<String, KSearchPlusDTO>> links = new ArrayList<LinkedHashMap<String, KSearchPlusDTO>>();
        HashMap<String, Graph> tempMap = new HashMap<String, Graph>();
        ArrayList<Graph> graphs = new ArrayList<Graph>();
        int index = 1;
        for (KSearchPlusDTO node : nodes) {
            Graph g = new Graph("n" + index);
            ++index;
            g.setId(node.getId());
            g.setNode(node);
            tempMap.put(g.getId(), g);
            graphs.add(g);
        }
        for (KSearchPlusRelDTO rel : relations) {
            GraphUtil.setRelation((Graph)tempMap.get(rel.getSourceNode()), (Graph)tempMap.get(rel.getTargetNode()));
        }
        List<LinkedList<Graph>> graphLinks = GraphUtil.getLinks(graphs);
        for (LinkedList<Graph> graphLink : graphLinks) {
            LinkedHashMap<String, KSearchPlusDTO> linkMap = new LinkedHashMap<String, KSearchPlusDTO>();
            for (int i = 0; i < graphLink.size(); ++i) {
                Graph graph = graphLink.get(i);
                linkMap.put(graph.getName(), graph.getNode());
            }
            links.add(linkMap);
        }
        return links;
    }

    public JSONObject queryByCypher(KSearchPlusCypherDTO dto) {
        String cypher = dto.getCypher();
        String lowCaseCypher = dto.getCypher().toLowerCase();
        if (lowCaseCypher.contains("create") || lowCaseCypher.contains("merge")) {
            throw new HussarException("\u4e0d\u652f\u6301CREATE\u6216MERGE\u8bed\u53e5");
        }
        if (lowCaseCypher.contains("delete") || lowCaseCypher.contains("remove") || lowCaseCypher.contains("set")) {
            throw new HussarException("\u4e0d\u652f\u6301DELETE\u3001REMOVE\u6216SET\u8bed\u53e5");
        }
        if (lowCaseCypher.contains("algo") || lowCaseCypher.contains("apoc")) {
            throw new HussarException("\u6682\u4e0d\u652f\u6301ALGO\u6216APOC\u51fd\u6570\u6269\u5c55\u5305");
        }
        if (!lowCaseCypher.contains("limit")) {
            cypher = cypher + " limit 300 ";
        }
        return this.getResFromCql(cypher);
    }

    private String[] iterableToArr(Iterable<String> labels) {
        ArrayList strList = new ArrayList();
        labels.forEach(label -> strList.add(label));
        return strList.toArray(new String[strList.size()]);
    }

    private List setToArrayList(Set set) {
        ArrayList resList = new ArrayList();
        set.forEach(t -> resList.add(t));
        return resList;
    }

    public String concatConditionCQL(KSearchPlusPropDTO propConditon, String itemIndex) {
        KSearchPlusPropDTO newPropConditon = new KSearchPlusPropDTO();
        BeanUtils.copyProperties((Object)propConditon, (Object)newPropConditon);
        if (itemIndex != null) {
            newPropConditon.setItemIndex(itemIndex);
        }
        StringBuffer conditionCQL = new StringBuffer();
        switch (newPropConditon.getCondition()) {
            case "CONTAINS": 
            case "NOT CONTAINS": {
                if ("STRING".equals(newPropConditon.getPropType())) {
                    StringBuffer stringValue = new StringBuffer();
                    stringValue.append("'").append(newPropConditon.getPropValue()).append("'");
                    newPropConditon.setPropValue((Object)stringValue.toString());
                }
                if ("NOT CONTAINS".equals(newPropConditon.getCondition())) {
                    conditionCQL.append("not ");
                }
                if ("1".equals(newPropConditon.getIfMulti())) {
                    conditionCQL.append(newPropConditon.getPropValue()).append(" in ").append(newPropConditon.getItemIndex()).append(".").append(newPropConditon.getPropKey());
                    break;
                }
                conditionCQL.append(newPropConditon.getItemIndex()).append(".").append(newPropConditon.getPropKey()).append(" contains ").append(newPropConditon.getPropValue());
                break;
            }
            case "EQUALS": 
            case "NOT EQUALS": {
                if ("STRING".equals(newPropConditon.getPropType())) {
                    StringBuffer stringValue = new StringBuffer();
                    stringValue.append("'").append(newPropConditon.getPropValue()).append("'");
                    newPropConditon.setPropValue((Object)stringValue.toString());
                }
                if ("NOT EQUALS".equals(newPropConditon.getCondition())) {
                    conditionCQL.append("not ");
                }
                conditionCQL.append(newPropConditon.getItemIndex()).append(".").append(newPropConditon.getPropKey()).append(" = ").append(newPropConditon.getPropValue());
                break;
            }
            case "GT": 
            case "LT": {
                String operator;
                String string = operator = "GT".equals(newPropConditon.getCondition()) ? ">" : "<";
                if ("DATE".equals(newPropConditon.getPropType())) {
                    StringBuffer stringValue = new StringBuffer();
                    stringValue.append("'").append(newPropConditon.getPropValue()).append("'");
                    newPropConditon.setPropValue((Object)stringValue.toString());
                    operator = operator + "=";
                }
                conditionCQL.append(newPropConditon.getItemIndex()).append(".").append(newPropConditon.getPropKey()).append(" ").append(operator).append(" ").append(newPropConditon.getPropValue());
            }
        }
        return conditionCQL.toString();
    }

    private JSONObject getResFromCql(String queryCql) {
        Result query = this.session.query(queryCql, new HashMap());
        JSONObject resultObj = new JSONObject();
        ArrayList<Neo4jBasicNode> nodeList = new ArrayList<Neo4jBasicNode>();
        ArrayList<Neo4jBasicRelationShip> relationShipList = new ArrayList<Neo4jBasicRelationShip>();
        ArrayList jsonList = new ArrayList();
        HashSet<NodeModel> nodes = new HashSet<NodeModel>();
        HashSet<RelationshipModel> relationships = new HashSet<RelationshipModel>();
        HashMap jsonMap = new HashMap();
        for (Map map : (Iterable)query.queryResults()) {
            jsonMap = new HashMap();
            for (String key : map.keySet()) {
                Object obj = map.get(key);
                if (obj instanceof NodeModel) {
                    nodes.add((NodeModel)obj);
                    continue;
                }
                if (obj instanceof RelationshipModel) {
                    relationships.add((RelationshipModel)obj);
                    continue;
                }
                if (obj instanceof InternalPath.SelfContainedSegment[]) {
                    InternalPath.SelfContainedSegment[] ps = (InternalPath.SelfContainedSegment[])obj;
                    for (InternalPath.SelfContainedSegment segment : ps) {
                        Node startNode = segment.start();
                        Node endNode = segment.end();
                        Relationship relationship = segment.relationship();
                        NodeModel startNodeModel = new NodeModel(Long.valueOf(startNode.id()));
                        startNodeModel.setLabels(this.iterableToArr(startNode.labels()));
                        startNodeModel.setProperties(startNode.asMap());
                        NodeModel endNodeModel = new NodeModel(Long.valueOf(endNode.id()));
                        endNodeModel.setLabels(this.iterableToArr(endNode.labels()));
                        endNodeModel.setProperties(endNode.asMap());
                        RelationshipModel relationshipModel = new RelationshipModel();
                        relationshipModel.setId(Long.valueOf(relationship.id()));
                        relationshipModel.setType(relationship.type());
                        relationshipModel.setStartNode(Long.valueOf(startNode.id()));
                        relationshipModel.setEndNode(Long.valueOf(endNode.id()));
                        relationshipModel.setProperties(relationship.asMap());
                        nodes.add(startNodeModel);
                        nodes.add(endNodeModel);
                        relationships.add(relationshipModel);
                    }
                    continue;
                }
                if (obj instanceof ArrayList) {
                    ArrayList objs = (ArrayList)obj;
                    for (Object model : objs) {
                        if (model instanceof NodeModel) {
                            nodes.add((NodeModel)model);
                            continue;
                        }
                        if (!(model instanceof RelationshipModel)) continue;
                        relationships.add((RelationshipModel)model);
                    }
                    continue;
                }
                if (!(obj instanceof String) && !(obj instanceof Integer) && !(obj instanceof Double)) continue;
                jsonMap.put(key, obj);
            }
            if (jsonMap.isEmpty()) continue;
            jsonList.add(jsonMap);
        }
        nodeList.addAll(Neo4jUtil.changeToNeo4jBasicNode(this.setToArrayList(nodes)));
        relationShipList.addAll(Neo4jUtil.changeToNeo4jQueryRelation(this.setToArrayList(relationships)));
        resultObj.put("nodes", nodeList);
        resultObj.put("edges", relationShipList);
        resultObj.put("others", (Object)JSONArray.parseArray((String)JSON.toJSONString(jsonList)));
        return resultObj;
    }

    public JSONObject queryDataByGroup(String nodeNames) {
        String[] nodename = nodeNames.split(",");
        List<Map<String, Object>> resultList = this.graphQueryRepository.queryDataByGroup(nodename);
        JSONObject resultObj = new JSONObject();
        List<Object> nodeList = new ArrayList();
        List<Object> relationShipList = new ArrayList();
        ArrayList<NodeModel> nodes = new ArrayList<NodeModel>();
        ArrayList<RelationshipModel> relationships = new ArrayList<RelationshipModel>();
        for (Map<String, Object> map : resultList) {
            Object relationship;
            Object end;
            Object start = map.get("n");
            if (start instanceof NodeModel) {
                nodes.add((NodeModel)start);
            }
            if ((end = map.get("m")) instanceof NodeModel) {
                nodes.add((NodeModel)end);
            }
            if ((relationship = map.get("r")) instanceof ArrayList) {
                ArrayList relationshipModels = (ArrayList)relationship;
                for (Object model : relationshipModels) {
                    if (!(model instanceof RelationshipModel)) continue;
                    relationships.add((RelationshipModel)model);
                }
                continue;
            }
            if (!(relationship instanceof RelationshipModel)) continue;
            relationships.add((RelationshipModel)relationship);
        }
        nodeList = Neo4jUtil.changeToNeo4jBasicNode(nodes);
        relationShipList = Neo4jUtil.changeToNeo4jQueryRelation(relationships);
        resultObj.put("nodes", nodeList);
        resultObj.put("edges", relationShipList);
        return resultObj;
    }
}

