/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.kgbase.application.instancemanage.service.impl;

import cn.hutool.core.util.IdUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.core.exception.HussarException;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.kgbase.application.globalconfig.model.GlobalConfig;
import com.jxdinfo.hussar.kgbase.application.globalconfig.service.IGlobalConfigService;
import com.jxdinfo.hussar.kgbase.application.instancemanage.dao.InstanceExportDao;
import com.jxdinfo.hussar.kgbase.application.instancemanage.model.dto.InstanceNodeDTO;
import com.jxdinfo.hussar.kgbase.application.instancemanage.model.dto.InstancePropertyDTO;
import com.jxdinfo.hussar.kgbase.application.instancemanage.model.dto.InstanceRelationDTO;
import com.jxdinfo.hussar.kgbase.application.instancemanage.model.po.InstanceExport;
import com.jxdinfo.hussar.kgbase.application.instancemanage.model.vo.InstanceNodeVO;
import com.jxdinfo.hussar.kgbase.application.instancemanage.model.vo.InstancePropertyVO;
import com.jxdinfo.hussar.kgbase.application.instancemanage.model.vo.InstanceRelationVO;
import com.jxdinfo.hussar.kgbase.application.instancemanage.service.InstanceManageService;
import com.jxdinfo.hussar.kgbase.application.nodeconfig.model.NodeConfig;
import com.jxdinfo.hussar.kgbase.application.nodeconfig.service.INodeConfigService;
import com.jxdinfo.hussar.kgbase.build.model.po.Concept;
import com.jxdinfo.hussar.kgbase.build.model.po.Groups;
import com.jxdinfo.hussar.kgbase.build.model.po.Node;
import com.jxdinfo.hussar.kgbase.build.model.vo.ConceptVO;
import com.jxdinfo.hussar.kgbase.build.model.vo.GroupVO;
import com.jxdinfo.hussar.kgbase.build.service.IConceptService;
import com.jxdinfo.hussar.kgbase.build.service.IGroupService;
import com.jxdinfo.hussar.kgbase.build.service.INodeService;
import com.jxdinfo.hussar.kgbase.common.constant.KgConstants;
import com.jxdinfo.hussar.kgbase.common.model.ExcelDataTuPu;
import com.jxdinfo.hussar.kgbase.common.util.DateUtil;
import com.jxdinfo.hussar.kgbase.common.util.ExcelUtil;
import com.jxdinfo.hussar.kgbase.common.util.PropUtil;
import com.jxdinfo.hussar.kgbase.neo4j.model.Neo4jBasicNode;
import com.jxdinfo.hussar.kgbase.neo4j.repository.BluePrintRepository;
import com.jxdinfo.hussar.kgbase.neo4j.repository.InstanceManageRepository;
import com.jxdinfo.hussar.kgbase.neo4j.util.Neo4jUtil;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.neo4j.ogm.model.Property;
import org.neo4j.ogm.model.Result;
import org.neo4j.ogm.response.model.NodeModel;
import org.neo4j.ogm.response.model.RelationshipModel;
import org.neo4j.ogm.session.Session;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

@Service
public class InstanceManageServiceImpl
implements InstanceManageService {
    @Value(value="${node-config.enableOntologyConfig}")
    private boolean enableOntologyConfig;
    @Resource
    private InstanceManageRepository instanceRepository;
    @Resource
    private IGroupService iGroupService;
    @Resource
    private IConceptService iConceptService;
    @Resource
    private INodeService iNodeService;
    @Resource
    private IGlobalConfigService globalConfigService;
    @Resource
    INodeConfigService inodeConfigService;
    @Resource
    BluePrintRepository bluePrintRepository;
    @Resource
    private Session session;
    @Resource
    private InstanceExportDao ieDao;

    public Page<Neo4jBasicNode> nodeList(InstanceNodeDTO dto) {
        Integer count;
        Page page = new Page();
        List<Object> dataList = new ArrayList();
        if (dto.getCurrent() == null) {
            dto.setCurrent(Integer.valueOf(1));
        }
        if (dto.getSize() == null) {
            dto.setSize(Integer.valueOf(10));
        }
        if (dto.getName() == null) {
            dto.setName("");
        }
        page.setCurrent((long)dto.getCurrent().intValue());
        page.setSize((long)dto.getSize().intValue());
        Integer pageIndex = (dto.getCurrent() - 1) * dto.getSize();
        dto.setCurrent(pageIndex);
        if (StringUtil.isNotBlank((CharSequence)dto.getNodeType())) {
            String[] array = null;
            if (StringUtil.equals((CharSequence)"group", (CharSequence)dto.getConceptOrGroup())) {
                QueryWrapper qw = new QueryWrapper();
                qw.eq((Object)"GROUP_NAME", (Object)dto.getNodeType());
                Groups groups = (Groups)this.iGroupService.getOne((Wrapper)qw);
                String string = this.iConceptService.getGroupIds(groups.getId());
                List conceptIds = this.iConceptService.getConceptByGroupId(string);
                array = conceptIds.toArray(new String[conceptIds.size()]);
            } else {
                array = new String[]{dto.getNodeType()};
            }
            dto.setNodeTypes(array);
            count = this.instanceRepository.getNodeCountByNodeType(dto);
            dataList = this.instanceRepository.getNodeListByNodeType(dto);
        } else {
            count = this.instanceRepository.getNodeCount(dto);
            dataList = this.instanceRepository.getNodeList(dto);
        }
        ArrayList<NodeModel> nodeModels = new ArrayList<NodeModel>();
        List<String> nodeDefaultProp = Arrays.asList(KgConstants.getDefaultNodeProps());
        for (HashMap hashMap : dataList) {
            NodeModel nodeModel = (NodeModel)hashMap.get("n");
            List propList = nodeModel.getPropertyList();
            for (int i = 0; i < propList.size(); ++i) {
                if (!nodeDefaultProp.contains(((Property)propList.get(i)).getKey()) || "name".equals(((Property)propList.get(i)).getKey())) continue;
                propList.remove(i);
                --i;
            }
            nodeModels.add(nodeModel);
        }
        List<Neo4jBasicNode> nodeList = Neo4jUtil.changeToNeo4jBasicNode(nodeModels);
        page.setTotal((long)count.intValue());
        page.setRecords(nodeList);
        return page;
    }

    public Page<InstanceRelationVO> relationList(InstanceRelationDTO dto) {
        Page page = new Page();
        Integer count = 0;
        if (dto.getCurrent() == null) {
            dto.setCurrent(Integer.valueOf(1));
        }
        if (dto.getSize() == null) {
            dto.setSize(Integer.valueOf(10));
        }
        page.setCurrent((long)dto.getCurrent().intValue());
        page.setSize((long)dto.getSize().intValue());
        Integer pageIndex = (dto.getCurrent() - 1) * dto.getSize();
        dto.setCurrent(pageIndex);
        StringBuffer cypher = new StringBuffer();
        cypher.append("MATCH (n)-[r]->(m) WHERE 1 = 1 ");
        if (StringUtil.isNotBlank((CharSequence)dto.getNodeType())) {
            cypher.append(" AND (labels(n)[0] =~('.*").append(dto.getNodeType()).append(".*') or labels(m)[0] =~('.*").append(dto.getNodeType()).append(".*')) ");
        }
        if (StringUtil.isNotBlank((CharSequence)dto.getName())) {
            cypher.append(" AND type(r)=~('.*").append(dto.getName()).append(".*') ");
        }
        if (StringUtil.isNotBlank((CharSequence)dto.getNodeName())) {
            cypher.append(" AND ( n.name=~('.*").append(dto.getNodeName()).append(".*') or m.name=~('.*").append(dto.getNodeName()).append(".*')) ");
        }
        StringBuffer countCQL = new StringBuffer(cypher.toString()).append(" RETURN count(*) AS COUNT");
        Iterable countIterable = (Iterable)this.session.query(countCQL.toString(), new HashMap()).queryResults();
        for (Map map : countIterable) {
            if (map.get("COUNT") == null) continue;
            count = Integer.parseInt(String.valueOf(map.get("COUNT")));
            break;
        }
        cypher.append("RETURN r ORDER BY r.createTime,id(r) DESC skip ").append(dto.getCurrent()).append(" limit ").append(dto.getSize());
        Iterable dataList = (Iterable)this.session.query(cypher.toString(), new HashMap()).queryResults();
        ArrayList<InstanceRelationVO> relationList = new ArrayList<InstanceRelationVO>();
        for (Map map : dataList) {
            RelationshipModel relationshipModel = (RelationshipModel)map.get("r");
            relationList.add(this.getRelationInfo(relationshipModel.getId().toString()));
        }
        page.setTotal((long)count.intValue());
        page.setRecords(relationList);
        return page;
    }

    @Transactional(value="multiTransactionManager")
    public Iterable<Map<String, Object>> addNode(InstanceNodeDTO dto) {
        if (StringUtil.isEmpty((Object)dto.getNodeType()) || StringUtil.isEmpty((Object)dto.getName())) {
            throw new HussarException("\u8282\u70b9\u4fe1\u606f\u4e0d\u5b8c\u6574\uff01");
        }
        StringBuffer cypherSQL = new StringBuffer("MERGE(n:");
        cypherSQL.append(dto.getNodeType());
        cypherSQL.append("{name:'").append(dto.getName()).append("',");
        String date = DateUtil.getTodayToSecond();
        cypherSQL.append("createTime").append(":'").append(date).append("'");
        for (InstancePropertyDTO prop : dto.getPropList()) {
            cypherSQL.append(",").append(prop.getPropKey()).append(":").append(PropUtil.arrToString(prop));
        }
        cypherSQL.append("}) return id(n) as id");
        Result query = this.session.query(cypherSQL.toString(), new HashMap());
        return (Iterable)query.queryResults();
    }

    @Transactional(value="multiTransactionManager")
    public Iterable<Map<String, Object>> editNode(InstanceNodeDTO dto) {
        String[] defaultNodeProps = KgConstants.getDefaultNodeProps();
        this.instanceRepository.deleteNodePropsExceptDefault(dto.getId(), defaultNodeProps);
        StringBuffer cypherSQL = new StringBuffer("MATCH(n) where id(n) = ");
        cypherSQL.append(dto.getId());
        cypherSQL.append(" SET");
        if (dto.getPropList().size() == 0 && StringUtil.isBlank((CharSequence)dto.getName())) {
            throw new HussarException("\u65e0\u9700\u4fee\u6539\uff01");
        }
        int index = 0;
        for (InstancePropertyDTO prop : dto.getPropList()) {
            cypherSQL.append(" n.").append(prop.getPropKey()).append(" = ").append(PropUtil.arrToString(prop));
            if (++index >= dto.getPropList().size()) continue;
            cypherSQL.append(",");
        }
        if (StringUtil.isNotBlank((CharSequence)dto.getName())) {
            if (dto.getPropList().size() > 0) {
                cypherSQL.append(" ,");
            }
            cypherSQL.append(" n.").append("name").append(" = '").append(dto.getName()).append("'");
        }
        if (dto.getPropList().size() > 0 && StringUtil.isNotBlank((CharSequence)dto.getName())) {
            cypherSQL.append(" ,");
            String date = DateUtil.getTodayToSecond();
            cypherSQL.append(" n.").append("updateTime").append(" = '").append(date).append("'");
        }
        Result query = this.session.query(cypherSQL.toString(), new HashMap());
        return query;
    }

    @Transactional(value="multiTransactionManager")
    public boolean deleteNodes(String ids) {
        try {
            String[] idArr = ids.split(",");
            int[] idIntArr = new int[idArr.length];
            for (int i = 0; i < idArr.length; ++i) {
                idIntArr[i] = Integer.parseInt(idArr[i]);
            }
            this.instanceRepository.deleteRelationByNodes(idIntArr);
            this.instanceRepository.deleteNodes(idIntArr);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public InstanceNodeVO getNodeInfo(String id) {
        InstanceNodeVO nodeVO = new InstanceNodeVO();
        List<HashMap<String, Object>> propMapList = this.instanceRepository.getNodeProps(Integer.parseInt(id));
        List<HashMap<String, Object>> nodeMap = this.instanceRepository.getNodeById(Integer.parseInt(id));
        if (nodeMap.size() == 0) {
            return nodeVO;
        }
        NodeModel nodeModel = (NodeModel)nodeMap.get(0).get("n");
        nodeVO.setId(nodeModel.getId().toString());
        nodeVO.setNodeType(nodeModel.getLabels()[0]);
        nodeVO.setPropList(PropUtil.generatePropList(propMapList));
        nodeVO.setNodeColor(this.getConceptStyle(nodeModel.getLabels()[0]));
        nodeVO.setName(this.instanceRepository.getNodeNameById(Integer.parseInt(id)));
        return nodeVO;
    }

    @Transactional(value="multiTransactionManager")
    public Iterable<Map<String, Object>> addRelation(InstanceRelationDTO dto) {
        Integer sourceNodeId = dto.getSourceNode().getId();
        Integer targetNodeId = dto.getTargetNode().getId();
        StringBuffer cypherSQL = new StringBuffer();
        cypherSQL.append("MATCH (a),(b) WHERE id(a) = ").append(sourceNodeId).append(" AND id(b) = ").append(targetNodeId);
        cypherSQL.append(" CREATE (a)-[r: ").append(dto.getName()).append("{");
        String date = DateUtil.getTodayToSecond();
        cypherSQL.append("createTime").append(":'").append(date).append("' ");
        for (InstancePropertyDTO prop : dto.getPropList()) {
            cypherSQL.append(",");
            cypherSQL.append(prop.getPropKey()).append(": ").append(PropUtil.arrToString(prop));
        }
        cypherSQL.append("}]->(b) return id(r) as id_edge");
        Result query = this.session.query(cypherSQL.toString(), new HashMap());
        return (Iterable)query.queryResults();
    }

    @Transactional(value="multiTransactionManager")
    public ApiResponse editRelation(InstanceRelationDTO dto) {
        String[] defaultRelationProps = KgConstants.getDefaultRelationProps();
        int id = Integer.parseInt(dto.getId());
        this.instanceRepository.deleteRelationPropsExceptDefault(id, defaultRelationProps);
        StringBuffer cypherSQL = new StringBuffer();
        cypherSQL.append("MATCH (n)-[r]-(m) where id(r) = ").append(id);
        cypherSQL.append(" SET ");
        if (dto.getPropList().size() == 0) {
            return ApiResponse.success();
        }
        int index = 0;
        for (InstancePropertyDTO prop : dto.getPropList()) {
            cypherSQL.append(" r.").append(prop.getPropKey()).append(" = ").append(PropUtil.arrToString(prop));
            if (++index >= dto.getPropList().size()) continue;
            cypherSQL.append(",");
        }
        String date = DateUtil.getTodayToSecond();
        if (dto.getPropList().size() > 0) {
            cypherSQL.append(" ,");
        }
        cypherSQL.append(" r.").append("updateTime").append(" = '").append(date).append("'");
        Result query = this.session.query(cypherSQL.toString(), new HashMap());
        return ApiResponse.success((Object)query);
    }

    @Transactional(value="multiTransactionManager")
    public boolean deleteRelations(String ids) {
        try {
            String[] idArr = ids.split(",");
            int[] idIntArr = new int[idArr.length];
            for (int i = 0; i < idArr.length; ++i) {
                idIntArr[i] = Integer.parseInt(idArr[i]);
            }
            this.instanceRepository.deleteRelations(idIntArr);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public InstanceRelationVO getRelationInfo(String id) {
        InstanceRelationVO relationVO = new InstanceRelationVO();
        List<HashMap<String, Object>> relationMap = this.instanceRepository.getRelationById(Integer.parseInt(id));
        if (relationMap.size() == 0) {
            return relationVO;
        }
        RelationshipModel relationMo = (RelationshipModel)relationMap.get(0).get("r");
        relationVO.setId(relationMo.getId().toString());
        relationVO.setSourceNode(this.getNodeInfo(String.valueOf(relationMo.getStartNode())));
        relationVO.setTargetNode(this.getNodeInfo(String.valueOf(relationMo.getEndNode())));
        List<InstancePropertyVO> propList = PropUtil.generatePropList(this.instanceRepository.getRelationProps(Integer.parseInt(id)));
        relationVO.setPropList(propList);
        relationVO.setName(this.instanceRepository.getRelationNameById(Integer.parseInt(id)));
        return relationVO;
    }

    public List<GroupVO> getTree() {
        List treeList = this.iGroupService.getTree();
        List concepts = this.iConceptService.list();
        ArrayList<String> conceptNames = new ArrayList<String>();
        for (Concept concept : concepts) {
            conceptNames.add(concept.getConceptName());
        }
        String[] nodeTypeArr = new String[conceptNames.size()];
        nodeTypeArr = conceptNames.toArray(nodeTypeArr);
        List<HashMap<String, Object>> nodeTypeMaps = this.instanceRepository.getNodeTypesInNeo4j(nodeTypeArr);
        ArrayList<ConceptVO> conceptInNeo4j = new ArrayList<ConceptVO>();
        for (HashMap<String, Object> nodeTypeMap : nodeTypeMaps) {
            if (nodeTypeMap.get("nodeType") == null) continue;
            String nodeType = String.valueOf(nodeTypeMap.get("nodeType"));
            ConceptVO conceptVO = new ConceptVO();
            conceptVO.setConceptOrGroup("concept");
            conceptVO.setConceptName(nodeType);
            conceptVO.setLevel(Integer.valueOf(2));
            conceptVO.setId(IdUtil.fastSimpleUUID());
            conceptVO.setParentId("0");
            conceptInNeo4j.add(conceptVO);
        }
        if (treeList.get(0) != null) {
            List children = ((GroupVO)treeList.get(0)).getChildren();
            children.addAll(conceptInNeo4j);
            ((GroupVO)treeList.get(0)).setChildren(children);
        }
        return treeList;
    }

    public void exportNodeList(String nodeType, String way, HttpServletRequest request, HttpServletResponse response) {
        if (StringUtil.isEmpty((Object)nodeType)) {
            throw new HussarException("\u8bf7\u5148\u9009\u62e9\u5b9e\u4f53\u7c7b\u578b");
        }
        QueryWrapper conceptQueryWrapper = new QueryWrapper();
        conceptQueryWrapper.eq((Object)"CONCEPT_NAME", (Object)nodeType);
        conceptQueryWrapper.eq((Object)"DEL_FLAG", (Object)"0");
        Concept concept = (Concept)this.iConceptService.getOne((Wrapper)conceptQueryWrapper);
        LinkedHashMap<String, com.jxdinfo.hussar.kgbase.build.model.po.Property> propMap = new LinkedHashMap<String, com.jxdinfo.hussar.kgbase.build.model.po.Property>();
        if (concept != null) {
            List properties = this.iConceptService.getDetailsById(concept.getId()).getPropertyList();
            propMap.put("name", null);
            for (com.jxdinfo.hussar.kgbase.build.model.po.Property prop : properties) {
                propMap.put(prop.getPropName(), prop);
            }
        }
        List<Map<String, Object>> n4jProps = this.bluePrintRepository.getPropsByNodeType(nodeType);
        for (Map<String, Object> map : n4jProps) {
            String prop = String.valueOf(map.get("prop"));
            if (propMap.keySet().contains(prop)) continue;
            propMap.put(prop, null);
        }
        ExcelDataTuPu data = new ExcelDataTuPu();
        data.setFileName(nodeType + "_\u5b9e\u4f8b\u6570\u636e_" + new Date().getTime());
        String[] head = new String[propMap.size()];
        int index = 0;
        Iterator iterator = propMap.keySet().iterator();
        while (iterator.hasNext()) {
            String key;
            head[index] = key = (String)iterator.next();
            ++index;
        }
        data.setHead(head);
        ArrayList<String[]> datas = new ArrayList<String[]>();
        List<Object> dataList = new ArrayList();
        if (StringUtil.equals((CharSequence)"0", (CharSequence)way)) {
            dataList = this.instanceRepository.getNodeListByNodeType(nodeType);
        } else {
            Object lastTime = this.ieDao.getLastTime(nodeType, way);
            if (StringUtil.isEmpty((Object)lastTime)) {
                lastTime = "1990-01-01 00:00:01";
            }
            dataList = this.instanceRepository.getNodeListByNodeTypeAndTime(nodeType, (String)lastTime);
        }
        for (HashMap hashMap : dataList) {
            NodeModel nodeModel = (NodeModel)hashMap.get("n");
            List propList = nodeModel.getPropertyList();
            HashMap<Object, Object> instPropMap = new HashMap<Object, Object>();
            for (int i = 0; i < propList.size(); ++i) {
                instPropMap.put(((Property)propList.get(i)).getKey(), ((Property)propList.get(i)).getValue());
            }
            String[] propArr = new String[head.length];
            for (int j = 0; j < propArr.length; ++j) {
                Object o = instPropMap.get(head[j]);
                if (o != null) {
                    if (o instanceof Date) {
                        propArr[j] = DateUtil.format((Date)o, "yyyy-MM-dd HH:mm:ss");
                        continue;
                    }
                    if (o instanceof Collection) {
                        Object[] oArr = Collections.unmodifiableCollection((Collection)o).toArray();
                        propArr[j] = StringUtil.join((Object[])oArr, (String)",");
                        continue;
                    }
                    propArr[j] = String.valueOf(o);
                    continue;
                }
                propArr[j] = "";
            }
            datas.add(propArr);
        }
        data.setData(datas);
        ExcelUtil.exportExcelSeven(response, data);
        InstanceExport instanceExport = new InstanceExport();
        instanceExport.setCreateDate(LocalDateTime.now());
        instanceExport.setNodeType(nodeType);
        instanceExport.setEcportType(way);
        this.ieDao.insert(instanceExport);
    }

    String getConceptStyle(String nodeType) {
        NodeConfig nodeConfig;
        if (this.enableOntologyConfig) {
            QueryWrapper conceptQueryWrapper = new QueryWrapper();
            conceptQueryWrapper.eq((Object)"CONCEPT_NAME", (Object)nodeType);
            conceptQueryWrapper.eq((Object)"DEL_FLAG", (Object)"0");
            Concept concept = (Concept)this.iConceptService.getOne((Wrapper)conceptQueryWrapper);
            if (concept != null) {
                QueryWrapper nodeQueryWrapper = new QueryWrapper();
                nodeQueryWrapper.eq((Object)"CONCEPT_ID", (Object)concept.getId());
                nodeQueryWrapper.eq((Object)"DEL_FLAG", (Object)"0");
                return ((Node)this.iNodeService.getOne((Wrapper)nodeQueryWrapper)).getNodeColor();
            }
            return "";
        }
        GlobalConfig globalConfig = this.globalConfigService.getCurrentConfig();
        QueryWrapper ew = new QueryWrapper();
        String version = globalConfig.getVersion();
        if (ToolUtil.isNotEmpty((Object)version)) {
            ew.eq((Object)"VERSION", (Object)version);
            ew.eq((Object)"LABEL", (Object)nodeType);
        }
        if ((nodeConfig = (NodeConfig)this.inodeConfigService.getOne((Wrapper)ew)) == null) {
            return "";
        }
        return nodeConfig.getFill();
    }

    public boolean importNodeList(MultipartFile file) {
        boolean res = true;
        List<Map<String, String>> list = ExcelUtil.readExcel(file);
        String fileName = file.getOriginalFilename();
        String nodeType = fileName.split("_").length > 0 ? fileName.split("_")[0] : "";
        String date = DateUtil.format(new Date(), "yyyy-MM-dd HH:mm:ss");
        for (Map<String, String> map : list) {
            String queryCQL;
            Long nodeId = null;
            if (map.containsKey("name") && map.containsKey("businessId")) {
                queryCQL = "match(n:" + nodeType + "{businessId:'" + map.get("businessId") + "',name:'" + map.get("name") + "'}) return n;";
                Result dataQuery = this.session.query(queryCQL, new HashMap());
                Iterable dataMap = (Iterable)dataQuery.queryResults();
                for (Map tem : dataMap) {
                    NodeModel model = (NodeModel)tem.get("n");
                    nodeId = model.getId();
                }
            }
            if (map.containsKey("createTime")) {
                map.put("createTime", date);
            }
            queryCQL = "";
            if (nodeId == null) {
                queryCQL = "merge(n:" + nodeType + "{";
                for (Map.Entry<String, String> entry : map.entrySet()) {
                    if (StringUtil.isEmpty((Object)entry.getKey()) || StringUtil.isEmpty((Object)entry.getValue())) continue;
                    queryCQL = queryCQL + entry.getKey() + ":'" + entry.getValue() + "',";
                }
                queryCQL = queryCQL.substring(0, queryCQL.length() - 1);
                queryCQL = queryCQL + "}) return n";
            } else {
                map.put("updateTime", date);
                queryCQL = "match(n:" + nodeType + ") where ID(n)= " + nodeId + " set ";
                for (Map.Entry<String, String> entry : map.entrySet()) {
                    if (StringUtil.isEmpty((Object)entry.getKey()) || StringUtil.isEmpty((Object)entry.getValue())) continue;
                    queryCQL = queryCQL + " n." + entry.getKey() + "='" + entry.getValue() + "',";
                }
                queryCQL = queryCQL.substring(0, queryCQL.length() - 1);
                queryCQL = queryCQL + " return n";
            }
            Result result = this.session.query(queryCQL, new HashMap());
        }
        return res;
    }
}

