/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.kgbase.application.globalconfig.controller;

import com.jxdinfo.hussar.core.base.controller.BaseController;
import com.jxdinfo.hussar.kgbase.application.globalconfig.model.GlobalConfig;
import com.jxdinfo.hussar.kgbase.application.globalconfig.service.IGlobalConfigService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.support.audit.core.annotations.AuditLog;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventGrade;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventType;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/globalConfig"})
public class GlobalConfigController
extends BaseController {
    @Resource
    private IGlobalConfigService globalConfigService;

    @AuditLog(moduleName="\u5168\u5c40\u914d\u7f6e", eventDesc="\u83b7\u53d6\u5168\u5c40\u914d\u7f6e\u5217\u8868", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.QUERY)
    @RequestMapping(value={"/list"})
    @ResponseBody
    public ApiResponse list(String name) {
        List configList = this.globalConfigService.getConfigList(name);
        return ApiResponse.success((Object)configList);
    }

    @AuditLog(moduleName="\u5168\u5c40\u914d\u7f6e", eventDesc="\u4fdd\u5b58\u5168\u5c40\u914d\u7f6e", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.INSERT)
    @RequestMapping(value={"/save"})
    @ResponseBody
    public ApiResponse save(@RequestBody GlobalConfig globalConfig) {
        Map result = this.globalConfigService.saveConfig(globalConfig);
        boolean flag = (Boolean)result.get("success");
        if (flag) {
            return ApiResponse.success();
        }
        return ApiResponse.fail((String)result.get("msg").toString());
    }

    @AuditLog(moduleName="\u5168\u5c40\u914d\u7f6e", eventDesc="\u83b7\u53d6\u6b63\u5728\u542f\u7528\u7684\u914d\u7f6e", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.QUERY)
    @RequestMapping(value={"/getCurrentConfig"})
    @ResponseBody
    public ApiResponse getCurrentConfig() {
        GlobalConfig globalConfig = this.globalConfigService.getCurrentConfig();
        return ApiResponse.success((Object)globalConfig);
    }

    @AuditLog(moduleName="\u5168\u5c40\u914d\u7f6e", eventDesc="\u542f\u7528\u5168\u5c40\u914d\u7f6e", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    @RequestMapping(value={"/enable"})
    @ResponseBody
    public ApiResponse enable(@RequestParam Long id) {
        boolean flag = this.globalConfigService.enableConfig(id);
        if (flag) {
            return ApiResponse.success();
        }
        return ApiResponse.fail((String)"\u542f\u7528\u5931\u8d25");
    }

    @AuditLog(moduleName="\u5168\u5c40\u914d\u7f6e", eventDesc="\u5220\u9664\u5168\u5c40\u914d\u7f6e", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.DELETE)
    @RequestMapping(value={"/delete"})
    @ResponseBody
    public ApiResponse delete(@RequestParam Long id) {
        Map result = this.globalConfigService.deleteConfig(id);
        boolean flag = (Boolean)result.get("success");
        if (flag) {
            return ApiResponse.success();
        }
        return ApiResponse.fail((String)result.get("msg").toString());
    }
}

