/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.kgbase.algomodel.util;

import java.io.IOException;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.websocket.OnClose;
import javax.websocket.OnError;
import javax.websocket.OnMessage;
import javax.websocket.OnOpen;
import javax.websocket.Session;
import javax.websocket.server.ServerEndpoint;
import org.springframework.stereotype.Component;

@ServerEndpoint(value="/nerWebSocket")
@Component
public class NerWebSocket {
    private static final CopyOnWriteArraySet<NerWebSocket> NER_WEB_SOCKET_SET = new CopyOnWriteArraySet();
    private Session session;

    public static Set<NerWebSocket> getNerWebSocketSet() {
        return NER_WEB_SOCKET_SET;
    }

    @OnOpen
    public void onOpen(Session session) throws IOException {
        this.session = session;
        NER_WEB_SOCKET_SET.add(this);
        System.out.print("\u547d\u540d\u5b9e\u4f53\u8bc6\u522b\u6a21\u578b\u8bad\u7ec3\u65e5\u5fd7--\u7cfb\u7edf\u8fde\u63a5\u6210\u529f");
    }

    @OnClose
    public void onClose() {
        NER_WEB_SOCKET_SET.remove(this);
    }

    @OnMessage
    public void onMessage(String message) {
        for (NerWebSocket item : NER_WEB_SOCKET_SET) {
            try {
                item.sendMessage(message);
            }
            catch (IOException e) {
                System.out.print("\u6d88\u606f\u53d1\u9001\u5931\u8d25");
            }
        }
    }

    @OnError
    public void onError(Session session, Throwable error) {
        System.out.print("\u65ad\u5f00\u8fde\u63a5");
    }

    public void sendMessage(String message) throws IOException {
        for (NerWebSocket item : NER_WEB_SOCKET_SET) {
            if (!item.session.isOpen()) continue;
            item.session.getBasicRemote().sendText(message);
        }
    }
}

