/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.kgbase.neo4j.util;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.kgbase.neo4j.model.Neo4jBasicNode;
import com.jxdinfo.hussar.kgbase.neo4j.model.Neo4jBasicRelationShip;
import com.jxdinfo.hussar.kgbase.neo4j.vo.Neo4jBasicNodeVO;
import com.jxdinfo.hussar.kgbase.neo4j.vo.Neo4jBasicSegmentsVO;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.neo4j.driver.internal.InternalPath;
import org.neo4j.driver.types.Node;
import org.neo4j.driver.types.Relationship;
import org.neo4j.ogm.model.Property;
import org.neo4j.ogm.model.Result;
import org.neo4j.ogm.response.model.NodeModel;
import org.neo4j.ogm.response.model.RelationshipModel;

public class Neo4jUtil {
    public static List<Neo4jBasicNode> changeToNeo4jBasicNode(List<NodeModel> nodeModels) {
        ArrayList<String> nodeIdList = new ArrayList<String>();
        ArrayList<Neo4jBasicNode> nodes = new ArrayList<Neo4jBasicNode>();
        for (NodeModel nodeModel : nodeModels) {
            String[] labels;
            Neo4jBasicNode neo4jBasicNode = new Neo4jBasicNode();
            String nodeId = String.valueOf(nodeModel.getId());
            neo4jBasicNode.setId(nodeId);
            String type = "";
            String[] stringArray = labels = nodeModel.getLabels();
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String label;
                type = label = stringArray[i];
            }
            neo4jBasicNode.setNodeType(type);
            String name = "";
            ArrayList propertyList = new ArrayList();
            List properties = nodeModel.getPropertyList();
            for (Property property : properties) {
                HashMap<String, String> tmp = new HashMap<String, String>();
                String key = (String)property.getKey();
                String value = property.getValue().toString();
                tmp.put(key, value);
                propertyList.add(tmp);
                if (!"name".equals(key)) continue;
                name = value;
            }
            neo4jBasicNode.setLabel(name);
            neo4jBasicNode.setProperties(propertyList);
            if (nodeIdList.contains(nodeId)) continue;
            nodeIdList.add(nodeId);
            nodes.add(neo4jBasicNode);
        }
        return nodes;
    }

    public static List<Neo4jBasicNodeVO> changeToNeo4jBasicNodeVO(List<NodeModel> nodeModels) {
        ArrayList<String> nodeIdList = new ArrayList<String>();
        ArrayList<Neo4jBasicNodeVO> nodes = new ArrayList<Neo4jBasicNodeVO>();
        for (NodeModel nodeModel : nodeModels) {
            String[] labels;
            Neo4jBasicNodeVO neo4jBasicNode = new Neo4jBasicNodeVO();
            String nodeId = String.valueOf(nodeModel.getId());
            neo4jBasicNode.setId(nodeId);
            String type = "";
            String[] stringArray = labels = nodeModel.getLabels();
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String label;
                type = label = stringArray[i];
            }
            neo4jBasicNode.setNodeType(type);
            String name = "";
            ArrayList propertyList = new ArrayList();
            List properties = nodeModel.getPropertyList();
            for (Property property : properties) {
                HashMap<String, String> tmp = new HashMap<String, String>();
                String key = (String)property.getKey();
                String value = property.getValue().toString();
                tmp.put(key, value);
                propertyList.add(tmp);
                if (!"name".equals(key)) continue;
                name = value;
            }
            neo4jBasicNode.setLabel(name);
            neo4jBasicNode.setProperties(propertyList);
            if (nodeIdList.contains(nodeId)) continue;
            nodeIdList.add(nodeId);
            nodes.add(neo4jBasicNode);
        }
        return nodes;
    }

    public static List<Neo4jBasicRelationShip> changeToNeo4jQueryRelation(List<RelationshipModel> relationshipModels) {
        ArrayList<Neo4jBasicRelationShip> relationships = new ArrayList<Neo4jBasicRelationShip>();
        for (RelationshipModel relationshipModel : relationshipModels) {
            Neo4jBasicRelationShip neo4JBasicRelationShip = new Neo4jBasicRelationShip();
            neo4JBasicRelationShip.setId(String.valueOf(relationshipModel.getId()) + "_edge");
            neo4JBasicRelationShip.setSource(String.valueOf(relationshipModel.getStartNode()));
            neo4JBasicRelationShip.setTarget(String.valueOf(relationshipModel.getEndNode()));
            neo4JBasicRelationShip.setLabel(relationshipModel.getType());
            ArrayList propertyList = new ArrayList();
            List properties = relationshipModel.getPropertyList();
            for (Property property : properties) {
                HashMap<Object, String> tmp = new HashMap<Object, String>();
                tmp.put(property.getKey(), property.getValue().toString());
                propertyList.add(tmp);
            }
            neo4JBasicRelationShip.setProperties(propertyList);
            relationships.add(neo4JBasicRelationShip);
        }
        return relationships;
    }

    public static Neo4jBasicSegmentsVO changeToNeo4jBasicRelationReturnVO(InternalPath.SelfContainedSegment[] selfContainedSegments) {
        Neo4jBasicSegmentsVO neo4JBasicSegmentsVO = new Neo4jBasicSegmentsVO();
        ArrayList<String> nodeIdList = new ArrayList<String>();
        ArrayList<Neo4jBasicNode> nodes = new ArrayList<Neo4jBasicNode>();
        ArrayList<Neo4jBasicRelationShip> relationships = new ArrayList<Neo4jBasicRelationShip>();
        for (InternalPath.SelfContainedSegment selfContainedSegment : selfContainedSegments) {
            Neo4jBasicNode endNodeVo;
            String endNodeId;
            Neo4jBasicNode startNodeVo = Neo4jUtil.changeToNeo4jBasicNode(selfContainedSegment.start());
            String startNodeId = startNodeVo.getId();
            if (!nodeIdList.contains(startNodeId)) {
                nodeIdList.add(startNodeId);
                nodes.add(startNodeVo);
            }
            if (!nodeIdList.contains(endNodeId = (endNodeVo = Neo4jUtil.changeToNeo4jBasicNode(selfContainedSegment.end())).getId())) {
                nodeIdList.add(endNodeId);
                nodes.add(endNodeVo);
            }
            Neo4jBasicRelationShip neo4JBasicRelationShip = Neo4jUtil.changeToNeo4jBasicRelationShip(selfContainedSegment.relationship());
            relationships.add(neo4JBasicRelationShip);
        }
        if (ToolUtil.isNotEmpty(nodes) && ToolUtil.isNotEmpty(relationships)) {
            neo4JBasicSegmentsVO.setNodes(nodes);
            neo4JBasicSegmentsVO.setRelationships(relationships);
            neo4JBasicSegmentsVO.setLength(relationships.size());
        }
        return neo4JBasicSegmentsVO;
    }

    private static Neo4jBasicNode changeToNeo4jBasicNode(Node node) {
        Neo4jBasicNode neo4jBasicNode = new Neo4jBasicNode();
        neo4jBasicNode.setId(String.valueOf(node.id()));
        String type2 = "";
        for (String type2 : node.labels()) {
        }
        neo4jBasicNode.setNodeType(type2);
        String name = "";
        Map properties = node.asMap();
        ArrayList propertyList = new ArrayList();
        for (Map.Entry entry : properties.entrySet()) {
            HashMap<String, String> tmp = new HashMap<String, String>();
            String key = (String)entry.getKey();
            String value = entry.getValue().toString();
            tmp.put(key, value);
            propertyList.add(tmp);
            if (!"name".equals(key)) continue;
            name = value;
        }
        neo4jBasicNode.setLabel(name);
        neo4jBasicNode.setProperties(propertyList);
        return neo4jBasicNode;
    }

    private static Neo4jBasicRelationShip changeToNeo4jBasicRelationShip(Relationship relationship) {
        Neo4jBasicRelationShip neo4JBasicRelationShip = new Neo4jBasicRelationShip();
        neo4JBasicRelationShip.setId(String.valueOf(relationship.id()) + "_edge");
        neo4JBasicRelationShip.setSource(String.valueOf(relationship.startNodeId()));
        neo4JBasicRelationShip.setTarget(String.valueOf(relationship.endNodeId()));
        neo4JBasicRelationShip.setLabel(relationship.type());
        Map properties = relationship.asMap();
        ArrayList propertyList = new ArrayList();
        for (Map.Entry entry : properties.entrySet()) {
            HashMap<String, String> tmp = new HashMap<String, String>();
            String key = (String)entry.getKey();
            tmp.put(key, entry.getValue().toString());
            propertyList.add(tmp);
        }
        neo4JBasicRelationShip.setProperties(propertyList);
        return neo4JBasicRelationShip;
    }

    public static JSONObject generateQueryResult(Result query) {
        JSONObject resultObj = new JSONObject();
        ArrayList<Neo4jBasicNode> nodeList = new ArrayList<Neo4jBasicNode>();
        ArrayList<Neo4jBasicRelationShip> relationShipList = new ArrayList<Neo4jBasicRelationShip>();
        ArrayList<NodeModel> nodes = new ArrayList<NodeModel>();
        ArrayList<RelationshipModel> relationships = new ArrayList<RelationshipModel>();
        for (Map map : (Iterable)query.queryResults()) {
            for (String key : map.keySet()) {
                if (key.contains("n")) {
                    Object node = map.get(key);
                    if (!(node instanceof NodeModel)) continue;
                    nodes.add((NodeModel)node);
                    continue;
                }
                if (!key.contains("r")) continue;
                Object relationship = map.get(key);
                if (relationship instanceof RelationshipModel) {
                    relationships.add((RelationshipModel)relationship);
                    continue;
                }
                if (!(relationship instanceof ArrayList)) continue;
                ArrayList relationshipModels = (ArrayList)relationship;
                for (Object model : relationshipModels) {
                    if (!(model instanceof RelationshipModel)) continue;
                    relationships.add((RelationshipModel)model);
                }
            }
        }
        nodeList.addAll(Neo4jUtil.changeToNeo4jBasicNode(nodes));
        relationShipList.addAll(Neo4jUtil.changeToNeo4jQueryRelation(relationships));
        resultObj.put("nodes", nodeList);
        resultObj.put("edges", relationShipList);
        return resultObj;
    }

    public static JSONObject generateQueryResult(List<Map<String, Object>> mapList) {
        JSONObject resultObj = new JSONObject();
        ArrayList<Neo4jBasicNodeVO> nodeList = new ArrayList<Neo4jBasicNodeVO>();
        ArrayList<Neo4jBasicRelationShip> relationShipList = new ArrayList<Neo4jBasicRelationShip>();
        ArrayList<NodeModel> nodes = new ArrayList<NodeModel>();
        ArrayList<RelationshipModel> relationships = new ArrayList<RelationshipModel>();
        for (Map<String, Object> map : mapList) {
            for (String key : map.keySet()) {
                Object relationship;
                if (key.contains("n")) {
                    Object node = map.get(key);
                    if (!(node instanceof NodeModel)) continue;
                    nodes.add((NodeModel)node);
                    continue;
                }
                if (!key.contains("r") || !((relationship = map.get(key)) instanceof RelationshipModel)) continue;
                relationships.add((RelationshipModel)relationship);
            }
        }
        nodeList.addAll(Neo4jUtil.changeToNeo4jBasicNodeVO(nodes));
        relationShipList.addAll(Neo4jUtil.changeToNeo4jQueryRelation(relationships));
        resultObj.put("nodes", nodeList);
        resultObj.put("edges", relationShipList);
        return resultObj;
    }
}

