/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.kgbase.common.util.pdfUtil;

import com.jxdinfo.hussar.kgbase.common.util.pdfUtil.SpringContextUtils;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.regex.Pattern;
import org.jodconverter.OfficeDocumentConverter;
import org.jodconverter.office.DefaultOfficeManagerBuilder;
import org.jodconverter.office.OfficeException;
import org.jodconverter.office.OfficeManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.core.env.Environment;

public class LibreOfficePDFConvert {
    private static ApplicationContext appCtx = SpringContextUtils.getApplicationContext();
    private static final Logger logger = LoggerFactory.getLogger(LibreOfficePDFConvert.class);
    private static String officeHomeDir = null;
    private static Environment environment = (Environment)appCtx.getBean(Environment.class);

    public static synchronized String doDocToFdpLibre(File sourceFile, File tarPdfFile) throws OfficeException {
        File outputFile;
        block2: {
            File inputFile = sourceFile;
            officeHomeDir = environment.getProperty("docbase.officeHomeDir");
            String libreOfficePath = LibreOfficePDFConvert.getOfficeHome();
            DefaultOfficeManagerBuilder builder = new DefaultOfficeManagerBuilder();
            builder.setOfficeHome(new File(libreOfficePath));
            builder.setPortNumber(8100);
            builder.setTaskExecutionTimeout(3000000L);
            builder.setTaskQueueTimeout(864000000L);
            OfficeManager officeManager = builder.build();
            outputFile = null;
            try {
                LibreOfficePDFConvert.startService(officeManager);
                OfficeDocumentConverter converter = new OfficeDocumentConverter(officeManager);
                outputFile = tarPdfFile;
                converter.convert(inputFile, outputFile);
                LibreOfficePDFConvert.stopService(officeManager);
            }
            catch (Exception e) {
                if (!officeManager.isRunning()) break block2;
                LibreOfficePDFConvert.stopService(officeManager);
            }
        }
        String pdfPath = outputFile.getPath();
        return pdfPath;
    }

    private static String getOfficeHome() {
        if (null != officeHomeDir) {
            return officeHomeDir;
        }
        String osName = System.getProperty("os.name");
        if (Pattern.matches("Windows.*", osName)) {
            officeHomeDir = "C:\\Program Files\\LibreOffice";
            return officeHomeDir;
        }
        if (Pattern.matches("Linux.*", osName)) {
            officeHomeDir = "/opt/libreoffice6.0";
            return officeHomeDir;
        }
        if (Pattern.matches("Mac.*", osName)) {
            officeHomeDir = "/Application/openOfficeSoft";
            return officeHomeDir;
        }
        return null;
    }

    private static void stopService(OfficeManager officeManager) throws OfficeException {
        if (null != officeManager) {
            officeManager.stop();
        }
        logger.info("\u5173\u95edoffice\u8f6c\u6362\u6210\u529f!");
    }

    private static void startService(OfficeManager officeManager) {
        try {
            officeManager.start();
            logger.info("office\u8f6c\u6362\u670d\u52a1\u542f\u52a8\u6210\u529f");
        }
        catch (Exception ce) {
            logger.error("office\u8f6c\u6362\u670d\u52a1\u542f\u52a8\u5931\u8d25!\u8be6\u7ec6\u4fe1\u606f:{}", (Throwable)ce);
        }
    }

    public static void setOfficeHome(String officeHome) {
        officeHomeDir = officeHome;
    }

    public static void main(String[] args) {
        Path path = Paths.get("D:\\pdfconvert\\printsource", new String[0]);
        File file1 = new File("C:\\Users\\Administrator\\Desktop\\1.xlsx");
        File file2 = new File("C:\\Users\\Administrator\\Desktop\\1.html");
        File file3 = new File("C:\\Users\\Administrator\\Desktop\\1.pdf");
        try {
            LibreOfficePDFConvert.doDocToFdpLibre(file1, file2);
        }
        catch (OfficeException e) {
            e.printStackTrace();
        }
        try {
            LibreOfficePDFConvert.doDocToFdpLibre(file2, file3);
        }
        catch (OfficeException e) {
            e.printStackTrace();
        }
    }
}

