/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.kgbase.common.util.pdfUtil;

import com.jxdinfo.hussar.kgbase.common.util.pdfUtil.CadUtil;
import com.jxdinfo.hussar.kgbase.common.util.pdfUtil.CebUtil;
import com.jxdinfo.hussar.kgbase.common.util.pdfUtil.ExcelUtil;
import com.jxdinfo.hussar.kgbase.common.util.pdfUtil.ExceptionUtils;
import com.jxdinfo.hussar.kgbase.common.util.pdfUtil.LibreOfficePDFConvert;
import com.jxdinfo.hussar.kgbase.common.util.pdfUtil.SpringContextUtils;
import com.jxdinfo.hussar.kgbase.common.util.pdfUtil.ffmpegUtil;
import it.sauronsoftware.jave.Encoder;
import it.sauronsoftware.jave.MultimediaInfo;
import it.sauronsoftware.jave.VideoInfo;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.core.env.Environment;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.commons.CommonsMultipartFile;

public class ChangeToPdfUtil {
    private static Logger LOGGER = LoggerFactory.getLogger(ChangeToPdfUtil.class);
    static File pdfFile = null;
    private static ApplicationContext appCtx = SpringContextUtils.getApplicationContext();
    private static Environment environment = (Environment)appCtx.getBean(Environment.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final MultipartFile changeToPdf(String ftpFileName, MultipartFile file) throws IOException {
        boolean isConver;
        block19: {
            isConver = false;
            File sourceFile = null;
            try {
                sourceFile = new File(ftpFileName);
                if (!sourceFile.getParentFile().exists()) {
                    sourceFile.getParentFile().mkdirs();
                }
                if (!sourceFile.exists()) {
                    sourceFile.createNewFile();
                }
                String pdfFilePath = ftpFileName.substring(0, ftpFileName.lastIndexOf(".")) + ".pdf";
                String sourceName = file.getOriginalFilename();
                if (!sourceFile.exists()) break block19;
                pdfFile = new File(pdfFilePath);
                String contentType = file.getContentType();
                if (sourceName.endsWith(".ceb")) {
                    CebUtil.ceb2Pdf(sourceFile, pdfFile);
                    isConver = true;
                    break block19;
                }
                if (contentType.contains("cad")) {
                    CadUtil.cad2Pdf(sourceFile, pdfFile);
                    isConver = true;
                    break block19;
                }
                if (contentType.contains("word") || contentType.contains("rtf") || contentType.contains("works")) {
                    LibreOfficePDFConvert.doDocToFdpLibre(sourceFile, pdfFile);
                    isConver = true;
                    break block19;
                }
                if (contentType.contains("text/html") && (sourceName.endsWith(".doc") || sourceName.endsWith(".docx"))) {
                    LibreOfficePDFConvert.doDocToFdpLibre(sourceFile, pdfFile);
                    isConver = true;
                    break block19;
                }
                if (contentType.contains("excel") || contentType.contains("spreadsheetml")) {
                    ExcelUtil.changeExcel(sourceName);
                    LibreOfficePDFConvert.doDocToFdpLibre(sourceFile, pdfFile);
                    isConver = true;
                    break block19;
                }
                if (contentType.contains("powerpoint") || contentType.contains("presentationml")) {
                    LibreOfficePDFConvert.doDocToFdpLibre(sourceFile, pdfFile);
                    isConver = true;
                    break block19;
                }
                if ((contentType.contains("octet-stream") || contentType.contains("text/plain")) && sourceName.endsWith(".txt")) {
                    String type = ChangeToPdfUtil.getFilecharset(sourceFile);
                    if (type.equals("GBK") || type.equals("ANSI")) {
                        String str = FileUtils.readFileToString((File)sourceFile, (String)"GBK");
                        FileUtils.writeStringToFile((File)sourceFile, (String)str, (String)"UTF-8");
                    }
                    LibreOfficePDFConvert.doDocToFdpLibre(sourceFile, pdfFile);
                    isConver = true;
                    break block19;
                }
                if (contentType.contains("octet-stream") && sourceName.endsWith(".tif")) {
                    LibreOfficePDFConvert.doDocToFdpLibre(sourceFile, pdfFile);
                    isConver = true;
                    break block19;
                }
                if (contentType.contains("mp4") || contentType.contains("avi") || contentType.contains("wmv") || contentType.contains("mpg") || contentType.contains("mpeg") || contentType.contains("mov") || contentType.contains("swf") || contentType.contains("flv") || contentType.contains("ram") || contentType.contains("rm")) {
                    LOGGER.info("==========\u51c6\u5907\u89c6\u9891\u8f6c\u6362===========");
                    Encoder encoder = new Encoder();
                    MultimediaInfo info = encoder.getInfo(sourceFile);
                    VideoInfo video = info.getVideo();
                    String decoder = video.getDecoder();
                    if (!decoder.equals("h264") || contentType.contains("mov")) {
                        LOGGER.info("==========\u89c6\u9891\u5f00\u59cb\u8f6c\u6362===========");
                        pdfFilePath = sourceName.substring(0, sourceName.lastIndexOf(".")) + "_new.mp4";
                        ffmpegUtil.convetor(sourceName, pdfFilePath);
                        isConver = true;
                        if (!ChangeToPdfUtil.checkIsEmpty(pdfFilePath) && !(pdfFile = new File(pdfFilePath)).getParentFile().exists()) {
                            LOGGER.info("==========\u89c6\u9891===\u8def\u5f84\u4e0d\u5b58\u5728===========");
                            pdfFile.getParentFile().mkdirs();
                        }
                    }
                    break block19;
                }
                LOGGER.info("==========\u6682\u4e0d\u652f\u6301\u8f6c\u6362===========");
            }
            catch (Exception e) {
                e.printStackTrace();
                LOGGER.error("\u8f6c\u5316PDF\u5931\u8d25\uff1a" + ExceptionUtils.getErrorInfo(e));
            }
        }
        if (isConver) {
            FileItem fileItem = ChangeToPdfUtil.createFileItem(pdfFile);
            CommonsMultipartFile multipartFile = new CommonsMultipartFile(fileItem);
            return multipartFile;
        }
        return null;
    }

    private static FileItem createFileItem(File file) {
        DiskFileItemFactory factory = new DiskFileItemFactory(16, null);
        FileItem item = factory.createItem("textField", "text/plain", true, file.getName());
        int bytesRead = 0;
        byte[] buffer = new byte[8192];
        try {
            FileInputStream fis = new FileInputStream(file);
            OutputStream os = item.getOutputStream();
            while ((bytesRead = fis.read(buffer, 0, 8192)) != -1) {
                os.write(buffer, 0, bytesRead);
            }
            os.close();
            fis.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return item;
    }

    private static final File getAbsoluteFile(String uploadDir, String fileName) throws IOException {
        File desc = new File(uploadDir + File.separator + fileName);
        if (!desc.getParentFile().exists()) {
            desc.getParentFile().mkdirs();
        }
        if (!desc.exists()) {
            desc.createNewFile();
        }
        return desc;
    }

    private static String getFilecharset(File sourceFile) {
        String charset = "GBK";
        byte[] first3Bytes = new byte[3];
        try {
            boolean checked = false;
            BufferedInputStream bis = new BufferedInputStream(new FileInputStream(sourceFile));
            bis.mark(0);
            int read = bis.read(first3Bytes, 0, 3);
            if (read == -1) {
                return charset;
            }
            if (first3Bytes[0] == -1 && first3Bytes[1] == -2) {
                charset = "UTF-16LE";
                checked = true;
            } else if (first3Bytes[0] == -2 && first3Bytes[1] == -1) {
                charset = "UTF-16BE";
                checked = true;
            } else if (first3Bytes[0] == -17 && first3Bytes[1] == -69 && first3Bytes[2] == -65) {
                charset = "UTF-8";
                checked = true;
            }
            bis.reset();
            if (!checked) {
                int loc = 0;
                while ((read = bis.read()) != -1) {
                    ++loc;
                    if (read >= 240 || 128 <= read && read <= 191) break;
                    if (192 <= read && read <= 223) {
                        read = bis.read();
                        if (128 > read || read > 191) break;
                        continue;
                    }
                    if (224 > read || read > 239) continue;
                    read = bis.read();
                    if (128 > read || read > 191 || 128 > (read = bis.read()) || read > 191) break;
                    charset = "UTF-8";
                    break;
                }
            }
            bis.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return charset;
    }

    public static boolean checkIsEmpty(String str) {
        return str == null || "".equals(str) || "null".equals(str);
    }

    private File transFile(MultipartFile fromFile, File toFile) throws IllegalStateException, IOException {
        if (!toFile.getParentFile().exists()) {
            toFile.getParentFile().mkdirs();
        }
        fromFile.transferTo(toFile);
        return toFile;
    }
}

