/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.kgbase.common.util;

import java.io.IOException;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

public class HttpUtil {
    public static String get(String url, MultiValueMap<String, String> params) {
        return HttpUtil.get(url, params, null);
    }

    public static String get(String url, MultiValueMap<String, String> params, MultiValueMap<String, String> headers) {
        return HttpUtil.request(url, params, headers, HttpMethod.GET);
    }

    public static String post(String url, MultiValueMap<String, String> params) {
        return HttpUtil.post(url, params, null);
    }

    public static String post(String url, MultiValueMap<String, String> params, MultiValueMap<String, String> headers) {
        return HttpUtil.request(url, params, headers, HttpMethod.POST);
    }

    public static String put(String url, MultiValueMap<String, String> params) {
        return HttpUtil.put(url, params, null);
    }

    public static String put(String url, MultiValueMap<String, String> params, MultiValueMap<String, String> headers) {
        return HttpUtil.request(url, params, headers, HttpMethod.PUT);
    }

    public static String delete(String url, MultiValueMap<String, String> params) {
        return HttpUtil.delete(url, params, null);
    }

    public static String delete(String url, MultiValueMap<String, String> params, MultiValueMap<String, String> headers) {
        return HttpUtil.request(url, params, headers, HttpMethod.DELETE);
    }

    public static String request(String url, MultiValueMap<String, String> params, MultiValueMap<String, String> headers, HttpMethod method) {
        if (params == null) {
            params = new LinkedMultiValueMap();
        }
        return HttpUtil.request(url, params, headers, method, MediaType.APPLICATION_FORM_URLENCODED);
    }

    public static String request(String url, Object params, MultiValueMap<String, String> headers, HttpMethod method, MediaType mediaType) {
        if (url == null || url.trim().isEmpty()) {
            return null;
        }
        RestTemplate client = new RestTemplate();
        HttpHeaders httpHeaders = new HttpHeaders();
        if (headers != null) {
            httpHeaders.addAll(headers);
        }
        httpHeaders.setContentType(mediaType);
        org.springframework.http.HttpEntity httpEntity = new org.springframework.http.HttpEntity(params, (MultiValueMap)httpHeaders);
        ResponseEntity response = client.exchange(url, method, httpEntity, String.class, new Object[0]);
        return (String)response.getBody();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String doPostJson(String url, Map<String, String> headerMap, String json) {
        CloseableHttpClient httpClient = HttpClients.createDefault();
        CloseableHttpResponse response = null;
        String resultString = "";
        try {
            HttpPost httpPost = new HttpPost(url);
            if (headerMap != null) {
                for (Map.Entry<String, String> elem : headerMap.entrySet()) {
                    httpPost.addHeader(elem.getKey(), elem.getValue());
                }
            }
            StringEntity entity = new StringEntity(json, ContentType.APPLICATION_JSON);
            httpPost.setEntity((HttpEntity)entity);
            response = httpClient.execute((HttpUriRequest)httpPost);
            resultString = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF8");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                response.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return resultString;
    }
}

