/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.kgbase.common.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;

public class DateUtil {
    public static final String DATEFORMATYEAR = "yyyy";
    public static final String DATEFORMATMONTH = "yyyy-MM";
    public static final String DATEFORMATDAY = "yyyy-MM-dd";
    public static final String DATEFORMATHOUR = "yyyy-MM-dd HH";
    public static final String DATEFORMATMINUTE = "yyyy-MM-dd HH:mm";
    public static final String DATEFORMATSECOND = "yyyy-MM-dd HH:mm:ss";
    public static final String DATEFORMATMILLISECOND = "yyyy-MM-dd HH:mm:ss SSS";

    public static String str_to_date_second(String dataStr) {
        String ret = "";
        ret = ret + " str_to_date('" + dataStr + "','%Y-%m-%d %H:%i:%s') ";
        return ret;
    }

    public static String str_to_date_minute(String dataStr) {
        String ret = "";
        ret = ret + " str_to_date('" + dataStr + "','%Y-%m-%d %H:%i') ";
        return ret;
    }

    public static String format(Date date, String format) {
        if (date == null) {
            return null;
        }
        return new SimpleDateFormat(format).format(date);
    }

    public static Date parase(String string, String format) throws ParseException {
        if (StringUtils.isEmpty((CharSequence)string)) {
            return null;
        }
        return new SimpleDateFormat(format).parse(string);
    }

    public static Date string2Date(String dateString) throws ParseException {
        Date dateTime = null;
        if (!StringUtils.isEmpty((CharSequence)dateString)) {
            SimpleDateFormat df = new SimpleDateFormat(DATEFORMATDAY);
            Date date = null;
            date = df.parse(dateString);
            dateTime = new Date(date.getTime());
        }
        return dateTime;
    }

    public static Date getSysDate() {
        Calendar calender = Calendar.getInstance();
        return calender.getTime();
    }

    public static String getDayFirstSecond(Date date) {
        if (date == null) {
            return null;
        }
        String str = DateUtil.format(date, DATEFORMATDAY) + " 00:00:00";
        return str;
    }

    public static String getDayFirstSecond(String date) {
        if (date.equals("")) {
            return null;
        }
        String ret = "";
        try {
            ret = DateUtil.getDayFirstSecond(DateUtil.string2Date(date));
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return ret;
    }

    public static String getDayLastSecond(Date date) {
        if (date == null) {
            return null;
        }
        String str = DateUtil.format(date, DATEFORMATDAY) + " 23:59:59";
        return str;
    }

    public static String getDayLastSecond(String date) {
        if (date.equals("")) {
            return null;
        }
        String ret = "";
        try {
            ret = DateUtil.getDayLastSecond(DateUtil.string2Date(date));
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return ret;
    }

    public static Date getDayFirstTime(Date date) throws Exception {
        if (date == null) {
            return null;
        }
        String str = DateUtil.format(date, DATEFORMATDAY) + " 00:00:00 000";
        return DateUtil.parase(str, DATEFORMATMILLISECOND);
    }

    public static Date getDayLastTime(Date date) throws Exception {
        if (date == null) {
            return null;
        }
        String str = DateUtil.format(date, DATEFORMATDAY) + " 23:59:59 999";
        return DateUtil.parase(str, DATEFORMATMILLISECOND);
    }

    public static Date getYestoday(String strDate) throws ParseException {
        if (null != strDate && strDate.length() > 0) {
            GregorianCalendar cal = new GregorianCalendar();
            cal.setTime(DateUtil.parase(strDate, DATEFORMATDAY));
            cal.add(5, -1);
            String str = DateUtil.format(cal.getTime(), DATEFORMATDAY);
            return DateUtil.parase(str, DATEFORMATDAY);
        }
        return null;
    }

    public static Date getTomorrow() throws ParseException {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(DateUtil.getSysDate());
        cal.add(5, 1);
        String str = DateUtil.format(cal.getTime(), DATEFORMATDAY);
        return DateUtil.parase(str, DATEFORMATDAY);
    }

    public static Date getNextDay(Date someDate) throws ParseException {
        Calendar ca = Calendar.getInstance();
        ca.setTime(someDate);
        ca.add(5, 1);
        String str = DateUtil.format(ca.getTime(), DATEFORMATDAY);
        return DateUtil.parase(str, DATEFORMATDAY);
    }

    public static Date getLastDayOfMonth(Date someDate) {
        Calendar ca = Calendar.getInstance();
        ca.setTime(someDate);
        ca.set(5, 1);
        ca.add(2, 1);
        ca.add(5, -1);
        return ca.getTime();
    }

    public static Date getLastDayOfMonth(String dateStr) throws ParseException {
        SimpleDateFormat sdf = new SimpleDateFormat(DATEFORMATMONTH);
        Date date = sdf.parse(dateStr);
        Calendar ca = Calendar.getInstance();
        ca.setTime(date);
        ca.set(5, 1);
        ca.add(2, 1);
        ca.add(5, -1);
        return ca.getTime();
    }

    public static String getToday() {
        Calendar ca = Calendar.getInstance();
        String str = DateUtil.format(ca.getTime(), DATEFORMATDAY);
        return str;
    }

    public static String getLastMonthToday() {
        Calendar ca = Calendar.getInstance();
        ca.set(2, ca.get(2) - 1);
        String str = DateUtil.format(ca.getTime(), DATEFORMATDAY);
        return str;
    }

    public static String getLastWeekToday() {
        Calendar ca = Calendar.getInstance();
        ca.add(5, -7);
        String str = DateUtil.format(ca.getTime(), DATEFORMATDAY);
        return str;
    }

    public static String getTodayToSecond() {
        Calendar ca = Calendar.getInstance();
        String str = DateUtil.format(ca.getTime(), DATEFORMATSECOND);
        return str;
    }

    public static String getLastMonthTodayToSecond() {
        Calendar ca = Calendar.getInstance();
        ca.set(2, ca.get(2) - 1);
        String str = DateUtil.format(ca.getTime(), DATEFORMATSECOND);
        return str;
    }

    public static String getLastWeekTodayToSecond() {
        Calendar ca = Calendar.getInstance();
        ca.add(5, -7);
        String str = DateUtil.format(ca.getTime(), DATEFORMATSECOND);
        return str;
    }

    public static Date getStartDayOfMonth(Date date) {
        Calendar cDay = Calendar.getInstance();
        cDay.setTime(date);
        cDay.set(5, 1);
        return cDay.getTime();
    }

    public static Date getStartDayOfMonth(String dateStr) throws ParseException {
        SimpleDateFormat sdf = new SimpleDateFormat(DATEFORMATMONTH);
        Date date = sdf.parse(dateStr);
        Calendar cDay = Calendar.getInstance();
        cDay.setTime(date);
        cDay.set(5, 1);
        return cDay.getTime();
    }

    public static Date getEndDayOfMonth(Date date) {
        Calendar cDay = Calendar.getInstance();
        cDay.setTime(date);
        cDay.set(5, cDay.getActualMaximum(5));
        return cDay.getTime();
    }

    public static Date getEndDayOfMonth(String dateStr) throws ParseException {
        SimpleDateFormat sdf = new SimpleDateFormat(DATEFORMATMONTH);
        Date date = sdf.parse(dateStr);
        Calendar cDay = Calendar.getInstance();
        cDay.setTime(date);
        cDay.set(5, cDay.getActualMaximum(5));
        return cDay.getTime();
    }

    public static Date getStartDayOfNextMonth(Date date) {
        Calendar cDay = Calendar.getInstance();
        cDay.setTime(date);
        cDay.add(2, 1);
        cDay.set(5, 1);
        return cDay.getTime();
    }

    public static Date getStartDayOfNextMonth(String dateStr) throws ParseException {
        Date date = DateUtil.parase(dateStr, DATEFORMATMONTH);
        Calendar cDay = Calendar.getInstance();
        cDay.setTime(date);
        cDay.add(2, 1);
        cDay.set(5, 1);
        return cDay.getTime();
    }

    public static Date getMonday(Date date) {
        Calendar cDay = Calendar.getInstance();
        cDay.setTime(date);
        cDay.set(7, 2);
        return cDay.getTime();
    }

    public static Date getSunday(Date date) {
        Calendar cDay = Calendar.getInstance();
        cDay.setTime(date);
        if (7 == cDay.getFirstDayOfWeek()) {
            return date;
        }
        cDay.add(6, 7);
        cDay.set(7, 1);
        return cDay.getTime();
    }

    public static Date getFirstDayOfYear(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(6, 1);
        return calendar.getTime();
    }

    public static Date getFirstDayOfYear(String dateStr) throws ParseException {
        Date date = DateUtil.parase(dateStr, DATEFORMATYEAR);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(6, 1);
        return calendar.getTime();
    }

    public static Date getLastDayOfYear(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(6, calendar.getActualMaximum(6));
        return calendar.getTime();
    }

    public static Date getLastDayOfYear(String dateStr) throws ParseException {
        Date date = DateUtil.parase(dateStr, DATEFORMATYEAR);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(6, calendar.getActualMaximum(6));
        return calendar.getTime();
    }

    public static Date getFirstDayOfNextYear(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(1, 1);
        calendar.set(6, 1);
        return calendar.getTime();
    }

    public static Date getFirstDayOfNextYear(String dateStr) throws ParseException {
        Date date = DateUtil.parase(dateStr, DATEFORMATYEAR);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(1, 1);
        calendar.set(6, 1);
        return calendar.getTime();
    }

    public static String getYestoday() throws ParseException {
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, -1);
        calendar.set(11, 0);
        calendar.set(12, 0);
        return DateUtil.format(calendar.getTime(), DATEFORMATMINUTE);
    }

    public static String getBeforMinutesSysDate(int minute) throws ParseException {
        Calendar calendar = Calendar.getInstance();
        calendar.add(12, -minute);
        return DateUtil.format(calendar.getTime(), DATEFORMATMINUTE);
    }

    public static String getMinuteSysDate() throws ParseException {
        Calendar calendar = Calendar.getInstance();
        return DateUtil.format(calendar.getTime(), DATEFORMATMINUTE);
    }

    public static boolean judgeParseDate(String string) {
        String[] parsePatterns = new String[]{DATEFORMATDAY, "yyyy\u5e74MM\u6708dd\u65e5", DATEFORMATSECOND, DATEFORMATMINUTE, "yyyy/MM/dd", "yyyy/MM/dd HH:mm:ss", "yyyy/MM/dd HH:mm", "yyyyMMdd"};
        if (string == null) {
            return false;
        }
        try {
            DateUtils.parseDate((String)string, (String[])parsePatterns);
            return true;
        }
        catch (ParseException e) {
            return false;
        }
    }
}

