/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.kgbase.build.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.jxdinfo.hussar.kgbase.build.model.dto.NodeDTO;
import com.jxdinfo.hussar.kgbase.build.model.po.Concept;
import com.jxdinfo.hussar.kgbase.build.model.po.Property;
import com.jxdinfo.hussar.kgbase.build.model.po.RelProperty;
import com.jxdinfo.hussar.kgbase.build.model.po.Relation;
import com.jxdinfo.hussar.kgbase.build.model.vo.KettleModel.KettleModelVO;
import com.jxdinfo.hussar.kgbase.build.model.vo.KettleModel.KettleNodeVO;
import com.jxdinfo.hussar.kgbase.build.model.vo.KettleModel.KettlePropertyVO;
import com.jxdinfo.hussar.kgbase.build.model.vo.KettleModel.KettleRelationVO;
import com.jxdinfo.hussar.kgbase.build.service.IConceptService;
import com.jxdinfo.hussar.kgbase.build.service.IKettleModelService;
import com.jxdinfo.hussar.kgbase.build.service.INodeService;
import com.jxdinfo.hussar.kgbase.build.service.IPropertyService;
import com.jxdinfo.hussar.kgbase.build.service.IRelPropertyService;
import com.jxdinfo.hussar.kgbase.build.service.IRelationService;
import com.jxdinfo.hussar.kgbase.common.util.ListUtil;
import dm.jdbc.util.StringUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class KettleModelServiceImpl
implements IKettleModelService {
    @Resource
    private INodeService iNodeService;
    @Resource
    private IConceptService iConceptService;
    @Resource
    private IPropertyService iPropertyService;
    @Resource
    private IRelationService iRelationService;
    @Resource
    private IRelPropertyService iRelPropertyService;

    public KettleModelVO getKettleModel() {
        KettleModelVO kModel = new KettleModelVO();
        ArrayList<KettleNodeVO> nodes = new ArrayList<KettleNodeVO>();
        ArrayList<KettleRelationVO> relationships = new ArrayList<KettleRelationVO>();
        HashMap<String, NodeDTO> nodeMap = new HashMap<String, NodeDTO>();
        List nodeList = this.iNodeService.list();
        ArrayList nodeDTOS = new ArrayList();
        ListUtil.copyList(nodeList, nodeDTOS, NodeDTO.class);
        List conceptList = this.iConceptService.list();
        for (NodeDTO nodeDTO : nodeDTOS) {
            for (Concept concept : conceptList) {
                if (!nodeDTO.getConceptId().equals(concept.getId())) continue;
                nodeDTO.setConcept(concept);
                nodeMap.put(nodeDTO.getId(), nodeDTO);
            }
        }
        for (NodeDTO node : nodeDTOS) {
            KettleNodeVO kNode = new KettleNodeVO();
            kNode.setName(node.getConcept().getConceptName());
            ArrayList<String> labels = new ArrayList<String>();
            labels.add(node.getConcept().getConceptName());
            kNode.setLabels(labels);
            kNode.setLabel(node.getConcept().getConceptName());
            HashMap<String, Long> location = new HashMap<String, Long>();
            location.put("x", Long.valueOf(Double.valueOf(node.getXpos()).intValue()));
            location.put("y", Long.valueOf(Double.valueOf(node.getYpos()).intValue()));
            kNode.setPresentation(location);
            ArrayList<KettlePropertyVO> kNodePropertyVOS = new ArrayList<KettlePropertyVO>();
            QueryWrapper propWrapper = new QueryWrapper();
            propWrapper.eq((Object)"DEL_FLAG", (Object)"0");
            propWrapper.eq((Object)"CONCEPT_ID", (Object)node.getConceptId());
            List propList = this.iPropertyService.list((Wrapper)propWrapper);
            for (Property prop : propList) {
                KettlePropertyVO kProp = new KettlePropertyVO();
                kProp.setName(prop.getPropName());
                kProp.setType(prop.getPropDatatype());
                kProp.setPrimary(false);
                kNodePropertyVOS.add(kProp);
            }
            KettlePropertyVO nameProp = new KettlePropertyVO("name", "STRING", false);
            KettlePropertyVO imageUrlProp = new KettlePropertyVO("headIcon", "STRING", false);
            KettlePropertyVO businessIdProp = new KettlePropertyVO("businessId", "STRING", true);
            kNodePropertyVOS.add(nameProp);
            kNodePropertyVOS.add(imageUrlProp);
            kNodePropertyVOS.add(businessIdProp);
            kNode.setProperties(kNodePropertyVOS);
            nodes.add(kNode);
        }
        List relations = this.iRelationService.list();
        for (Relation r : relations) {
            KettleRelationVO kr = new KettleRelationVO();
            kr.setName(r.getRelationName());
            kr.setLabel(r.getRelationName());
            if (!StringUtil.isNotEmpty((String)r.getSourceNode()) || nodeMap.get(r.getSourceNode()) == null || ((NodeDTO)nodeMap.get(r.getSourceNode())).getConcept() == null) continue;
            kr.setSource(((NodeDTO)nodeMap.get(r.getSourceNode())).getConcept().getConceptName());
            if (!StringUtil.isNotEmpty((String)r.getTargetNode()) || nodeMap.get(r.getTargetNode()) == null || ((NodeDTO)nodeMap.get(r.getTargetNode())).getConcept() == null) continue;
            kr.setTarget(((NodeDTO)nodeMap.get(r.getTargetNode())).getConcept().getConceptName());
            ArrayList<KettlePropertyVO> kRelPropertyVOS = new ArrayList<KettlePropertyVO>();
            List relProperties = this.iRelPropertyService.getPropertyListByRel(r.getId());
            for (RelProperty relProperty : relProperties) {
                KettlePropertyVO kp = new KettlePropertyVO();
                kp.setName(relProperty.getPropName());
                kp.setPrimary(false);
                kp.setType(relProperty.getPropDatatype());
                kRelPropertyVOS.add(kp);
            }
            KettlePropertyVO mainKp = new KettlePropertyVO();
            mainKp.setName("businessId");
            mainKp.setPrimary(true);
            mainKp.setType("STRING");
            kRelPropertyVOS.add(mainKp);
            kr.setProperties(kRelPropertyVOS);
            kr.setStartDateColumn("startDate");
            kr.setEndDateColumn("endDate");
            relationships.add(kr);
        }
        kModel.setNodes(nodes);
        kModel.setRelationships(relationships);
        kModel.setName("Kettle Model");
        return kModel;
    }
}

