/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.kgbase.build.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.core.base.controller.BaseController;
import com.jxdinfo.hussar.core.exception.HussarException;
import com.jxdinfo.hussar.kgbase.build.model.dto.ConceptDTO;
import com.jxdinfo.hussar.kgbase.build.model.po.EntityAlign;
import com.jxdinfo.hussar.kgbase.build.model.vo.ConceptSimilarVO;
import com.jxdinfo.hussar.kgbase.build.model.vo.ConceptVO;
import com.jxdinfo.hussar.kgbase.build.service.IConceptService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.support.audit.core.annotations.AuditLog;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventGrade;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventType;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/concept"})
public class ConceptController
extends BaseController {
    @Autowired
    private IConceptService conceptService;

    @AuditLog(moduleName="\u672c\u4f53", eventDesc="\u65b0\u589e", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.INSERT)
    @PostMapping(value={"/add"})
    public ApiResponse addConcept(@RequestBody ConceptDTO conceptDto) {
        try {
            return ApiResponse.success((Object)this.conceptService.addConcept(conceptDto));
        }
        catch (HussarException e) {
            e.printStackTrace();
            return ApiResponse.fail((String)e.getMessage());
        }
    }

    @AuditLog(moduleName="\u672c\u4f53", eventDesc="\u4fee\u6539", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    @PostMapping(value={"/edit"})
    public ApiResponse editConcept(@RequestBody ConceptDTO conceptDto) {
        try {
            this.conceptService.editConcept(conceptDto);
        }
        catch (HussarException e) {
            e.printStackTrace();
            return ApiResponse.fail((String)e.getMessage());
        }
        return ApiResponse.success();
    }

    @AuditLog(moduleName="\u672c\u4f53", eventDesc="\u5220\u9664", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.DELETE)
    @PostMapping(value={"/delete"})
    public ApiResponse deleteConcept(@RequestBody ConceptDTO conceptDto) {
        try {
            this.conceptService.deleteConcept(conceptDto);
        }
        catch (HussarException e) {
            e.printStackTrace();
            return ApiResponse.fail((String)e.getMessage());
        }
        return ApiResponse.success();
    }

    @AuditLog(moduleName="\u672c\u4f53", eventDesc="\u6279\u91cf\u5220\u9664", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.DELETE)
    @GetMapping(value={"/deleteConceptByIds"})
    public ApiResponse deleteConceptByIds(String conceptIds) {
        try {
            this.conceptService.deleteConceptByIds(conceptIds);
        }
        catch (HussarException e) {
            e.printStackTrace();
            return ApiResponse.fail((String)e.getMessage());
        }
        return ApiResponse.success();
    }

    @AuditLog(moduleName="\u672c\u4f53", eventDesc="\u6811\u67e5\u8be2", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.QUERY)
    @PostMapping(value={"/getTree"})
    public ApiResponse<List<ConceptVO>> getTree() {
        try {
            return ApiResponse.success((Object)this.conceptService.getTree());
        }
        catch (HussarException e) {
            e.printStackTrace();
            return ApiResponse.fail((String)e.getMessage());
        }
    }

    @AuditLog(moduleName="\u672c\u4f53", eventDesc="\u8be6\u60c5", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.QUERY)
    @PostMapping(value={"/getDetailsById"})
    public ApiResponse<ConceptVO> getDetailsById(@RequestBody ConceptDTO conceptDto) {
        try {
            return ApiResponse.success((Object)this.conceptService.getDetailsById(conceptDto.getId()));
        }
        catch (HussarException e) {
            e.printStackTrace();
            return ApiResponse.fail((String)e.getMessage());
        }
    }

    @AuditLog(moduleName="\u672c\u4f53", eventDesc="\u5217\u8868\u67e5\u8be2", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.QUERY)
    @PostMapping(value={"/queryList"})
    public ApiResponse<Page<ConceptVO>> queryList(@RequestBody ConceptDTO conceptDto) {
        try {
            return ApiResponse.success((Object)this.conceptService.queryList(conceptDto));
        }
        catch (HussarException e) {
            e.printStackTrace();
            return ApiResponse.fail((String)e.getMessage());
        }
    }

    @AuditLog(moduleName="\u672c\u4f53", eventDesc="\u540d\u79f0\u6821\u9a8c", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.QUERY)
    @GetMapping(value={"/checkConceptUnique"})
    public ApiResponse checkConceptUnique(String conceptOrLabelName, String nameOrLabel, String conceptId) {
        try {
            return ApiResponse.success((Object)this.conceptService.checkConceptUnique(conceptOrLabelName, nameOrLabel, conceptId));
        }
        catch (HussarException e) {
            e.printStackTrace();
            return ApiResponse.fail((String)e.getMessage());
        }
    }

    @AuditLog(moduleName="\u672c\u4f53", eventDesc="\u67e5\u8be2\u878d\u5408\u5217\u8868", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.QUERY)
    @PostMapping(value={"/getOntologyFusionList"})
    public ApiResponse<List<ConceptSimilarVO>> getOntologyFusionList() {
        try {
            return ApiResponse.success((Object)this.conceptService.getOntologyFusionList());
        }
        catch (HussarException e) {
            e.printStackTrace();
            return ApiResponse.fail((String)e.getMessage());
        }
    }

    @AuditLog(moduleName="\u672c\u4f53", eventDesc="\u67e5\u8be2\u8282\u70b9\u8be6\u60c5", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.QUERY)
    @GetMapping(value={"/getAAndBInfo"})
    public ApiResponse<Map<String, Object>> getAAndBInfo(@RequestParam String ids) {
        try {
            return ApiResponse.success((Object)this.conceptService.getAAndBInfo(ids));
        }
        catch (HussarException e) {
            e.printStackTrace();
            return ApiResponse.fail((String)e.getMessage());
        }
    }

    @AuditLog(moduleName="\u672c\u4f53", eventDesc="\u672c\u4f53\u5bf9\u5176\u65b0\u589e\u5bf9\u9f50\u8bb0\u5f55\u5e76\u64cd\u4f5c\u5bf9\u5e94\u672c\u4f53\u4fe1\u606f", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    @PostMapping(value={"/addOntologyFusion"})
    public ApiResponse addOntologyFusion(@RequestBody EntityAlign entityAlign) {
        return this.conceptService.addOntologyFusion(entityAlign);
    }
}

