/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.kgbase.application.nodeconfig.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.kgbase.application.globalconfig.model.GlobalConfig;
import com.jxdinfo.hussar.kgbase.application.globalconfig.service.IGlobalConfigService;
import com.jxdinfo.hussar.kgbase.application.nodeconfig.dao.NodeConfigMapper;
import com.jxdinfo.hussar.kgbase.application.nodeconfig.model.NodeConfig;
import com.jxdinfo.hussar.kgbase.application.nodeconfig.service.INodeConfigService;
import com.jxdinfo.hussar.kgbase.build.model.dto.NodeDTO;
import com.jxdinfo.hussar.kgbase.build.service.INodeService;
import com.jxdinfo.hussar.kgbase.common.util.ColorUtil;
import com.jxdinfo.hussar.kgbase.neo4j.repository.GraphQueryRepository;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class NodeConfigServiceImpl
extends ServiceImpl<NodeConfigMapper, NodeConfig>
implements INodeConfigService {
    @Resource
    private IGlobalConfigService globalConfigService;
    @Resource
    private GraphQueryRepository graphQueryRepository;
    @Resource
    private INodeService iNodeService;

    public List<NodeConfig> getConfigList(String version) {
        QueryWrapper ew = new QueryWrapper();
        if (ToolUtil.isNotEmpty((Object)version)) {
            ew.like((Object)"VERSION", (Object)version);
        }
        ew.orderByAsc((Object)"CREATE_TIME");
        return this.list((Wrapper)ew);
    }

    public List<NodeConfig> getOntologyConfigList(String version) {
        ArrayList<NodeConfig> nodeConfigList = new ArrayList<NodeConfig>();
        QueryWrapper gcQueryWrapper = new QueryWrapper();
        gcQueryWrapper.eq((Object)"VERSION", (Object)version);
        GlobalConfig globalConfig = (GlobalConfig)this.globalConfigService.getOne((Wrapper)gcQueryWrapper);
        if (globalConfig == null) {
            globalConfig = this.globalConfigService.getCurrentConfig();
        }
        String nodeGlobalConfig = globalConfig.getNodeStyle();
        JSONObject nodeJson = JSONObject.parseObject((String)nodeGlobalConfig);
        String size = String.valueOf(nodeJson.get((Object)"size"));
        List nodeList = (List)this.iNodeService.getAllNodes().get("nodes");
        for (NodeDTO node : nodeList) {
            NodeConfig nodeConfig = new NodeConfig();
            nodeConfig.setId(Long.valueOf(node.getId()));
            nodeConfig.setVersion(version);
            if (node.getConcept() != null && node.getConcept().getConceptName() != null) {
                nodeConfig.setLabel(node.getConcept().getConceptName());
            } else {
                nodeConfig.setLabel("\u8282\u70b9\u540d\u79f0\u7f3a\u5931");
            }
            nodeConfig.setFill(node.getNodeColor());
            nodeConfig.setBorderColor(ColorUtil.getDarkColor(node.getNodeColor()));
            nodeConfig.setNodeIcon(node.getNodeIcon());
            nodeConfig.setIconColor(node.getIconColor());
            nodeConfig.setTextColor(ColorUtil.isDarkHex(node.getNodeColor()) ? "Black" : "White");
            nodeConfig.setNodesSize(size);
            nodeConfigList.add(nodeConfig);
        }
        return nodeConfigList;
    }

    public Map<String, Object> saveConfig(NodeConfig nodeConfig) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        boolean success = true;
        String msg = "";
        boolean addFlag = true;
        Long configId = nodeConfig.getId();
        if (ToolUtil.isNotEmpty((Object)configId)) {
            addFlag = false;
        }
        SecurityUser user = BaseSecurityUtil.getUser();
        Long userId = null;
        if (user != null) {
            userId = user.getId();
        }
        Timestamp date = new Timestamp(System.currentTimeMillis());
        if (addFlag) {
            nodeConfig.setCreator(userId);
            nodeConfig.setCreateTime((Date)date);
        } else {
            nodeConfig.setLastEditor(userId);
            nodeConfig.setLastTime((Date)date);
        }
        success = this.saveOrUpdate(nodeConfig);
        if (!success) {
            msg = "\u4fdd\u5b58\u5931\u8d25";
        }
        result.put("success", success);
        result.put("msg", msg);
        return result;
    }

    public Map<String, Object> deleteConfig(Long id) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        boolean success = true;
        success = this.removeById(id);
        result.put("success", success);
        result.put("msg", "\u5220\u9664\u6210\u529f");
        return result;
    }

    public boolean generateNodeConfig(NodeConfig nodeConfig) {
        try {
            ArrayList<NodeConfig> configs = new ArrayList<NodeConfig>();
            List<Object> colors = new ArrayList();
            String version = nodeConfig.getVersion();
            QueryWrapper ncQueryWrapper = new QueryWrapper();
            ncQueryWrapper.eq((Object)"VERSION", (Object)version);
            this.remove((Wrapper)ncQueryWrapper);
            HashMap<String, NodeDTO> conceptMap = new HashMap<String, NodeDTO>();
            List nodeDTOS = (List)this.iNodeService.getAllNodes().get("nodes");
            for (NodeDTO nodeDTO : nodeDTOS) {
                conceptMap.put(nodeDTO.getConcept().getConceptName(), nodeDTO);
            }
            QueryWrapper gcQueryWrapper = new QueryWrapper();
            gcQueryWrapper.eq((Object)"VERSION", (Object)version);
            GlobalConfig globalConfig = (GlobalConfig)this.globalConfigService.getOne((Wrapper)gcQueryWrapper);
            String nodeGlobalConfig = globalConfig.getNodeStyle();
            JSONObject nodeJson = JSONObject.parseObject((String)nodeGlobalConfig);
            String size = String.valueOf(nodeJson.get((Object)"size"));
            List<Map<String, Object>> labelList = this.graphQueryRepository.getNodeLabels();
            colors = ColorUtil.getColors(nodeConfig.getColorType());
            if (colors.size() == 0) {
                throw new Exception("\u989c\u8272\u96c6\u4e0d\u5b58\u5728");
            }
            for (Map<String, Object> labelMap : labelList) {
                String color = "";
                if (colors.size() == 0) {
                    colors = ColorUtil.getColors(nodeConfig.getColorType());
                }
                Random random = new Random();
                int n = random.nextInt(colors.size());
                color = (String)colors.get(n);
                colors.remove(n);
                String label = String.valueOf(labelMap.get("type"));
                NodeConfig newConfig = new NodeConfig();
                newConfig.setVersion(version);
                newConfig.setNodesSize(size);
                newConfig.setLabel(label);
                newConfig.setFill(color);
                newConfig.setBorderColor(ColorUtil.getDarkColor(color));
                newConfig.setTextColor(ColorUtil.isDarkHex(color) ? "Black" : "White");
                if (BaseSecurityUtil.getUser() != null) {
                    newConfig.setCreator(BaseSecurityUtil.getUser().getId());
                }
                newConfig.setCreateTime(new Date());
                newConfig.setNodeIcon(((NodeDTO)conceptMap.get(label)).getNodeIcon());
                newConfig.setIconColor("White");
                configs.add(newConfig);
            }
            this.saveBatch(configs);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }
}

