/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.kgbase.application.instancemanage.controller;

import com.jxdinfo.hussar.core.base.controller.BaseController;
import com.jxdinfo.hussar.kgbase.application.instancemanage.model.dto.InstanceNodeDTO;
import com.jxdinfo.hussar.kgbase.application.instancemanage.model.dto.InstanceRelationDTO;
import com.jxdinfo.hussar.kgbase.application.instancemanage.service.InstanceManageService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.support.audit.core.annotations.AuditLog;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventGrade;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventType;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/instanceManage"})
public class InstanceManageController
extends BaseController {
    @Resource
    private InstanceManageService instanceManageService;

    @AuditLog(moduleName="\u5b9e\u4f8b\u7ba1\u7406", eventDesc="\u672c\u4f53\u6784\u5efa\u7684\u5b9e\u4f53\u6811+\u65b0\u589e\u7684\u5b9e\u4f53\u6811", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.QUERY)
    @GetMapping(value={"/getTree"})
    public ApiResponse getTree() {
        return ApiResponse.success((Object)this.instanceManageService.getTree());
    }

    @AuditLog(moduleName="\u5b9e\u4f8b\u7ba1\u7406", eventDesc="\u5b9e\u4f8b\u5217\u8868\u67e5\u8be2", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.QUERY)
    @PostMapping(value={"/nodeList"})
    public ApiResponse nodeList(@RequestBody InstanceNodeDTO dto) {
        return ApiResponse.success((Object)this.instanceManageService.nodeList(dto));
    }

    @AuditLog(moduleName="\u5b9e\u4f8b\u7ba1\u7406", eventDesc="\u5bfc\u51fa\u5b9e\u4f8b", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.QUERY)
    @GetMapping(value={"/exportNodeList"})
    public void exportNodeList(@RequestParam String nodeType, @RequestParam(defaultValue="0") String way, HttpServletRequest request, HttpServletResponse response) {
        this.instanceManageService.exportNodeList(nodeType, way, request, response);
    }

    @AuditLog(moduleName="\u5b9e\u4f8b\u7ba1\u7406", eventDesc="\u5b9e\u4f8b\u5173\u7cfb\u5217\u8868\u67e5\u8be2", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.QUERY)
    @PostMapping(value={"/relationList"})
    public ApiResponse relationList(@RequestBody InstanceRelationDTO dto) {
        return ApiResponse.success((Object)this.instanceManageService.relationList(dto));
    }

    @AuditLog(moduleName="\u5b9e\u4f8b\u7ba1\u7406", eventDesc="\u65b0\u589e\u5b9e\u4f8b", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.INSERT)
    @PostMapping(value={"/addNode"})
    public ApiResponse addNode(@RequestBody InstanceNodeDTO dto) {
        return ApiResponse.success((Object)this.instanceManageService.addNode(dto));
    }

    @AuditLog(moduleName="\u5b9e\u4f8b\u7ba1\u7406", eventDesc="\u7f16\u8f91\u5b9e\u4f8b", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    @PostMapping(value={"/editNode"})
    public ApiResponse editNode(@RequestBody InstanceNodeDTO dto) {
        return ApiResponse.success((Object)this.instanceManageService.editNode(dto));
    }

    @AuditLog(moduleName="\u5b9e\u4f8b\u7ba1\u7406", eventDesc="\u6279\u91cf\u5220\u9664\u5b9e\u4f8b", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.DELETE)
    @GetMapping(value={"/deleteNodes"})
    public ApiResponse deleteNodes(@RequestParam String ids) {
        return ApiResponse.success((Object)this.instanceManageService.deleteNodes(ids));
    }

    @AuditLog(moduleName="\u5b9e\u4f8b\u7ba1\u7406", eventDesc="\u6839\u636e\u5b9e\u4f8bid\u67e5\u8be2\u8be6\u60c5", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.QUERY)
    @GetMapping(value={"/getNodeInfo"})
    public ApiResponse getNodeInfo(@RequestParam String id) {
        return ApiResponse.success((Object)this.instanceManageService.getNodeInfo(id));
    }

    @AuditLog(moduleName="\u5b9e\u4f8b\u7ba1\u7406", eventDesc="\u65b0\u589e\u5b9e\u4f8b\u5173\u7cfb", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.INSERT)
    @PostMapping(value={"/addRelation"})
    public ApiResponse addRelation(@RequestBody InstanceRelationDTO dto) {
        return ApiResponse.success((Object)this.instanceManageService.addRelation(dto));
    }

    @AuditLog(moduleName="\u5b9e\u4f8b\u7ba1\u7406", eventDesc="\u7f16\u8f91\u5b9e\u4f8b\u5173\u7cfb", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    @PostMapping(value={"/editRelation"})
    public ApiResponse editRelation(@RequestBody InstanceRelationDTO dto) {
        if (dto.getId().contains("edge")) {
            dto.setId(dto.getId().replaceAll("_edge", ""));
        }
        return this.instanceManageService.editRelation(dto);
    }

    @AuditLog(moduleName="\u5b9e\u4f8b\u7ba1\u7406", eventDesc="\u6279\u91cf\u5220\u9664\u5b9e\u4f8b\u5173\u7cfb", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.DELETE)
    @GetMapping(value={"/deleteRelations"})
    public ApiResponse deleteRelations(@RequestParam String ids) {
        if (ids.contains("edge")) {
            ids = ids.replaceAll("_edge", "");
        }
        return ApiResponse.success((Object)this.instanceManageService.deleteRelations(ids));
    }

    @AuditLog(moduleName="\u5b9e\u4f8b\u7ba1\u7406", eventDesc="\u6839\u636e\u5b9e\u4f8b\u5173\u7cfbid\u67e5\u8be2\u8be6\u60c5", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.QUERY)
    @GetMapping(value={"/getRelationInfo"})
    public ApiResponse getPropsByRelationId(@RequestParam String id) {
        if (id.contains("edge")) {
            id = id.replaceAll("_edge", "");
        }
        return ApiResponse.success((Object)this.instanceManageService.getRelationInfo(id));
    }

    @AuditLog(moduleName="\u5b9e\u4f8b\u7ba1\u7406", eventDesc="\u5bfc\u5165\u6570\u636e", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.QUERY)
    @PostMapping(value={"/importNodeList"})
    public ApiResponse importFullAmount(MultipartFile file) {
        return ApiResponse.success((Object)this.instanceManageService.importNodeList(file));
    }
}

