/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.kgbase.algomodel.service.impl;

import com.jxdinfo.hussar.kgbase.algomodel.model.po.TrainLog;
import com.jxdinfo.hussar.kgbase.algomodel.model.po.TrainTask;
import com.jxdinfo.hussar.kgbase.algomodel.service.ITrainLogService;
import com.jxdinfo.hussar.kgbase.algomodel.service.ITrainTaskService;
import io.minio.GetObjectArgs;
import io.minio.GetObjectResponse;
import io.minio.ListObjectsArgs;
import io.minio.MinioClient;
import io.minio.Result;
import io.minio.messages.Item;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class TrainLogServiceImpl
implements ITrainLogService {
    @Resource
    private ITrainTaskService trainTaskService;
    @Resource
    private MinioClient minioClient;

    public List<String> getLogsByTrainTaskId(String taskId) {
        ArrayList<String> filePathList = new ArrayList<String>();
        TrainTask task = (TrainTask)this.trainTaskService.getById((Serializable)((Object)taskId));
        if (task != null) {
            try {
                Iterable results = this.minioClient.listObjects((ListObjectsArgs)((ListObjectsArgs.Builder)ListObjectsArgs.builder().bucket(taskId)).prefix("logs/").build());
                for (Result result : results) {
                    filePathList.add(((Item)result.get()).objectName());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return filePathList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TrainLog getLogInfo(TrainLog trainLog) {
        StringBuilder stringBuilder = new StringBuilder();
        FileInputStream fileInputStream = null;
        InputStreamReader inputStreamReader = null;
        BufferedReader bufferedReader = null;
        try {
            GetObjectResponse inputStream = this.minioClient.getObject((GetObjectArgs)((GetObjectArgs.Builder)((GetObjectArgs.Builder)GetObjectArgs.builder().bucket(trainLog.getTaskId())).object(trainLog.getFilePath())).build());
            inputStreamReader = new InputStreamReader((InputStream)inputStream, StandardCharsets.UTF_8);
            bufferedReader = new BufferedReader(inputStreamReader);
            String lineString = bufferedReader.readLine();
            while (lineString != null) {
                stringBuilder.append(lineString).append("\r");
                lineString = bufferedReader.readLine();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (inputStreamReader != null) {
                try {
                    inputStreamReader.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        trainLog.setLogs(stringBuilder.toString());
        return trainLog;
    }
}

