/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.kgbase.algomodel.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.jxdinfo.hussar.core.exception.HussarException;
import com.jxdinfo.hussar.kgbase.algomodel.dao.TrainNoteMapper;
import com.jxdinfo.hussar.kgbase.algomodel.model.dto.PeDTO;
import com.jxdinfo.hussar.kgbase.algomodel.model.po.TrainModel;
import com.jxdinfo.hussar.kgbase.algomodel.model.po.TrainNote;
import com.jxdinfo.hussar.kgbase.algomodel.model.po.TrainTask;
import com.jxdinfo.hussar.kgbase.algomodel.model.vo.TrainTaskVO;
import com.jxdinfo.hussar.kgbase.algomodel.service.ITrainModelService;
import com.jxdinfo.hussar.kgbase.algomodel.service.ITrainNoteService;
import com.jxdinfo.hussar.kgbase.algomodel.service.ITrainTaskService;
import com.jxdinfo.hussar.kgbase.algomodel.service.PeService;
import com.jxdinfo.hussar.kgbase.algomodel.util.PeWebSocket;
import com.jxdinfo.hussar.kgbase.common.util.HttpUtil;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.util.Date;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class PeServiceImpl
implements PeService {
    @Resource
    private ITrainTaskService iTrainTaskService;
    @Resource
    private ITrainNoteService iTrainNoteService;
    @Resource
    private ITrainModelService iTrainModelService;
    @Resource
    private TrainNoteMapper trainNoteMapper;
    @Resource
    private PeWebSocket peWebSocket;
    @Value(value="${model-config.pe-api}")
    private String peApi;
    @Value(value="${model-config.pe-location}")
    private String peLocation;
    @Value(value="${minio.location}")
    private String minioLocation;
    private Process trainProc;
    private Process serviceProc;

    public ApiResponse propertyRecognitionPedict(PeDTO peDTO) {
        String strRes = HttpUtil.doPostJson(this.peApi, null, JSON.toJSONString((Object)peDTO));
        if (StringUtil.isEmpty((Object)strRes)) {
            return ApiResponse.fail((String)"\u672a\u62bd\u53d6\u51fa\u5b9e\u4f53\u5173\u7cfb");
        }
        JSONArray jsonArrayRes = JSONArray.parseArray((String)strRes);
        return ApiResponse.success((Object)jsonArrayRes);
    }

    public ApiResponse propertyRecognitionTrain(final String trainTaskId) {
        final TrainTaskVO taskVO = (TrainTaskVO)this.iTrainTaskService.getInfoById(trainTaskId).getData();
        final String modelPath = this.minioLocation + "/" + trainTaskId + "/models";
        final String logPath = this.minioLocation + "/" + trainTaskId + "/logs";
        final StringBuffer relLabels = new StringBuffer();
        Map labelMap = taskVO.getDataStatis();
        int index = 0;
        for (String key : labelMap.keySet()) {
            relLabels.append(key);
            if (++index >= labelMap.size()) continue;
            relLabels.append(",");
        }
        try {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    try {
                        UpdateWrapper taskUpdateWrapper = new UpdateWrapper();
                        taskUpdateWrapper.eq((Object)"ID", (Object)trainTaskId);
                        taskUpdateWrapper.eq((Object)"DEL_FLAG", (Object)"0");
                        taskUpdateWrapper.set((Object)"TASK_STATE", (Object)"1");
                        taskUpdateWrapper.set((Object)"MODEL_PATH", (Object)modelPath);
                        taskUpdateWrapper.set((Object)"LOG_PATH", (Object)logPath);
                        taskUpdateWrapper.set((Object)"TRAIN_START_TIME", (Object)new Date());
                        taskUpdateWrapper.set((Object)"TRAIN_END_TIME", null);
                        PeServiceImpl.this.iTrainTaskService.update((Wrapper)taskUpdateWrapper);
                        PeServiceImpl.this.trainNoteMapper.deleteNotesByTaskId(trainTaskId);
                        TrainTask task = (TrainTask)PeServiceImpl.this.iTrainTaskService.getById((Serializable)((Object)trainTaskId));
                        StringBuffer command = new StringBuffer("python ").append(PeServiceImpl.this.peLocation).append("/main.py ");
                        command.append(" --datasets_fold=").append(taskVO.getSamplePath());
                        command.append(" --log_dir=").append(logPath);
                        command.append(" --model_dir=").append(modelPath);
                        command.append(" --suffix=").append(relLabels.toString());
                        command.append(" --epoch=").append(taskVO.getEpoch());
                        command.append(" --batch_size=").append(taskVO.getBatchSize());
                        command.append(" --learning_rate=").append(taskVO.getLearningRate());
                        PeServiceImpl.this.trainProc = Runtime.getRuntime().exec(command.toString(), null, new File(PeServiceImpl.this.peLocation));
                        FileInputStream errorStream = (FileInputStream)PeServiceImpl.this.trainProc.getErrorStream();
                        InputStreamReader isr = new InputStreamReader((InputStream)errorStream, "gbk");
                        BufferedReader in = new BufferedReader(isr);
                        String line = null;
                        String lastLine = "";
                        while ((line = in.readLine()) != null) {
                            System.out.println(line);
                            if (lastLine.startsWith("epoch finished")) {
                                JSONObject epochRes = JSONObject.parseObject((String)line);
                                TrainNote trainNote = new TrainNote();
                                trainNote.setTrainTaskId(trainTaskId);
                                trainNote.setCreateTime(new Date());
                                trainNote.setCurrentEpoch(Integer.parseInt(epochRes.getString("epoch")));
                                trainNote.setPrecisionRate(Double.parseDouble(epochRes.getString("precision")));
                                trainNote.setRecall(Double.parseDouble(epochRes.getString("recall")));
                                trainNote.setF1(Double.parseDouble(epochRes.getString("f1")));
                                trainNote.setAccuracy(Double.parseDouble(epochRes.getString("accuracy")));
                                trainNote.setIsBest(epochRes.getString("isBest"));
                                if ("1".equals(trainNote.getIsBest())) {
                                    PeServiceImpl.this.trainNoteMapper.setIsBestToZero(trainTaskId);
                                }
                                trainNote.setTimeConsumption(epochRes.getString("timeConsumption"));
                                PeServiceImpl.this.iTrainNoteService.save((Object)trainNote);
                                DecimalFormat decimalFormat = new DecimalFormat("0.00");
                                String progress = decimalFormat.format((float)trainNote.getCurrentEpoch() / (float)task.getEpoch().intValue());
                                task.setTaskProgress(progress);
                                PeServiceImpl.this.iTrainTaskService.updateById((Object)task);
                            }
                            PeServiceImpl.this.peWebSocket.sendMessage(line);
                            lastLine = line;
                        }
                        in.close();
                        System.out.println("IN CLOSED");
                        if (PeServiceImpl.this.trainProc.waitFor() == 0) {
                            task.setTaskState("2");
                            task.setTrainEndTime(new Date());
                            PeServiceImpl.this.iTrainTaskService.updateById((Object)task);
                        } else {
                            PeServiceImpl.this.iTrainTaskService.stopTraining(trainTaskId);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        PeServiceImpl.this.iTrainTaskService.stopTraining(trainTaskId);
                    }
                }
            };
            Thread thread = new Thread(runnable);
            thread.start();
            return ApiResponse.success((String)"\u5f00\u59cb\u8bad\u7ec3");
        }
        catch (Exception e) {
            e.printStackTrace();
            this.iTrainTaskService.stopTraining(trainTaskId);
            return ApiResponse.fail((String)e.getMessage());
        }
    }

    public boolean peSeviceStart(String trainTaskId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"TRAIN_TASK_ID", (Object)trainTaskId);
        queryWrapper.eq((Object)"DEL_FLAG", (Object)"0");
        final TrainModel model = (TrainModel)this.iTrainModelService.getOne((Wrapper)queryWrapper);
        final TrainTaskVO taskVO = (TrainTaskVO)this.iTrainTaskService.getInfoById(trainTaskId).getData();
        final String modelPath = this.minioLocation + "/" + trainTaskId + "/models";
        final String logPath = this.minioLocation + "/" + trainTaskId + "/service_logs";
        final StringBuffer relLabels = new StringBuffer();
        Map labelMap = taskVO.getDataStatis();
        int index = 0;
        for (String key : labelMap.keySet()) {
            relLabels.append(key);
            if (++index >= labelMap.size()) continue;
            relLabels.append(",");
        }
        try {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    try {
                        StringBuffer command = new StringBuffer("python ").append(PeServiceImpl.this.peLocation).append("/flask_service.py");
                        command.append(" --datasets_fold=").append(taskVO.getSamplePath());
                        command.append(" --log_dir=").append(logPath);
                        command.append(" --model_dir=").append(modelPath);
                        command.append(" --suffix=").append(relLabels.toString());
                        command.append(" --epoch=").append(taskVO.getEpoch());
                        command.append(" --batch_size=").append(taskVO.getBatchSize());
                        command.append(" --learning_rate=").append(taskVO.getLearningRate());
                        PeServiceImpl.this.serviceProc = Runtime.getRuntime().exec(command.toString(), null, new File(PeServiceImpl.this.peLocation));
                        FileInputStream errorStream = (FileInputStream)PeServiceImpl.this.serviceProc.getErrorStream();
                        InputStreamReader isr = new InputStreamReader((InputStream)errorStream, "gbk");
                        BufferedReader in = new BufferedReader(isr);
                        String line = null;
                        while ((line = in.readLine()) != null) {
                            System.out.println(line);
                            if (!line.startsWith("service launched")) continue;
                            model.setModelState("1");
                            PeServiceImpl.this.iTrainModelService.updateById((Object)model);
                        }
                        in.close();
                        if (PeServiceImpl.this.trainProc.waitFor() != 0) {
                            model.setModelState("3");
                            PeServiceImpl.this.iTrainModelService.updateById((Object)model);
                        }
                    }
                    catch (Exception e) {
                        model.setModelState("3");
                        PeServiceImpl.this.iTrainModelService.updateById((Object)model);
                        e.printStackTrace();
                    }
                }
            };
            Thread thread = new Thread(runnable);
            thread.start();
            return true;
        }
        catch (HussarException e) {
            e.printStackTrace();
            return false;
        }
    }

    public void destoryPeService() {
        this.serviceProc.destroy();
    }

    public void destoryPeTrain() {
        if (this.trainProc != null) {
            this.trainProc.destroy();
        }
    }
}

