/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.kgbase.algomodel.controller;

import cn.hutool.core.util.IdUtil;
import com.jxdinfo.hussar.core.exception.HussarException;
import com.jxdinfo.hussar.kgbase.algomodel.service.ISampleService;
import com.jxdinfo.hussar.kgbase.bzrw.kgtaggingtask1.vo.KgAnnotatedCorpusRelationVO;
import com.jxdinfo.hussar.kgbase.bzrw.kgtaggingtask1.vo.KgAnnotatedCorpusVO;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import com.jxdinfo.hussar.support.audit.core.annotations.AuditLog;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventGrade;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventType;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.springframework.core.io.ClassPathResource;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/sample"})
public class SampleController {
    @Resource
    private ISampleService iSampleService;

    @AuditLog(moduleName="\u8bad\u7ec3\u4efb\u52a1", eventDesc="\u6587\u4ef6\u4e0a\u4f20", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.FILE)
    @PostMapping(value={"/loadFile"})
    public ApiResponse loadFile(@RequestBody MultipartFile file, String modelType) {
        try {
            if (StringUtil.isEmpty((Object)modelType)) {
                modelType = "NER";
            }
            return this.iSampleService.loadFile(file, modelType);
        }
        catch (HussarException e) {
            e.printStackTrace();
            return ApiResponse.fail((String)e.getMessage());
        }
    }

    @AuditLog(moduleName="\u8bad\u7ec3\u4efb\u52a1", eventDesc="\u67e5\u8be2", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.QUERY)
    @PostMapping(value={"/exportNerCorpus"})
    public ApiResponse exportNerCorpus(HttpServletResponse response, @RequestBody List<KgAnnotatedCorpusVO> nerModels) {
        String bucketName = IdUtil.fastSimpleUUID();
        return this.iSampleService.changeToNerCorpus(nerModels, bucketName);
    }

    @AuditLog(moduleName="\u8bad\u7ec3\u4efb\u52a1", eventDesc="\u67e5\u8be2", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.QUERY)
    @PostMapping(value={"/exportReCorpus"})
    public ApiResponse exportReCorpus(HttpServletResponse response, @RequestBody List<KgAnnotatedCorpusRelationVO> reModels) {
        String bucketName = IdUtil.fastSimpleUUID();
        return this.iSampleService.changeToReCorpus(reModels, bucketName);
    }

    @AuditLog(moduleName="\u8bad\u7ec3\u4efb\u52a1", eventDesc="\u67e5\u8be2", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.QUERY)
    @GetMapping(value={"/downloadTemplate"})
    public void downloadTemplate(@RequestParam String modelType, HttpServletResponse response) throws IOException {
        String fileName = new String();
        switch (modelType) {
            case "NER": {
                fileName = "ner_template.xls";
                break;
            }
            case "RE": {
                fileName = "re_template.xlsx";
                break;
            }
            case "PE": {
                fileName = "pe_template.xlsx";
            }
        }
        ClassPathResource classPathResource = new ClassPathResource("/template/" + fileName);
        File file = classPathResource.getFile();
        System.out.println("file:" + file.getPath());
        try {
            BufferedInputStream fis = new BufferedInputStream(new FileInputStream(file.getPath()));
            byte[] buffer = new byte[((InputStream)fis).available()];
            ((InputStream)fis).read(buffer);
            ((InputStream)fis).close();
            response.reset();
            response.addHeader("Content-Disposition", "attachment;filename=" + new String(fileName.getBytes()));
            response.addHeader("Content-Length", "" + file.length());
            BufferedOutputStream toClient = new BufferedOutputStream((OutputStream)response.getOutputStream());
            response.setContentType("application/octet-stream");
            ((OutputStream)toClient).write(buffer);
            ((OutputStream)toClient).flush();
            ((OutputStream)toClient).close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

