/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.kgbase.aj.controller;

import com.jxdinfo.hussar.core.base.controller.BaseController;
import com.jxdinfo.hussar.core.exception.HussarException;
import com.jxdinfo.hussar.kgbase.aj.model.ConceptAndRelationDTO;
import com.jxdinfo.hussar.kgbase.aj.service.AjGraphService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/ajGraph"})
public class AjGraphController
extends BaseController {
    @Autowired
    private AjGraphService ajGraphService;

    @GetMapping(value={"/getDocumentList"})
    public ApiResponse getDocumentList(@RequestParam Integer id) {
        try {
            return ApiResponse.success((Object)this.ajGraphService.getDocumentList(id));
        }
        catch (HussarException e) {
            e.printStackTrace();
            return ApiResponse.fail((String)e.getMessage());
        }
    }

    @GetMapping(value={"/deleteAjNode"})
    public ApiResponse deleteNode(@RequestParam Integer id) {
        try {
            return ApiResponse.success((Object)this.ajGraphService.deleteNode(id));
        }
        catch (HussarException e) {
            e.printStackTrace();
            return ApiResponse.fail((String)e.getMessage());
        }
    }

    @PostMapping(value={"/addAjNode"})
    public ApiResponse addNodeAndRelation(@RequestBody ConceptAndRelationDTO conceptAndRelationDTO) {
        try {
            return ApiResponse.success((Object)this.ajGraphService.addNodeAndRelation(conceptAndRelationDTO));
        }
        catch (HussarException e) {
            e.printStackTrace();
            return ApiResponse.fail((String)e.getMessage());
        }
    }

    @GetMapping(value={"/importAjExcel"})
    public ApiResponse importAjExcel(@RequestParam String fileName) {
        try {
            return ApiResponse.success((Object)this.ajGraphService.importAjExcel(fileName));
        }
        catch (HussarException e) {
            e.printStackTrace();
            return ApiResponse.fail((String)e.getMessage());
        }
    }

    @PostMapping(value={"/editNode"})
    public ApiResponse editNode(@RequestBody ConceptAndRelationDTO conceptAndRelationDTO) {
        try {
            return ApiResponse.success((Object)this.ajGraphService.editNode(conceptAndRelationDTO));
        }
        catch (HussarException e) {
            e.printStackTrace();
            return ApiResponse.fail((String)e.getMessage());
        }
    }

    @PostMapping(value={"/editRelation"})
    public ApiResponse editRelation(@RequestBody ConceptAndRelationDTO conceptAndRelationDTO) {
        try {
            return ApiResponse.success((Object)this.ajGraphService.editRelation(conceptAndRelationDTO));
        }
        catch (HussarException e) {
            e.printStackTrace();
            return ApiResponse.fail((String)e.getMessage());
        }
    }
}

