/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.kgbase.neo4j.repository;

import java.util.List;
import java.util.Map;
import org.springframework.data.neo4j.annotation.Query;
import org.springframework.data.neo4j.repository.Neo4jRepository;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository
public interface GraphQueryRepository
extends Neo4jRepository {
    @Query(value="match (a)-[r*0..1]->(b) where r <> [] and (id(a) in {ids} or id(b) in {ids}) return a,b,r limit 1000")
    public List<Map<String, Object>> getNodesAndRelationshipsWithId(@Param(value="ids") Integer[] var1);

    @Query(value="match (a)-[r*0..1]->(b) where a.name = {nodeName} return a,b,r limit 100")
    public List<Map<String, Object>> getNodesAndRelationshipsByNodeName(@Param(value="nodeName") String var1);

    @Query(value="match (a)-[r*0..1]->(b) return a,b,r limit 100")
    public List<Map<String, Object>> getNodesAndRelationships();

    @Query(value="call db.labels() yield label call apoc.cypher.run('match (:`'+label+'`) return count(*) as count',{}) yield value return label as type, value.count as number")
    public List<Map<String, Object>> getNodeLabels();

    @Query(value="match (a)-[r]-(b) where id(a) in {ids} with distinct r match (n1)-[r]->(n2) return n1,r,n2 ")
    public List<Map<String, Object>> getUnlimitedNodesAndRelationshipsWithId(@Param(value="ids") Integer[] var1);

    @Query(value="match (n) with id(n) as ids,apoc.node.degree(n) as ChildDegree order by ChildDegree desc limit 2000 return ids")
    public List<Integer> getImportNodes();

    @Query(value="match (a)-[r]-(b) where id(a) in {ids} and id(b) in {ids} with distinct r match (n1)-[r]->(n2) return n1,r,n2 ")
    public List<Map<String, Object>> getUnlimitedNodesAndRelationshipsWithId2(@Param(value="ids") Integer[] var1);

    @Query(value="match ()-[r]->() return distinct type(r) as type")
    public List<Map<String, Object>> getRelationshipTypes();

    @Query(value="match p=(a)-[r]-(b) where id(a) in {ids} and id(b) in {ids} with collect(distinct id(a)) as idCollects match (n) where id(n) in {ids} and not id(n) in idCollects return n")
    public List<Map<String, Object>> getSingleNodesWithId(@Param(value="ids") Integer[] var1);

    @Query(value="match (a)-[r*1]-(b) where id(a)={id} return a,b,r limit 300")
    public List<Map<String, Object>> getDirectPathByNode(@Param(value="id") Long var1);

    @Query(value="match (a) where id(a)={id} return a")
    public List<Map<String, Object>> getSingleNode(@Param(value="id") Long var1);
}

