/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.kgbase.neo4j.repository;

import com.jxdinfo.hussar.kgbase.application.instancemanage.model.dto.InstanceNodeDTO;
import java.util.HashMap;
import java.util.List;
import org.springframework.data.neo4j.annotation.Query;
import org.springframework.data.neo4j.repository.Neo4jRepository;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository
public interface InstanceManageRepository
extends Neo4jRepository {
    @Query(value="MATCH (n) WHERE labels(n)[0] = {nodeType} RETURN n ORDER BY n.createTime,n.businessId,id(n) DESC ")
    public List<HashMap<String, Object>> getNodeListByNodeType(@Param(value="nodeType") String var1);

    @Query(value="MATCH (n) WHERE n.name =~('.*'+:#{#dto.name}+'.*') and labels(n)[0] IN :#{#dto.nodeTypes} RETURN n ORDER BY n.createTime,n.businessId,id(n) DESC skip :#{#dto.current} limit :#{#dto.size}")
    public List<HashMap<String, Object>> getNodeListByNodeType(@Param(value="dto") InstanceNodeDTO var1);

    @Query(value="MATCH (n)-[r]-(m) where id(r)= {id} WITH r, [k in keys(r) where id(r)= {id} and not k in {defaultProps}] as keys CALL apoc.create.removeRelProperties(r, keys) YIELD rel return r")
    public List<HashMap<String, Object>> deleteRelationPropsExceptDefault(@Param(value="id") Integer var1, @Param(value="defaultProps") String[] var2);

    @Query(value="MATCH (n) WHERE labels(n)[0] = {nodeType} and (n.createTime > {searchtime} or n.updateTime > {searchtime})  RETURN n ORDER BY n.createTime,n.businessId,id(n) DESC")
    public List<HashMap<String, Object>> getNodeListByNodeTypeAndTime(@Param(value="nodeType") String var1, @Param(value="searchtime") String var2);

    @Query(value="MATCH (n)-[r]-(m) WHERE id(r) in {idArr} DELETE r")
    public void deleteRelations(@Param(value="idArr") int[] var1);

    @Query(value="match(n) where not labels(n)[0] in {labelArr} return distinct labels(n)[0] as nodeType order by nodeType")
    public List<HashMap<String, Object>> getNodeTypesInNeo4j(@Param(value="labelArr") String[] var1);

    @Query(value="MATCH p=(n)-[r]->(m) where id(r) = {id} return type(r)")
    public String getRelationNameById(@Param(value="id") Integer var1);

    @Query(value="CALL db.propertyKeys() YIELD propertyKey AS key MATCH (n)-[r]-(m) WHERE id(r)={id} and r[key] IS NOT NULL RETURN distinct key, r[key] AS value,apoc.meta.type(r[key]) as columnType")
    public List<HashMap<String, Object>> getRelationProps(@Param(value="id") Integer var1);

    @Query(value="MATCH p=(n)-[r]->(m) where id(r) = {id} return r")
    public List<HashMap<String, Object>> getRelationById(@Param(value="id") Integer var1);

    @Query(value="MATCH (n) WHERE id(n) in {idArr} DELETE n")
    public void deleteNodes(@Param(value="idArr") int[] var1);

    @Query(value="CALL db.propertyKeys() YIELD propertyKey AS key MATCH (n) WHERE id(n)={id} and n[key] IS NOT NULL RETURN key, n[key] AS value,apoc.meta.type(n[key]) as columnType")
    public List<HashMap<String, Object>> getNodeProps(@Param(value="id") Integer var1);

    @Query(value="MATCH (n) WHERE n.name =~('.*'+:#{#dto.name}+'.*') RETURN n ORDER BY n.createTime,n.businessId,id(n) DESC skip :#{#dto.current} limit :#{#dto.size}")
    public List<HashMap<String, Object>> getNodeList(@Param(value="dto") InstanceNodeDTO var1);

    @Query(value="MATCH (n) WHERE n.name =~('.*'+:#{#dto.name}+'.*') and labels(n)[0] IN :#{#dto.nodeTypes} RETURN count(*) AS COUNT")
    public Integer getNodeCountByNodeType(@Param(value="dto") InstanceNodeDTO var1);

    @Query(value="MATCH (n) where id(n) = {id} return n")
    public List<HashMap<String, Object>> getNodeById(@Param(value="id") Integer var1);

    @Query(value="MATCH (n)-[r]-(m) WHERE id(n) in {idArr} DELETE r")
    public void deleteRelationByNodes(@Param(value="idArr") int[] var1);

    @Query(value="MATCH (n) where id(n) = {id} return n.name")
    public String getNodeNameById(@Param(value="id") Integer var1);

    @Query(value="MATCH (n) where id(n)= {id} WITH n, [k in keys(n) where id(n)= {id} and not k in {defaultProps}] as keys CALL apoc.create.removeProperties(n, keys) YIELD node return n")
    public List<HashMap<String, Object>> deleteNodePropsExceptDefault(@Param(value="id") Integer var1, @Param(value="defaultProps") String[] var2);

    @Query(value="MATCH (n) WHERE n.name =~('.*'+:#{#dto.name}+'.*') RETURN count(*) AS COUNT")
    public Integer getNodeCount(@Param(value="dto") InstanceNodeDTO var1);
}

