/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.kgbase.neo4j.repository;

import java.util.List;
import java.util.Map;
import org.springframework.data.neo4j.annotation.Query;
import org.springframework.data.neo4j.repository.Neo4jRepository;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository
public interface ComputingSimilarityRepository
extends Neo4jRepository {
    @Query(value="MATCH (n) RETURN distinct labels(n)")
    public List<String> getAllLabel();

    @Query(value="call db.index.fulltext.createNodeIndex({indexName},{labels},{properties})")
    public void createFullIndex(@Param(value="indexName") String var1, @Param(value="labels") String[] var2, @Param(value="properties") String[] var3);

    @Query(value="MATCH (n),p=(n)-[]-() where id(n)={id} return count(p)")
    public int getRelationshioCount(@Param(value="id") Integer var1);

    @Query(value="match(n) where labels(n)=[{type}] with apoc.text.bytes(n.name) as  s, n match(m) where labels(m)=[{type}] with apoc.text.bytes(m.name) as e, s ,n, m, id(n) as sid, id(m) as  eid where sid <> eid RETURN sid, eid,  algo.similarity.jaccard(s, e) AS similarity  order by similarity desc  limit 30")
    public List<Map<String, Object>> getAlgorithmNameSimilar(@Param(value="type") String var1);

    @Query(value="match(n)-[r]-() where labels(n)=[{type}] CALL db.index.fulltext.queryRelationships('allRelationshipIndex', apoc.text.replace(r.name,'[\\\\p{P}+~$`^=|<>\uff5e\uff40\uff04\uff3e\uff0b\uff1d\uff5c\uff1c\uff1e\uffe5\u00d7 -]','')) YIELD relationship,score with startNode(relationship) as startnode,type(relationship) as r,endNode(relationship) as endnode, score return id(startnode),startnode,labels(startnode) as startlabel,id(endnode),endnode,labels(endnode) as endlabel, score order by score desc limit {limit}")
    public List<Map<String, Object>> getRelationSimilar(@Param(value="type") String var1, @Param(value="limit") Integer var2);

    @Query(value="match (n)-[r]-() where id(n)={id} return n, r")
    public List<Map<String, Object>> getNodeAnRelationshipById(@Param(value="id") Integer var1);

    @Query(value="call db.index.fulltext.drop({indexName})")
    public void deleteFullIndexByName(@Param(value="indexName") String var1);

    @Query(value="match (n) where id(n)={id} return n.name as name, labels(n)[0] as lab")
    public List<Map<String, Object>> getNodeNameById(@Param(value="id") Integer var1);

    @Query(value="MATCH (n)-[r1]-() where labels(n)=[{type}] with n, collect(id(r1)) AS pn MATCH (n2)-[r2]-() where labels(n2)=[{type}] with n, pn,  n2, collect(id(r2)) AS pn2 where n <> n2 RETURN n.name AS from,n2.name AS to, algo.similarity.jaccard(pn, pn2) AS similarity order by similarity desc limit 30")
    public List<Map<String, Object>> getRelationSimilar(@Param(value="type") String var1);

    @Query(value="match(n) where labels(n)=[{type}]  call db.index.fulltext.queryNodes('allFullIndex',n.{attribute}) yield node,score  where labels(n)[0] = labels(node)[0] and id(n)<>id(node)  return labels(n)[0] as nodeType,n.{attribute} as {attribute}1,node.{attribute} as {attribute}2,score order by score desc")
    public List<Map<String, Object>> getAttributeSimilar(@Param(value="type") String var1, @Param(value="attribute") String var2);

    @Query(value="match (n) where labels(n)=[{type}]   call db.index.fulltext.queryNodes('allFullIndex',apoc.text.replace(n.name,'[\\\\p{P}+~$`^=|<>\uff5e\uff40\uff04\uff3e\uff0b\uff1d\uff5c\uff1c\uff1e\uffe5\u00d7 -]','')) yield node,score  where labels(n)[0] = labels(node)[0] and id(n)<>id(node) return labels(n)[0] as nodeType, id(n) as id1, n.name as name1,id(node) as id2, node.name as name2, score order by score desc limit {limit}")
    public List<Map<String, Object>> getNameSimilar(@Param(value="type") String var1, @Param(value="limit") Integer var2);

    @Query(value="MATCH (n) where id(n)={startId} with n  match(m) where id(m)={endId} merge (n)-[:`{type}`]->(m)")
    public void careteRelation(@Param(value="startId") Integer var1, @Param(value="endId") Integer var2, @Param(value="type") String var3);

    @Query(value="match (n) where id(n)={id} with n match (n)-[r]-() delete r")
    public void deleteByNodeId(@Param(value="id") Integer var1);

    @Query(value="match (n1)-[r1]->(m1) where labels(n1)=[{type}] with n1, count(m1) as intersection, collect(m1.name) as collection match (n2)-[r2]->(m2) where labels(n2)=[{type}] with n1, intersection,  collection,  n2, count(m2) as intersectionm2, collect(m2.name) as collectionm2 where id(n1) <> id(n2) and SIZE(collection) >3 and SIZE(collectionm2) > 3 with n1, intersection,collection,  n2, intersectionm2, collectionm2, collection+filter(x IN collectionm2 where not x IN collection) as uni return labels(n1)[0] as nodeType, id(n1) as id1, n1.name as name1, id(n2) as id2, n2.name as name2, ((1.0*intersection)/SIZE(uni)) as score order by score DESC limit {limit}")
    public List<Map<String, Object>> getRelationshipJaccard(@Param(value="type") String var1, @Param(value="limit") Integer var2);

    @Query(value="match (n) where id(n)={id} return n")
    public List<Map<String, Object>> getNodeInfoById(@Param(value="id") Integer var1);

    @Query(value=" match(n) where id(n)={id} delete n")
    public void deleteNode(@Param(value="id") Integer var1);
}

