/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.kgbase.neo4j.config;

import javax.sql.DataSource;
import org.neo4j.ogm.config.ClasspathConfigurationSource;
import org.neo4j.ogm.config.Configuration;
import org.neo4j.ogm.config.ConfigurationSource;
import org.neo4j.ogm.session.SessionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.domain.EntityScan;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.data.neo4j.repository.config.EnableNeo4jRepositories;
import org.springframework.data.neo4j.transaction.Neo4jTransactionManager;
import org.springframework.data.transaction.ChainedTransactionManager;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.transaction.PlatformTransactionManager;

@Configuration
@EnableNeo4jRepositories(value={"com.jxdinfo.hussar.kgbase.neo4j.repository"})
@EntityScan(basePackages={"com.jxdinfo.hussar.kgbase.neo4j.entity"})
public class Neo4jConfig {
    @Bean
    public SessionFactory sessionFactory() {
        return new SessionFactory(this.configuration(), new String[]{"com.jxdinfo.hussar.kgbase.neo4j.entity"});
    }

    @Bean
    public org.neo4j.ogm.config.Configuration configuration() {
        ClasspathConfigurationSource properties = new ClasspathConfigurationSource("neo4j.properties");
        return new Configuration.Builder((ConfigurationSource)properties).build();
    }

    @Bean(value={"neo4jTransactionManager"})
    public Neo4jTransactionManager transactionManager() {
        return new Neo4jTransactionManager(this.sessionFactory());
    }

    @Bean(value={"transactionManager"})
    @Primary
    public DataSourceTransactionManager transactionManager(DataSource dataSource) {
        return new DataSourceTransactionManager(dataSource);
    }

    @Autowired
    @Bean(name={"multiTransactionManager"})
    public PlatformTransactionManager multiTransactionManager(Neo4jTransactionManager neo4jTransactionManager, DataSourceTransactionManager mysqlTransactionManager) {
        return new ChainedTransactionManager(new PlatformTransactionManager[]{neo4jTransactionManager, mysqlTransactionManager});
    }
}

