/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.strategy.docParsing.impl;

import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.strategy.docHander.model.Element;
import com.jxdinfo.hussar.strategy.docHander.model.TreeNode;
import com.jxdinfo.hussar.strategy.docParsing.ParsingStrategy;
import com.jxdinfo.hussar.strategy.dto.TitleRegular;
import com.jxdinfo.hussar.strategy.dto.TitleRegularList;
import com.jxdinfo.hussar.strategy.util.CommonUtil;
import com.jxdinfo.hussar.strategy.util.SplittingStrategyUtil;
import com.jxdinfo.hussar.strategy.util.TextCleanUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="LocalParsingForTxt")
public class LocalParsingForTxt
implements ParsingStrategy {
    private static final Logger logger = LoggerFactory.getLogger(LocalParsingForTxt.class);

    @Override
    public HashMap<String, LinkedHashMap<String, String>> fileToMap(File file, HashMap<String, Object> params) {
        String fileName = file.getName();
        String titleAnalysisRegular = (String)params.get("TitleAnalysisRegular");
        Integer minTitleSplit = (Integer)params.get("MinTitleSplit");
        String preprocess = (String)params.get("preprocess");
        String preRegular = (String)params.get("preRegular");
        LinkedHashMap<Object, Object> patterMap = new LinkedHashMap();
        if (HussarUtils.isNotEmpty((Object)titleAnalysisRegular)) {
            TitleRegularList listRegular = SplittingStrategyUtil.getListRegular(titleAnalysisRegular);
            for (TitleRegular titleRegular : listRegular.getTitleRegulars()) {
                patterMap.put(titleRegular.getRegular(), titleRegular.getSeq());
            }
        } else {
            patterMap = CommonUtil.getDefaultPatternMap();
        }
        List<String> contents = this.readAndProcessFile(file, preprocess, preRegular);
        int id = 0;
        TreeNode root = new TreeNode(new Element(id, fileName, "-1", 0));
        CommonUtil.assembleTree(root, 0, contents, patterMap);
        String prefix = "\u4ee5\u4e0b\u662f " + fileName + " \u7684\u6587\u6863\u8bf4\u660e\u3002\u8be5\u90e8\u5206\u5185\u5bb9\u5173\u4e8e";
        LinkedHashMap<List<Element>, List<List<Element>>> contentsMap = new LinkedHashMap<List<Element>, List<List<Element>>>();
        root.printTree(root.getRoot(), "", true);
        root.findLeafNodePathsByType(root.getRoot(), new ArrayList<Element>(), Math.min(minTitleSplit, root.maxDepth(root)), new ArrayList<List<Element>>(), contentsMap);
        return CommonUtil.treeToMap(fileName, Math.min(minTitleSplit, root.maxDepth(root)), contentsMap, prefix);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<String> readAndProcessFile(File file, String preprocess, String preRegular) {
        try (BufferedReader reader = new BufferedReader(new FileReader(file));){
            String line;
            ArrayList<String> processedLines = new ArrayList<String>();
            while ((line = reader.readLine()) != null) {
                TextCleanUtil.cleanTxt(line, preprocess, preRegular);
                processedLines.add(line);
            }
            ArrayList<String> arrayList = processedLines;
            return arrayList;
        }
        catch (IOException e) {
            e.printStackTrace();
            return new ArrayList<String>();
        }
    }
}

