/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.strategy.docHander.impl;

import com.jxdinfo.hussar.common.util.IqaFileUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.strategy.docHander.FileHandler;
import com.jxdinfo.hussar.strategy.docHander.impl.WordExtractorServiceImpl;
import com.jxdinfo.hussar.strategy.docHander.model.Element;
import com.jxdinfo.hussar.strategy.docHander.model.RegexModel;
import com.jxdinfo.hussar.strategy.docHander.model.TreeNode;
import com.jxdinfo.hussar.strategy.docHander.model.WordNumbering;
import com.jxdinfo.hussar.strategy.docHander.model.WordNumberingValue;
import com.jxdinfo.hussar.strategy.docHander.model.WordTable;
import com.jxdinfo.hussar.strategy.docHander.model.WordTableCell;
import com.jxdinfo.hussar.strategy.util.CommonUtil;
import com.jxdinfo.hussar.strategy.util.LatexUtil;
import com.jxdinfo.hussar.strategy.util.SplittingStrategyUtil;
import com.jxdinfo.hussar.strategy.util.TextCleanUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.poi.xwpf.usermodel.BodyElementType;
import org.apache.poi.xwpf.usermodel.IBodyElement;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFPicture;
import org.apache.poi.xwpf.usermodel.XWPFPictureData;
import org.apache.poi.xwpf.usermodel.XWPFRun;
import org.jodconverter.office.OfficeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class DocHandlerImpl
implements FileHandler {
    private static final Logger logger = LoggerFactory.getLogger(DocHandlerImpl.class);
    protected static final String TABLE_SPECIAL_CHARACTERS = "[\u0007|\\t|\\n|\u00a0+]";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HashMap<String, LinkedHashMap<String, String>> analysis(File file, String fileName, String splitMode, int splitLevel, LinkedHashMap<String, Integer> patterMap, String preprocess, String preRegular) {
        HashMap<WordNumbering, WordNumberingValue> numberingMap = new HashMap<WordNumbering, WordNumberingValue>();
        InputStream inputStream = null;
        List<String> list = SplittingStrategyUtil.getList(splitMode);
        List<Object> wordTableList = new ArrayList();
        int tableIndex = 0;
        String paragraphText = null;
        WordExtractorServiceImpl wordExtractorService = new WordExtractorServiceImpl();
        try {
            inputStream = Files.newInputStream(file.toPath(), new OpenOption[0]);
            wordTableList = wordExtractorService.adaptDocxToPdfTable(inputStream).getWordTableList();
            inputStream = Files.newInputStream(file.toPath(), new OpenOption[0]);
            XWPFDocument document = new XWPFDocument(inputStream);
            List bodyElements = document.getBodyElements();
            int pLevel = -1;
            int id = 0;
            TreeNode root = new TreeNode(new Element(id, fileName, "-1", 0));
            TreeNode picNode = null;
            for (IBodyElement bodyElement : bodyElements) {
                if (bodyElement.getElementType().equals((Object)BodyElementType.PARAGRAPH)) {
                    String content;
                    XWPFParagraph xwpfParagraph = (XWPFParagraph)bodyElement;
                    String numberingObj = CommonUtil.replacePercent(numberingMap, xwpfParagraph);
                    String extensionName = IqaFileUtil.getExtensionName((String)fileName);
                    paragraphText = "doc".equals(extensionName) ? xwpfParagraph.getParagraphText() : LatexUtil.parseParagraph(xwpfParagraph);
                    TextCleanUtil.cleanTxt(paragraphText, preprocess, preRegular);
                    if (HussarUtils.isNotEmpty((Object)numberingObj)) {
                        paragraphText = numberingObj + paragraphText;
                    }
                    boolean isPic = false;
                    List runs = xwpfParagraph.getRuns();
                    for (XWPFRun run : runs) {
                        List embeddedPictures = run.getEmbeddedPictures();
                        for (XWPFPicture embeddedPicture : embeddedPictures) {
                            XWPFPictureData picData = embeddedPicture.getPictureData();
                            if (picData == null) continue;
                            byte[] imageData = picData.getData();
                            String randomUUID = HussarUtils.randomUUID();
                            picNode = new TreeNode(new Element(id++, paragraphText + "<picSeparate/>" + randomUUID + "<picSeparate/>" + Base64.getEncoder().encodeToString(imageData), "3", 9));
                            root.addChild(picNode);
                            isPic = true;
                        }
                    }
                    if (isPic || HussarUtils.isEmpty((Object)paragraphText)) continue;
                    int level = 0;
                    RegexModel regexModel = new RegexModel();
                    if (list.contains("0")) {
                        level = CommonUtil.getTitleLevel(document, xwpfParagraph);
                    }
                    if (level == 0 && list.contains("1") && HussarUtils.isNotEmpty(patterMap)) {
                        regexModel = CommonUtil.getPatterLevel(paragraphText, patterMap);
                        level = regexModel.getLevel();
                        paragraphText = regexModel.getTitle();
                    }
                    if (level == 0) {
                        root.addChild(new TreeNode(new Element(id++, paragraphText, "0", 9)));
                    } else if (level > pLevel) {
                        TreeNode treeNode = new TreeNode(new Element(id++, paragraphText, "0", level));
                        root.addChild(treeNode);
                        root = treeNode;
                        pLevel = level;
                    } else if (level == pLevel) {
                        TreeNode child = new TreeNode(new Element(id++, paragraphText, "0", level));
                        root.getParentNode().addChild(child);
                        root = child;
                    } else {
                        TreeNode node = new TreeNode(new Element(id++, paragraphText, "0", level));
                        while (HussarUtils.isNotEmpty((Object)root.getParentNode())) {
                            if (level < root.getParentNode().getData().getLevel()) {
                                root = root.getParentNode();
                                continue;
                            }
                            if (level == root.getParentNode().getData().getLevel()) {
                                root = HussarUtils.isNotEmpty((Object)root.getParentNode().getParentNode()) ? root.getParentNode().getParentNode() : root.getParentNode();
                                root.addChild(node);
                                break;
                            }
                            root = root.getParentNode();
                            root.addChild(node);
                            break;
                        }
                        root = node;
                        pLevel = level;
                    }
                    if (!list.contains("1") || !HussarUtils.isNotEmpty(patterMap) || !HussarUtils.isNotEmpty((Object)(content = regexModel.getContent()))) continue;
                    root.addChild(new TreeNode(new Element(id++, content, "0", 9)));
                    continue;
                }
                if (!bodyElement.getElementType().equals((Object)BodyElementType.TABLE)) continue;
                List<WordTableCell> wordTableCellList = ((WordTable)wordTableList.get(tableIndex)).getWordTableCellList();
                int maxCol = -1;
                int maxRow = -1;
                for (WordTableCell wordTableCell : wordTableCellList) {
                    if (wordTableCell.getRow() == 0) {
                        maxCol = wordTableCell.getColspan() + maxCol;
                    }
                    if (wordTableCell.getCol() != 0) continue;
                    maxRow = wordTableCell.getRowspan() + maxRow;
                }
                HashMap rowMaps = new HashMap();
                for (int row = 0; row <= maxRow; ++row) {
                    ArrayList<Object> cols = new ArrayList<Object>();
                    for (int i = 0; i <= maxCol; ++i) {
                        cols.add(null);
                    }
                    rowMaps.put(row, cols);
                }
                for (WordTableCell wordTableCell : wordTableCellList) {
                    Integer rowspan = wordTableCell.getRowspan();
                    Integer colspan = wordTableCell.getColspan();
                    Integer row = wordTableCell.getRow();
                    Integer col = wordTableCell.getCol();
                    Integer k = 0;
                    while (k < rowspan) {
                        List cols = (List)rowMaps.get(row + k);
                        for (int i = 0; i < colspan; ++i) {
                            String colString = "<col=" + (col + i + 1) + ">" + TextCleanUtil.cleanTxt(wordTableCell.getText(), preprocess, preRegular) + "</col>";
                            cols.set(col + i, colString);
                        }
                        Integer n = k;
                        Integer n2 = k = Integer.valueOf(k + 1);
                    }
                }
                StringBuilder tableString = new StringBuilder("<table>");
                for (int i = 0; i < rowMaps.size(); ++i) {
                    tableString.append("<row=").append(i + 1).append(">");
                    for (String col : (List)rowMaps.get(i)) {
                        tableString.append(col);
                    }
                    tableString.append("</rowend>");
                }
                tableString.append("</table>");
                root.addChild(new TreeNode(new Element(id++, "\u3010\u8868\u683ctable\u3011\u8fd9\u662f\u4e00\u4e2a" + rowMaps.size() + "\u884c" + ((List)rowMaps.get(0)).size() + "\u5217\u7684\u8868\u683c\uff0c\u5b58\u5728\u884c\u5408\u5e761\u3001row\u4ee3\u8868\u884c\u6570\uff0ccol\u4ee3\u8868\u5355\u5143\u683c\u6240\u5728\u5217\u6570 \uff0c\u6bcf\u5bf9<row></rowend>\u6807\u7b7e\u5305\u88f9\u4e00\u884c\u5185\u5bb9\uff0ccol\u503c\u76f8\u540c\u7684\u5355\u5143\u683c\u4e3a\u4e00\u5217\u30022\u3001\u6bcf\u4e2a\u6807\u7b7e<col></col>\u5305\u88f9\u4e00\u4e2a\u5355\u5143\u683c\u3002\u8868\u683c\u5982\u4e0b\uff1a" + tableString, "2", 9)));
                ++tableIndex;
            }
            String prefix = "\u4ee5\u4e0b\u662f " + fileName + " \u7684\u6587\u6863\u8bf4\u660e\u3002\u8be5\u90e8\u5206\u5185\u5bb9\u5173\u4e8e";
            LinkedHashMap<List<Element>, List<List<Element>>> contentsMap = new LinkedHashMap<List<Element>, List<List<Element>>>();
            root.printTree(root.getRoot(), "", true);
            int depth = Math.min(root.maxDepth(root.getRoot()), splitLevel);
            root.findLeafNodePathsByType(root.getRoot(), new ArrayList<Element>(), depth, new ArrayList<List<Element>>(), contentsMap);
            HashMap<String, LinkedHashMap<String, String>> hashMap = CommonUtil.treeToMap(fileName, depth, contentsMap, prefix);
            return hashMap;
        }
        catch (Exception e) {
            logger.error("docx\u6587\u6863+\u3010" + fileName + "\u3011\u52a0\u8f7d\u5f02\u5e38->" + paragraphText + e);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    logger.error("\u6d41\u5173\u95ed\u52a0\u8f7d\u5f02\u5e38\uff01" + e);
                }
            }
        }
        return null;
    }

    public static void main(String[] args) throws IOException, OfficeException {
        String filePath = "F:\\docx.docx";
        File file = new File(filePath);
        String fileName = "test";
        String splitMode = "[\"1\",\"0\"]";
        int splitLevel = 3;
        LinkedHashMap<String, Integer> patterMap = new LinkedHashMap<String, Integer>();
        patterMap.put("^\u7b2c[^\u7ae0]+\u7ae0.*", 2);
        patterMap.put("^\\d+\\.\\d+ .*", 3);
        patterMap.put("^\\d+\\.\\d+\\.\\d+ .*", 4);
        DocHandlerImpl mdHandler = new DocHandlerImpl();
        HashMap<String, LinkedHashMap<String, String>> result = mdHandler.analysis(file, fileName, splitMode, splitLevel, patterMap, null, null);
        System.out.println();
    }
}

