/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.strategy.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.github.houbb.opencc4j.core.impl.ZhConvertBootstrap;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;

public class TextCleanUtil {
    public static void main(String[] args) {
        String txt = "test text with \u4fe1\u606f and \u90ae\u4ef6@example.com and 123.456.7890 and \u7e41\u9ad4 \u8f6c \u7b80\u4f53<html><body>test text</body></html>https://www.example.com \u548c http://example.org\u3002";
        String preprocess = "[\"0\", \"1\", \"5\"]";
        String preRegular = "{\"%s\":\"%s\"}";
        String s = TextCleanUtil.convertTraditionalToSimplified(txt);
        System.out.println("s = " + s);
        HashMap<String, String> replaceMap = new HashMap<String, String>();
        replaceMap.put("test", "TEST");
        String result = TextCleanUtil.cleanTxt(txt, preprocess, JSON.toJSONString(replaceMap));
        System.out.println("result = " + result);
    }

    public static String cleanTxt(String txt, String preprocess, String preRegular) {
        if (HussarUtils.isEmpty((Object)preprocess)) {
            return txt;
        }
        List list = JSON.parseArray((String)preprocess, String.class);
        if (list.contains("0")) {
            txt = TextCleanUtil.normalizeWhitespace(txt);
        }
        if (list.contains("1")) {
            txt = TextCleanUtil.removeSensitiveInformation(txt);
        }
        if (list.contains("2")) {
            txt = TextCleanUtil.replacePercent(txt, (Map)JSON.parseObject((String)preRegular, (TypeReference)new TypeReference<Map<String, String>>(){}, (Feature[])new Feature[0]));
        }
        if (list.contains("3")) {
            txt = TextCleanUtil.removeUnicode(txt);
        }
        if (list.contains("4")) {
            txt = TextCleanUtil.convertTraditionalToSimplified(txt);
        }
        if (list.contains("5")) {
            txt = TextCleanUtil.removeHtmlTags(txt);
        }
        if (list.contains("6")) {
            txt = TextCleanUtil.removeUnprintableCharacters(txt);
        }
        return txt;
    }

    public static String normalizeWhitespace(String str) {
        return str.replaceAll("[\\p{Zs}]", " ");
    }

    public static String removeSensitiveInformation(String input) {
        String emailPattern = "\\b[A-Za-z0-9._%+-]+@[A-Za-z0-9.-]+\\.[A-Za-z]{2,}\\b";
        input = input.replaceAll(emailPattern, "[EMAIL]");
        String ipPattern = "\\b(?:\\d{1,3}\\.){3}\\d{1,3}\\b";
        input = input.replaceAll(ipPattern, "[IP]");
        String phonePattern = "\\b\\d{3}[-.]?\\d{3}[-.]?\\d{4}\\b";
        input = input.replaceAll(phonePattern, "[PHONE]");
        String urlPattern = "https?://[a-zA-Z0-9.-]+(?:/[a-zA-Z0-9%_./-]*)?";
        input = input.replaceAll(urlPattern, "[URL]");
        return input;
    }

    public static String replacePercent(String input, Map<String, String> map) {
        for (String k : map.keySet()) {
            if (!input.contains(k)) continue;
            input = input.replaceAll(k, map.get(k));
        }
        return input;
    }

    public static String removeUnicode(String str) {
        return str.replaceAll("[\\p{C}]+", "");
    }

    public static String convertTraditionalToSimplified(String str) {
        ZhConvertBootstrap zhConvertBootstrap = ZhConvertBootstrap.newInstance();
        return zhConvertBootstrap.toSimple(str);
    }

    public static String removeHtmlTags(String str) {
        Document parse = Jsoup.parse((String)str);
        return parse.text();
    }

    public static String removeUnprintableCharacters(String str) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < str.length(); ++i) {
            char ch = str.charAt(i);
            if (ch < ' ' || ch > '\u00a0') continue;
            sb.append(ch);
        }
        return sb.toString();
    }
}

