/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.strategy.docParsing.impl;

import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.strategy.docParsing.ParsingStrategy;
import com.jxdinfo.hussar.support.exception.HussarException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="LocalParsingForXlsx")
public class LocalParsingForXlsx
implements ParsingStrategy {
    private static final Logger logger = LoggerFactory.getLogger(LocalParsingForXlsx.class);

    @Override
    public HashMap<String, LinkedHashMap<String, String>> fileToMap(File file, HashMap<String, Object> params) {
        String type = (String)params.get("type");
        String name = file.getName();
        XSSFWorkbook wk = null;
        HashMap<String, LinkedHashMap<String, String>> resultMap = new HashMap<String, LinkedHashMap<String, String>>();
        try {
            FileInputStream is = new FileInputStream(file);
            wk = new XSSFWorkbook((InputStream)is);
            if (HussarUtils.isNotEmpty((Object)wk)) {
                if ("4".equals(type)) {
                    Integer paragraphLength = Integer.valueOf(params.get("paragraphLength").toString());
                    resultMap = this.parsingByLength((Workbook)wk, name, paragraphLength);
                }
                if ("3".equals(type)) {
                    resultMap = this.parsingBySheet((Workbook)wk, name);
                }
            }
        }
        catch (IOException e) {
            throw new HussarException("xlsx\u6587\u6863+\u3010" + name + "\u3011\u52a0\u8f7d\u5f02\u5e38\uff01" + e);
        }
        finally {
            try {
                if (wk != null) {
                    wk.close();
                }
            }
            catch (IOException e) {
                logger.error("\u5173\u95ed\u6d41\u5f02\u5e38", (Throwable)e);
            }
        }
        return resultMap;
    }

    public HashMap<String, LinkedHashMap<String, String>> parsingByLength(Workbook wk, String fileName, Integer paragraphLength) {
        HashMap<String, LinkedHashMap<String, String>> resultMap = new HashMap<String, LinkedHashMap<String, String>>();
        LinkedHashMap<String, String> textMap = new LinkedHashMap<String, String>();
        int sheetIndex = 0;
        StringBuilder allContent = new StringBuilder();
        boolean sectionIndex = false;
        for (Sheet sheet : wk) {
            String sheetName = sheet.getSheetName();
            int lastRowNum = sheet.getLastRowNum();
            if (lastRowNum <= -1) continue;
            if (++sheetIndex > 1) {
                allContent.append("\n");
            }
            allContent.append("\u5de5\u4f5c\u8868").append(sheetIndex).append("_").append(sheetName).append(":");
            for (int rowNum = 1; rowNum <= lastRowNum; ++rowNum) {
                StringBuilder rowContent = new StringBuilder();
                Row row = sheet.getRow(rowNum);
                if (!HussarUtils.isNotEmpty((Object)row)) continue;
                rowContent.append("\n");
                allContent.append("\n");
                for (int cellNum = 0; cellNum <= row.getLastCellNum(); ++cellNum) {
                    String cellValue = "";
                    Cell cell = row.getCell(cellNum, Row.MissingCellPolicy.RETURN_BLANK_AS_NULL);
                    if (HussarUtils.isEmpty((Object)cell)) {
                        cellValue = "\u7a7a";
                    } else {
                        cell.setCellType(CellType.STRING);
                        cellValue = cell.getStringCellValue();
                    }
                    rowContent.append("|").append(cellValue);
                    allContent.append("|").append(cellValue);
                }
            }
        }
        List<String> paragraphs = this.splitIntoParagraphs(allContent.toString(), paragraphLength);
        for (int i = 0; i < paragraphs.size(); ++i) {
            textMap.put("\u4ee5\u4e0b\u662f " + fileName + " \u7684\u6587\u6863\u8bf4\u660e_" + (i + 1), paragraphs.get(i));
            resultMap.put("0", textMap);
        }
        LinkedHashMap picTreeMap = new LinkedHashMap();
        resultMap.put("3", picTreeMap);
        return resultMap;
    }

    public List<String> splitIntoParagraphs(String text, Integer paragraphLength) {
        String[] lines;
        ArrayList<String> paragraphs = new ArrayList<String>();
        StringBuilder currentParagraph = new StringBuilder();
        for (String line : lines = text.split("\n")) {
            if (currentParagraph.length() + line.length() + 2 <= paragraphLength) {
                if (currentParagraph.length() > 0) {
                    currentParagraph.append("\n");
                }
                currentParagraph.append(line);
                continue;
            }
            if (currentParagraph.length() > 0) {
                paragraphs.add(currentParagraph.toString());
                currentParagraph = new StringBuilder();
            }
            currentParagraph.append(line);
        }
        if (currentParagraph.length() > 0) {
            paragraphs.add(currentParagraph.toString());
        }
        return paragraphs;
    }

    public HashMap<String, LinkedHashMap<String, String>> parsingBySheet(Workbook wk, String fileName) {
        HashMap<String, LinkedHashMap<String, String>> resultMap = new HashMap<String, LinkedHashMap<String, String>>();
        LinkedHashMap<String, String> textMap = new LinkedHashMap<String, String>();
        int sheetIndex = 0;
        for (Sheet sheet : wk) {
            ++sheetIndex;
            StringBuilder sb = new StringBuilder();
            String sheetName = sheet.getSheetName();
            int lastRowNum = sheet.getLastRowNum();
            if (lastRowNum <= -1) continue;
            for (int rowNum = 1; rowNum <= lastRowNum; ++rowNum) {
                Row row = sheet.getRow(rowNum);
                if (!HussarUtils.isNotEmpty((Object)row)) continue;
                sb.append("\n");
                for (int cellNum = 0; cellNum <= row.getLastCellNum(); ++cellNum) {
                    String cellValue = "";
                    Cell cell = row.getCell(cellNum, Row.MissingCellPolicy.RETURN_BLANK_AS_NULL);
                    if (HussarUtils.isEmpty((Object)cell)) {
                        cellValue = "\u7a7a";
                    } else {
                        cell.setCellType(CellType.STRING);
                        cellValue = cell.getStringCellValue();
                    }
                    sb.append("|").append(cellValue);
                }
            }
            String title = "\u4ee5\u4e0b\u662f " + fileName + " \u7684\u6587\u6863\u8bf4\u660e\u3002\u5de5\u4f5c\u8868" + sheetIndex + "_" + sheetName;
            textMap.put(title, sb.toString());
        }
        if (HussarUtils.isNotEmpty(textMap)) {
            resultMap.put("0", textMap);
        }
        LinkedHashMap picTreeMap = new LinkedHashMap();
        resultMap.put("3", picTreeMap);
        return resultMap;
    }

    public static void main(String[] args) {
        File file = new File("D:\\\u6d4b\u8bd5xlsx.xlsx");
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("type", "3");
        map.put("paragraphLength", 25);
        LocalParsingForXlsx xlsx = new LocalParsingForXlsx();
        HashMap<String, LinkedHashMap<String, String>> stringLinkedHashMapHashMap = xlsx.fileToMap(file, map);
        System.out.println(stringLinkedHashMapHashMap);
    }
}

