/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.storage.service.impl;

import cn.hutool.core.io.FileUtil;
import cn.hutool.core.lang.UUID;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.storage.bucket.BucketEnum;
import com.jxdinfo.hussar.storage.config.MinioConfig;
import com.jxdinfo.hussar.storage.dao.PicStorageMapper;
import com.jxdinfo.hussar.storage.model.PicStorage;
import com.jxdinfo.hussar.storage.service.PicStorageService;
import com.jxdinfo.hussar.storage.util.Base64TransferUtil;
import com.jxdinfo.hussar.support.exception.HussarException;
import io.minio.GetObjectArgs;
import io.minio.GetObjectResponse;
import io.minio.GetPresignedObjectUrlArgs;
import io.minio.MinioClient;
import io.minio.PutObjectArgs;
import io.minio.http.Method;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Base64;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Set;
import javax.annotation.Resource;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class PicStorageServiceImpl
implements PicStorageService {
    private static final Logger log = LoggerFactory.getLogger(PicStorageServiceImpl.class);
    @Resource
    private MinioConfig minioConfig;
    @Resource
    private MinioClient minioClient;
    @Resource
    private PicStorageMapper picStorageMapper;

    @Override
    public void uploadPic(File file, String referenceId) {
        String originalFileName = FileUtil.getName((File)file);
        String fileExtension = FileUtil.getSuffix((File)file).toLowerCase();
        String objectName = UUID.randomUUID() + "." + fileExtension;
        String type = "image/" + ("jpg".equals(fileExtension) ? "jpeg" : fileExtension);
        try {
            String bucketName = this.minioConfig.getBucket(this.minioClient, BucketEnum.PICTURE);
            log.info("Uploading file to MinIO: bucket={}, objectName={}, contentType={}, fileSize={}", new Object[]{bucketName, objectName, type, file.length()});
            this.minioClient.putObject((PutObjectArgs)((PutObjectArgs.Builder)((PutObjectArgs.Builder)PutObjectArgs.builder().bucket(bucketName)).object(objectName)).stream((InputStream)FileUtil.getInputStream((File)file), file.length(), -1L).contentType(type).build());
        }
        catch (Exception e) {
            log.error("minio \u4e0a\u4f20\u5931\u8d25, {}", (Object)e.getMessage(), (Object)e);
            throw new HussarException("minio \u4e0a\u4f20\u5931\u8d25", (Throwable)e);
        }
        PicStorage picStorage = new PicStorage();
        picStorage.setUuid(referenceId);
        picStorage.setPicName(originalFileName);
        picStorage.setPicSize(String.valueOf(file.length()));
        picStorage.setPicType(fileExtension);
        picStorage.setStatus("0");
        picStorage.setCreateTime(new Date());
        picStorage.setObjectName(objectName);
        this.picStorageMapper.insert(picStorage);
    }

    @Override
    public String getUrlFromId(String uuid) {
        String objectName = this.getObjectNameFromUUID(uuid);
        try {
            return this.minioClient.getPresignedObjectUrl((GetPresignedObjectUrlArgs)((GetPresignedObjectUrlArgs.Builder)((GetPresignedObjectUrlArgs.Builder)GetPresignedObjectUrlArgs.builder().method(Method.GET).bucket(this.minioConfig.getBucket(this.minioClient, BucketEnum.PICTURE))).object(objectName)).build());
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6 URL \u5931\u8d25", (Throwable)e);
            throw new HussarException("\u83b7\u53d6 URL \u5931\u8d25", (Throwable)e);
        }
    }

    @Override
    public String getBase64FromId(String uuid) {
        String objectName = this.getObjectNameFromUUID(uuid);
        try {
            GetObjectResponse response = this.minioClient.getObject((GetObjectArgs)((GetObjectArgs.Builder)((GetObjectArgs.Builder)GetObjectArgs.builder().bucket(this.minioConfig.getBucket(this.minioClient, BucketEnum.PICTURE))).object(objectName)).build());
            byte[] bytes = IOUtils.toByteArray((InputStream)response);
            return Base64.getEncoder().encodeToString(bytes);
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6 Base64 \u9519\u8bef", (Throwable)e);
            throw new HussarException("\u83b7\u53d6 Base64 \u9519\u8bef", (Throwable)e);
        }
    }

    @Override
    public boolean storeFileWithUUID(byte[] base64, String UUID2) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(PicStorage::getUuid, (Object)UUID2);
        if (this.picStorageMapper.selectOne((Wrapper)queryWrapper) != null) {
            log.info("\u8be5\u56fe\u7247\u5df2\u4e0a\u4f20");
            return true;
        }
        String base64String = Base64TransferUtil.deserializeByteArrayToString(base64);
        return this.convertBase64ToImageAndUpload(base64String, UUID2);
    }

    private String getObjectNameFromUUID(String uuid) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(PicStorage::getUuid, (Object)uuid);
        PicStorage picStorage = (PicStorage)this.picStorageMapper.selectOne((Wrapper)queryWrapper);
        return picStorage.getObjectName();
    }

    @Override
    public boolean convertBase64ToImageAndUpload(String base64String, String uuid) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(PicStorage::getUuid, (Object)uuid);
        if (this.picStorageMapper.selectOne((Wrapper)queryWrapper) != null) {
            log.info("\u8be5\u56fe\u7247\u5df2\u4e0a\u4f20");
            return true;
        }
        try {
            byte[] imageBytes;
            if (base64String.startsWith("data:image")) {
                base64String = base64String.substring(base64String.indexOf(",") + 1);
            }
            try {
                imageBytes = Base64.getDecoder().decode(base64String);
            }
            catch (Exception e) {
                log.info("\u8be5\u6bd4\u7279\u6570\u7ec4\u6709\u95ee\u9898");
                return true;
            }
            Path tempFile = Files.createTempFile("temp_", ".jpg", new FileAttribute[0]);
            Files.write(tempFile, imageBytes, new OpenOption[0]);
            File file = tempFile.toFile();
            this.uploadPic(file, uuid);
            file.deleteOnExit();
        }
        catch (IOException e) {
            log.error("\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25", (Throwable)e);
            e.printStackTrace();
            return false;
        }
        return true;
    }

    @Override
    public void uploadImageMap(LinkedHashMap<String, String> imageMap) {
        Set<String> keySet = imageMap.keySet();
        for (String key : keySet) {
            this.convertBase64ToImageAndUpload(imageMap.get(key), key);
        }
    }
}

