/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.storage.config;

import com.jxdinfo.hussar.storage.bucket.BucketEnum;
import io.minio.BucketExistsArgs;
import io.minio.MakeBucketArgs;
import io.minio.MinioClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConfigurationProperties(prefix="minio")
public class MinioConfig {
    private static final Logger log = LoggerFactory.getLogger(MinioConfig.class);
    private String endpoint;
    private String accessKey;
    private String secretKey;

    @Bean
    public MinioClient minioClient() {
        log.info("Initializing MinioClient with endpoint: {}, accessKey: {}", (Object)this.endpoint, (Object)this.accessKey);
        MinioClient client = MinioClient.builder().endpoint(this.endpoint).credentials(this.accessKey, this.secretKey).build();
        return client;
    }

    public String getBucket(MinioClient minioClient, BucketEnum bucketEnum) throws Exception {
        String bucket = bucketEnum.getValue();
        boolean found = minioClient.bucketExists((BucketExistsArgs)((BucketExistsArgs.Builder)BucketExistsArgs.builder().bucket(bucket)).build());
        if (!found) {
            minioClient.makeBucket((MakeBucketArgs)((MakeBucketArgs.Builder)MakeBucketArgs.builder().bucket(bucket)).build());
        }
        return bucket;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    public String getAccessKey() {
        return this.accessKey;
    }

    public void setAccessKey(String accessKey) {
        this.accessKey = accessKey;
    }

    public String getSecretKey() {
        return this.secretKey;
    }

    public void setSecretKey(String secretKey) {
        this.secretKey = secretKey;
    }
}

