/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.scenarioai.scenario.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONException;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jxdinfo.hussar.dialogue.dao.DialogueQaMapper;
import com.jxdinfo.hussar.dialogue.model.DialogueQa;
import com.jxdinfo.hussar.dialogue.service.IRecommendQuestionService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import com.jxdinfo.hussar.scenarioai.scenario.dao.QaFaqMapper;
import com.jxdinfo.hussar.scenarioai.scenario.dao.QaScenarioMapper;
import com.jxdinfo.hussar.scenarioai.scenario.model.QaFaqModel;
import com.jxdinfo.hussar.scenarioai.scenario.model.QaScenarioModel;
import com.jxdinfo.hussar.scenarioai.scenario.model.answer.DialogueAnswer;
import com.jxdinfo.hussar.scenarioai.scenario.model.answer.DocType;
import com.jxdinfo.hussar.scenarioai.scenario.model.recommend.GenerateQuestionRequest;
import com.jxdinfo.hussar.scenarioai.scenario.model.recommend.RecommendQuestionResponse;
import com.jxdinfo.hussar.scenarioai.scenario.model.recommend.RewriteQuestionRequest;
import com.jxdinfo.hussar.scenarioai.scenario.service.IQaFaqService;
import com.jxdinfo.hussar.scenarioai.scenario.service.impl.Design.RecommendStrategy;
import com.jxdinfo.hussar.support.exception.HussarException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class QaFaqServiceImpl
extends ServiceImpl<QaFaqMapper, QaFaqModel>
implements IQaFaqService {
    @Autowired
    private QaFaqMapper faqMapper;
    @Resource(name="generateQuestionFromDocStrategy")
    private RecommendStrategy generateQuestionFromDoc;
    @Resource(name="rewriteQuestionFromPatternQuestionStrategy")
    private RecommendStrategy rewriteQuestionFromPatternQuestion;
    @Resource(name="rewriteQuestionFromUserQuestionStrategy")
    private RecommendStrategy rewriteQuestionFromUserQuestion;
    @Resource
    private DialogueQaMapper dialogueQaMapper;
    @Resource
    private QaScenarioMapper qaScenarioMapper;
    @Resource
    private IRecommendQuestionService iRecommendQuestionService;

    @Override
    public void saveFaq(Long scenarioId, List<QaFaqModel> questions) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(QaFaqModel::getScenarioId, (Object)scenarioId);
        this.faqMapper.delete((Wrapper)queryWrapper);
        if (CollectionUtils.isEmpty(questions)) {
            return;
        }
        List faqList = questions.stream().filter(v -> !StringUtils.isEmpty((Object)v.getQuestion())).map(v -> {
            QaFaqModel qaFaqModel = new QaFaqModel();
            qaFaqModel.setQuestion(v.getQuestion());
            qaFaqModel.setScenarioId(scenarioId);
            return qaFaqModel;
        }).collect(Collectors.toList());
        this.saveBatch(faqList);
    }

    @Override
    public List<QaFaqModel> getFaq(Long scenarioId) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.eq(QaFaqModel::getScenarioId, (Object)scenarioId)).orderByAsc(QaFaqModel::getQuestionId);
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public IPage<QaFaqModel> getFaqList(Page<QaFaqModel> page, Long scenarioId) {
        HussarException.throwByNull((Object)scenarioId, (String)"\u573a\u666fId\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(QaFaqModel::getScenarioId, (Object)scenarioId);
        queryWrapper.orderByAsc(QaFaqModel::getQuestionId);
        return this.faqMapper.selectPage((IPage)page, (Wrapper)queryWrapper);
    }

    @Override
    public RecommendQuestionResponse generateQuestionFromDoc(GenerateQuestionRequest generateQuestionRequest) {
        return this.generateQuestionFromDoc.execute(generateQuestionRequest);
    }

    @Override
    public RecommendQuestionResponse rewriteQuestionFromPatternQuestion(RewriteQuestionRequest rewriteQuestionRequest) {
        return this.rewriteQuestionFromPatternQuestion.execute(rewriteQuestionRequest);
    }

    @Override
    public RecommendQuestionResponse rewriteQuestionFromUserQuestion(String question) {
        return this.rewriteQuestionFromUserQuestion.execute(question);
    }

    @Override
    public List<String> getRecommendQuestionListFromResponse(RecommendQuestionResponse recommendQuestionResponse) {
        if (recommendQuestionResponse == null) {
            throw new HussarException("\u6a21\u578b\u7aef\u672a\u8fd4\u56de\u6b63\u786e\u7ed3\u679c\uff01");
        }
        ArrayList<String> questions = new ArrayList<String>();
        for (RecommendQuestionResponse.RecommendedQuestion question : recommendQuestionResponse.getRecommendedQuestions()) {
            questions.add(question.getQuestion());
        }
        return questions;
    }

    @Override
    public ApiResponse<List<String>> getQuestionsByDialogueId(Long dialogueId) {
        QueryWrapper qa = new QueryWrapper();
        qa.eq((Object)"dialogue_id", (Object)dialogueId);
        List qaList = this.dialogueQaMapper.selectList((Wrapper)qa);
        HussarException.throwByNull((Object)qaList, (String)"\u65e0\u5bf9\u8bdd\u8bb0\u5f55\uff01");
        DialogueQa dialogueQa = (DialogueQa)qaList.get(qaList.size() - 1);
        Long scenarioId = dialogueQa.getScenarioId();
        QaScenarioModel qaScenarioModel = (QaScenarioModel)((Object)this.qaScenarioMapper.selectById(scenarioId));
        HussarException.throwByNull((Object)((Object)qaScenarioModel), (String)"\u672a\u627e\u5230\u5173\u8054\u573a\u666f\uff01");
        if (qaScenarioModel.getAutoRecommend().equals(Character.valueOf('0'))) {
            return ApiResponse.fail((String)"\u672a\u5f00\u542f\u81ea\u52a8\u8ffd\u95ee");
        }
        DialogueAnswer dialogueAnswer = QaFaqServiceImpl.parseAnswerIntoObject(dialogueQa.getAnswers());
        List<String> modelQuestions = this.getFaq(scenarioId).stream().map(QaFaqModel::getQuestion).collect(Collectors.toList());
        Result result = this.getQuestionListsFromAnswer(dialogueAnswer, modelQuestions);
        this.iRecommendQuestionService.saveRecommendQuestion(dialogueId, result.recommendQuestionList);
        return ApiResponse.success(result.recommendQuestionList, (String)result.msg);
    }

    @Override
    public ApiResponse<List<String>> getQuestionsByAnswerAndModel(String answer, List<String> modelQuestions) {
        DialogueAnswer dialogueAnswer = QaFaqServiceImpl.parseAnswerIntoObject(answer);
        Result result = this.getQuestionListsFromAnswer(dialogueAnswer, modelQuestions);
        return ApiResponse.success(result.recommendQuestionList, (String)result.msg);
    }

    private Result getQuestionListsFromAnswer(DialogueAnswer dialogueAnswer, List<String> questions) {
        HussarException.throwByNull((Object)dialogueAnswer, (String)"\u89e3\u6790\u56de\u7b54\u5931\u8d25");
        RecommendQuestionResponse recommendQuestionResponse = null;
        String msg = "\u95ee\u9898\u63a8\u8350\u5931\u8d25";
        if (!dialogueAnswer.getisUserOnline().booleanValue()) {
            if (CollectionUtils.isEmpty(dialogueAnswer.getdoc())) {
                if (!CollectionUtils.isEmpty(questions)) {
                    RewriteQuestionRequest request = new RewriteQuestionRequest();
                    request.setCommonQuestions(questions);
                    recommendQuestionResponse = this.rewriteQuestionFromPatternQuestion(request);
                    msg = "\u65e0\u53c2\u8003\u6587\u6863\uff1a\u6309\u7167\u6a21\u677f\u95ee\u9898\u8fdb\u884c\u63a8\u8350";
                }
            } else {
                GenerateQuestionRequest generateQuestionRequest = this.buildRequest(dialogueAnswer);
                recommendQuestionResponse = this.generateQuestionFromDoc(generateQuestionRequest);
                msg = "\u6709\u53c2\u8003\u6587\u6863\uff1a\u6309\u7167\u7528\u6237\u95ee\u9898\u548c\u6587\u6863\u5185\u5bb9\u8fdb\u884c\u63a8\u8350";
            }
        }
        if (dialogueAnswer.getisUserOnline().booleanValue() || recommendQuestionResponse == null) {
            if (!dialogueAnswer.getisUserOnline().booleanValue()) {
                return new Result("\u65e0\u63a8\u8350\u95ee\u9898", new ArrayList<String>());
            }
            msg = "\u8054\u7f51\u641c\u7d22\uff1a\u6309\u7167\u7528\u6237\u6700\u8fd1\u63d0\u95ee\u8fdb\u884c\u63a8\u8350";
            String question = dialogueAnswer.getdata().getcontent();
            recommendQuestionResponse = this.rewriteQuestionFromUserQuestion(question);
        }
        List<String> recommendQuestionList = this.getRecommendQuestionListFromResponse(recommendQuestionResponse);
        return new Result(msg, recommendQuestionList);
    }

    private GenerateQuestionRequest buildRequest(DialogueAnswer dialogueAnswer) {
        GenerateQuestionRequest request = new GenerateQuestionRequest();
        ArrayList<String> userQuestion = new ArrayList<String>();
        userQuestion.add(dialogueAnswer.getdata().getcontent());
        request.setUserQuestions(userQuestion);
        ArrayList<GenerateQuestionRequest.ReferenceSnippet> snippets = new ArrayList<GenerateQuestionRequest.ReferenceSnippet>();
        for (DocType docType : dialogueAnswer.getdoc()) {
            GenerateQuestionRequest.ReferenceSnippet snippet = new GenerateQuestionRequest.ReferenceSnippet();
            String similarity = docType.getsimilarity();
            if (StringUtil.isEmpty((Object)similarity)) {
                similarity = "0.2";
            }
            snippet.setRelevanceScore(Double.parseDouble(similarity));
            snippet.setSource(docType.getdoc());
            snippet.setContent(docType.getcontent());
            snippets.add(snippet);
        }
        request.setReferenceSnippets(snippets);
        return request;
    }

    private static DialogueAnswer parseAnswerIntoObject(String answer) {
        DialogueAnswer dialogueAnswer = null;
        try {
            dialogueAnswer = (DialogueAnswer)JSON.parseObject((String)answer, DialogueAnswer.class);
        }
        catch (JSONException e) {
            throw new HussarException("\u5bf9\u8bdd\u5386\u53f2\u8bb0\u5f55\u683c\u5f0f\u51fa\u9519\uff01");
        }
        return dialogueAnswer;
    }

    private static class Result {
        public final String msg;
        public final List<String> recommendQuestionList;

        public Result(String msg, List<String> recommendQuestionList) {
            this.msg = msg;
            this.recommendQuestionList = recommendQuestionList;
        }
    }
}

